import biss.*;
import biss.awt.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.*;

public class T9
  extends TopWindow
  implements ImageObserver, Runnable
{
	Image Img;
	int W;
	int H;
	HScrollBar XSlider;
	HScrollBar YSlider;
	Label XLbl;
	Label YLbl;
	int W0;
	int H0;
	int Wlast;
	int Hlast;

public T9 ( String title, String gifName ) {
	super(title);

	Img = getToolkit().getImage( gifName);
	Layouter gm = new Layouter( this);

	XSlider = new HScrollBar( 0, 300, 100);
	YSlider = new HScrollBar( 0, 300, 100);	

	XLbl = new Label();
	YLbl = new Label();

	gm.add( XSlider, 0, 1000, 700, 1000, true, 100, -400,   0, -300,  0);
	gm.add( YSlider, 0, 1000, 700, 1000, true, 100, -200,   0, -100,  0);
	gm.add( XLbl,  700, 1000, 700, 1000, true,  50, -420, 350, -280,  0);
	gm.add( YLbl,  700, 1000, 700, 1000, true,  50, -220, 350,  -80,  0);

	openIn( 100, 100, 300, 300);

	XSlider.setPageIncrement( 1);
	YSlider.setPageIncrement( 1);

	XSlider.OsScroll.addObserver( this);
	YSlider.OsScroll.addObserver( this);

	XLbl.setContents( "100");
	YLbl.setContents( "100");

	Thread watcher = new Thread( this);
	watcher.setPriority( Thread.MIN_PRIORITY);
	watcher.start();
}

public boolean imageUpdate ( Image img, int flags, int x, int y, int w, int h ){

	if ( flags == (ImageObserver.WIDTH | ImageObserver.HEIGHT) ) {
		W = W0 = w;
		H = H0 = h;
		repaint();
	}

	if ( (flags & ImageObserver.ALLBITS) > 0 )
		repaint();

	return true;
}

public static void main ( String[] args ) {
	T9 v = new T9( "image scaling", args[0]);
}

public void paint ( Graphics g ) {
	Dimension size = size();
	Insets in = insets();
	Color bg = getBackground();
	int x, y, w, h;

	if ( (w = Img.getWidth( this)) < 0 ) return;
	if ( (h = Img.getHeight( this)) < 0 ) return;

	x = in.left + 10;
	y = in.top + 10;

	g.drawImage( Img, x, y, W, H, bg, this);
	g.drawRect( x, y, W, H);

	g.setColor( bg);

	if ( Wlast > W )
		g.fillRect( x+W+1, y, Wlast - W, Hlast+1);

	if ( Hlast > H )
		g.fillRect( x, y+H+1, Wlast+1, Hlast - H);

	Wlast = W;
	Hlast = H;
}

public void run () {
	while ( true ) {
		if ( W != Wlast || H != Hlast )
			repaint();
		try { Thread.sleep( 100); } catch ( Exception ex ) {}
	}
}

public void update ( Observable obs, Object arg ) {
	int pos;

	if ( obs == XSlider.OsScroll ) {
		pos = XSlider.getPosition();
		XLbl.setContents( Integer.toString( pos));
		if ( W0 > 0 ) {
			W = W0 * pos / 100;
		}
	}
	else if ( obs == YSlider.OsScroll ) {
		pos = YSlider.getPosition();
		YLbl.setContents( Integer.toString( pos));
		if ( H0 > 0 ) {
			H = H0 * pos / 100;
		}
	}
}
}
