import java.awt.*;

public class T2
  extends Frame
{
	static Font fnt = new Font( "Helvetica", Font.BOLD, 12);
	Font f1 = new Font( "Helvetica", Font.BOLD, 12);
	Font f2 = new Font( "Dialog", Font.PLAIN, 13);
	Font f3 = new Font( "TimesRoman", Font.ITALIC, 14);
	Font f4 = new Font( "Symbol", Font.BOLD, 12);
	Font f5 = new Font( "-b&h-lucidatypewriter-", Font.PLAIN, 13);
	FontMetrics fm1 = Toolkit.getDefaultToolkit().getFontMetrics( f1);
	FontMetrics fm2 = Toolkit.getDefaultToolkit().getFontMetrics( f2);
	FontMetrics fm3 = Toolkit.getDefaultToolkit().getFontMetrics( f3);
	FontMetrics fm4 = Toolkit.getDefaultToolkit().getFontMetrics( f4);
	Graphics gr;
	int x;
	int y;

public T2 ( String title ) {
	super( title);
}

String eventName ( int id ) {
	switch ( id ) {
	case Event.WINDOW_DESTROY:     return "WINDOW_DESTROY     ";
	case Event.WINDOW_EXPOSE:      return "WINDOW_EXPOSE      ";
	case Event.WINDOW_MOVED:       return "WINDOW_MOVED       ";
	case Event.KEY_PRESS:          return "KEY_PRESS          ";
	case Event.KEY_RELEASE:        return "KEY_RELEASE        ";
	case Event.KEY_ACTION:         return "KEY_ACTION         ";
	case Event.KEY_ACTION_RELEASE: return "KEY_ACTION_RELEASE ";
	case Event.MOUSE_DOWN:         return "MOUSE_DOWN         ";
	case Event.MOUSE_UP:           return "MOUSE_UP           ";
	case Event.MOUSE_ENTER:        return "MOSUE_ENTER        ";
	case Event.MOUSE_EXIT:         return "MOUSE_EXIT         ";
	case Event.MOUSE_MOVE:         return "MOUSE_MOVE         ";
	case Event.MOUSE_DRAG:         return "MOUSE_DRAG         ";
	case Event.GOT_FOCUS:          return "GOT_FOCUS          ";
	case Event.LOST_FOCUS:         return "LOST_FOCUS         ";
	}
	return "? " + id;
}

public boolean handleEvent ( Event e ) {

	/*
	  System.out.print( eventName(e.id));
	  // System.out.print( " when: " + e.when);
	  System.out.print( " x: " + e.x + " y: " + e.y);
	  System.out.print( " key: " + e.key + " mod: " + e.modifiers);
	  System.out.println( " click: " + e.clickCount);
	 */

	switch ( e.id ) {
	case Event.MOUSE_MOVE:
		if ( gr == null ) {
			gr = getGraphics();
			gr.setColor( Color.lightGray);
			gr.setXORMode( Color.red);
		}
		else 
			gr.drawLine( 0, 0, x, y);

		x = e.x;  y = e.y;
		gr.drawLine( 0, 0, x, y);
		break;
	case Event.WINDOW_DESTROY:
		dispose();
		System.exit(0);
		return true;
	}

	return false;
}

public static void main ( String[] args ) {
	T2 f = new T2( "T2");
	f.reshape( 100, 100, 200, 200);
	f.show();

	f.setCursor( Frame.CROSSHAIR_CURSOR);
}

public void paint ( Graphics g ) {
	int w;
	Rectangle r = bounds();
	// System.out.println( "bounds: " + r);

	g.setColor( Color.red);
	g.fillRect( 0, 0, r.width+1, r.height+1);

	g.setColor( Color.yellow);
	g.drawOval( r.width / 2 - 15, r.height / 2 - 15, 30, 30);
	g.fillArc( r.width / 2 - 15, r.height / 2 - 15, 30, 30, -45*64, -90*64);

	g.setColor( Color.blue);
	g.fillRoundRect( 80, 150, 40, 20, 20, 20);

	g.setColor( Color.yellow);
	g.drawRoundRect( 80, 150, 40, 20, 20, 20);

	g.setColor( Color.black);
	g.drawLine( 0, 0, r.width, r.height);
	g.drawLine( 0, r.height, r.width, 0);

	g.setFont( f1);
	g.drawString( f1.getName(), 20, 20);
	w = fm1.stringWidth( f1.getName());
	g.drawLine( 20+w, 20- fm1.getAscent(), 20+w, 20+fm1.getDescent());  

	g.setFont( f2);
	g.drawString( f2.getName(), 20, 40);
	w = fm2.stringWidth( f2.getName());
	g.drawLine( 20+w, 40- fm2.getAscent(), 20+w, 40+fm2.getDescent());  

	g.setFont( f3);
	g.drawString( f3.getName(), 20, 60);
	w = fm3.stringWidth( f3.getName());
	g.drawLine( 20+w, 60- fm3.getAscent(), 20+w, 60+fm3.getDescent());  

	g.setFont( f4);
	g.drawString( f4.getName(), 20, 80);
	w = fm4.stringWidth( f4.getName());
	g.drawLine( 20+w, 80- fm4.getAscent(), 20+w, 80+fm4.getDescent());  


	g.setFont( f5);
	g.drawString( f5.getName(), 20, 100);
}
}
