package biss.awt.kernel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.peer.ComponentPeer;

/**
 * This is the wrapper class for all exported functions of the native lib,
 * i.e. it is the only interface of the native lib to the biss.awt.kernel
 * classes. It does not contain anything else than just native methods.
 *
 * This structure was choosen to enable implementations of certain platforms
 * to make use of the Java internal synchronization mechanisms (all methods
 * are synchronized). Unfortunately, this is not true for the kaffe / X
 * implementation (which has to do the synchronization, because of its
 * user level threads, from within the native lib).
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class NativeLib
{
	boolean SyncHint = false;
	boolean HasKernelThreads = false;
	boolean UseBackingStore = true;
	int Width;
	int Height;
	int Resolution;
	java.awt.Toolkit Tk;
	int VisualClass;
	int EventsAvailable;
	Event NextEvent = new Event( null, 0, null);
	Object RecycledPeer;
	Object[] PeerTable;
	String Name;
	boolean AttentionHint = false;
	boolean PopDownHint = false;
	long PData;
	boolean ShrinkFrame;

static {
	//	System.load( "/home/jhm/biss/src/biss/awt/kernel/X/libbissawt.so");
	System.loadLibrary ("bissawt");
}

NativeLib ( java.awt.Toolkit tk, String name, Object[] peerTable, Object recycledPeer ) {
	Tk = tk;
	RecycledPeer = recycledPeer;
	PeerTable = peerTable;
	Name = name;

	UseBackingStore = Kernel.UseBackingStore;
	ShrinkFrame = Kernel.ShrinkFrame;
}

final native synchronized void clearRect ( java.awt.Graphics g, int x, int y, int width, int height );

final native synchronized void clipGraphics ( java.awt.Graphics g );

final native synchronized void copyArea ( java.awt.Graphics g,
                int x, int y, int width, int height, int dx, int dy );

final native synchronized void createWindow ( ComponentPeer window );

final native synchronized void destroyWindow ( ComponentPeer wnd );

final native synchronized void draw3DRect ( java.awt.Graphics g, int x, int y, int width, int height,
                  boolean raised, int borderWidth, Color bright, Color dark );

final native synchronized void drawArc ( java.awt.Graphics g,
               int x, int y, int width, int height,
               int startAngle, int arcAngle );

final native synchronized void drawChars ( java.awt.Graphics g, char data[], int offset, int length, int x, int y);

final native synchronized void drawImage ( java.awt.Graphics g, java.awt.Image img,
                 int x, int y, int width, int height, Color background );

final native synchronized void drawLine ( java.awt.Graphics g, int x1, int y1, int x2, int y2 );

final native synchronized void drawOval ( java.awt.Graphics g, int x, int y, int width, int height );

final native synchronized void drawPolygon ( java.awt.Graphics g, int xPoints[], int yPoints[], int nPoints);

final native synchronized void drawRect ( java.awt.Graphics g, int x, int y, int width, int height );

final native synchronized void drawRoundRect ( java.awt.Graphics g,
                     int x, int y, int width, int height,
                     int arcWidth, int arcHeight );

final native synchronized void drawString ( java.awt.Graphics g, String str, int x, int y );

final native synchronized void fillArc ( java.awt.Graphics g,
               int x, int y, int width, int height,
               int startAngle, int arcAngle );

final native synchronized void fillOval ( java.awt.Graphics g, int x, int y, int width, int height );

final native synchronized void fillPolygon ( java.awt.Graphics g, int xPoints[], int yPoints[], int nPoints);

final native synchronized void fillRect ( java.awt.Graphics g, int x, int y, int width, int height );

final native synchronized void fillRoundRect ( java.awt.Graphics g,
                     int x, int y, int width, int height,
                     int arcWidth, int arcHeight );

final native synchronized int getNextEvent ();

final native synchronized Color getTargetBackground ( Component target );

final native synchronized Font getTargetFont ( Component target );

final native synchronized Color getTargetForeground ( Component target );

final native synchronized void hideWindow ( ComponentPeer wnd );

final native synchronized void initBlankImage ( java.awt.Image image, int width, int height );

final native synchronized void initFontMetrics ( java.awt.FontMetrics metrics );

final native synchronized void initGraphics ( java.awt.Graphics g );

final native synchronized void initPaintGraphics ( java.awt.Graphics g );

final native synchronized void initStdColor ( Color clr );

final native synchronized void initialize ();

final native synchronized void lowerWindow ( ComponentPeer wnd );

final native synchronized void raiseWindow ( ComponentPeer wnd );

final native synchronized void releaseFontMetrics ( java.awt.FontMetrics metrics );

final native synchronized void releaseGraphics ( java.awt.Graphics g );

final native synchronized void releaseImage ( java.awt.Image img );

final native synchronized void releasePaintGraphics ( java.awt.Graphics g );

final native synchronized void repaintWindow ( ComponentPeer wnd, long timeout,
                     int x, int y, int width, int height );

final native synchronized void reshapeWindow ( ComponentPeer wnd, int x, int y, int width, int height );

final native synchronized void setColor ( java.awt.Graphics g, Color clr );

final native synchronized void setDebugLevel ( int level );

final native synchronized void setFocusWindow ( ComponentPeer wnd );

final native synchronized void setFont ( java.awt.Graphics g, Font font );

final native synchronized void setPaintMode ( java.awt.Graphics g );

final native synchronized void setStdFontSpec ( int key, String font );

final native synchronized void setWindowBackground ( ComponentPeer wnd, Color clr );

final native synchronized void setWindowCursor ( ComponentPeer wnd, int cursorType );

final native synchronized void setWindowTitle ( ComponentPeer wnd, String title );

final native synchronized void setXORMode ( java.awt.Graphics g );

final native synchronized void showWindow ( ComponentPeer wnd );

final native synchronized int stringWidth ( java.awt.FontMetrics metrics, String str );

final native synchronized void sync ();
}
