package biss.awt;

import biss.CommandQueue;
import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/* (/** causes javac to fail)
 * generic event handling support for biss.awt classes.
 * Adapts to specific clients by examining their interfaces
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class GUIHandler
{
	int CursorType = Frame.DEFAULT_CURSOR;
	boolean HasFocus = false;
	Hashtable HotKeys = null;
	Vector MenuCont = null;
	ObserverSocket OsCommand;
	ObserverSocket OsFocusGot;
	ObserverSocket OsFocusLost;
	ObserverSocket OsMouseEnter;
	ObserverSocket OsMouseExit;
	ObserverSocket OsMouseBtn;
	Component OC = null;
	Frame Fr;
	FocusInterface Fi = null;
	KbdInterface Ki = null;
	MouseInterface Mi = null;
	CmdInterface Ci = null;
	MenuWindow PopUpWnd = null;
	GUIHandler Super = null;
	boolean IsDisabled = false;
	static GUIHandler LastFocusHandler = null;
	static SingleInstInterface SingleInstWnd = null;
	static GUIHandler CurrentFocusHandler = null;
	static GUIHandler CurrentMouseHandler = null;
	int SkipEvent = 0;

public GUIHandler (Component owner) {
	OC    = owner;

	if ( owner instanceof KbdInterface){
		Ki = (KbdInterface)owner;
	}
	if ( owner instanceof FocusInterface){
		Fi = (FocusInterface)owner;
		OsFocusGot = Fi.getOsFocusGot();
		OsFocusLost = Fi.getOsFocusLost();
	}
	if ( owner instanceof MouseInterface){
		Mi = (MouseInterface)owner;
		OsMouseEnter = Mi.getOsMouseEnter();
		OsMouseExit = Mi.getOsMouseExit();
		OsMouseBtn = Mi.getOsMouseBtn();
	}
	if ( owner instanceof CmdInterface){
		Ci = (CmdInterface)owner;
		OsCommand = Ci.getOsCommand();
	}
}

public boolean addHotKey( int c, int mods, HotKeyProcessor p, Object sel){
	int key = Key.isShiftDown( mods) ? (c | 32) : c;
	HotKey hk = new HotKey( key, mods, p, sel);
	if ( HotKeys == null)
		HotKeys = new Hashtable( 5);
	if ( HotKeys.containsKey( hk.HashCode))
		return false;
	HotKeys.put( hk.HashCode, hk);
	return true;
}

void checkDefaultKey( int key, int mod ){
	switch( key) {
	case Key.Tab:
		// (lone/alt/ctrl) + tab to step forward
		if (mod != 1 ) FocusHandler.focusNext( Fr);
		// shift + tab to step backwards
		else           FocusHandler.focusPrev( Fr); 
		break;
	case 'm':
		if ( mod == 2)
			popUpMenuAt( 0, 0);
		break;
	}
}

boolean checkHotKey( int key, int mod ){
	Integer ik;
	HotKey  hk;

	if ( (HotKeys != null) && ( !HotKeys.isEmpty())){
		ik = new Integer( key + mod*256);
		if ( HotKeys.containsKey( ik)) {
			hk = (HotKey)HotKeys.get( ik);
			if ( ! hk.process() ) {
				OsCommand.notifyObservers( hk.Selector);
			}
			return true;
		}
	}

	if ( Super != null)
		return Super.checkHotKey( key, mod);

	return false;
}

void closeMenu(){
	if ( PopUpWnd != null)
		PopUpWnd.cancel();
}

public static Component currentFocusOwner () {
	return ( CurrentFocusHandler != null ) ? CurrentFocusHandler.OC : null;
}

public boolean disposeSingleInstWnd () {
	return disposeSingleInstWnd( OC );
}

public static boolean disposeSingleInstWnd ( Component co) {
	Awt.DefToolkit.sync();

	if ( SingleInstWnd != null){
		if ( SingleInstWnd.disposeRequest( co)) {
			SingleInstWnd = null;
			return true;
		}
	}
	return false;
}

public Vector getMenu(){
	return MenuCont;
}

public boolean handleEvent( Event evt) {
	//  	if ( evt.key != 0)
	//   	  System.out.println( "charInput: " + (char)evt.key +
	//  		" val: " + evt.key + " mod: " + evt.modifiers +
	//  		" id: " + evt.id); 	

	if ( evt.id == SkipEvent ) {
		SkipEvent = 0;
		return true;
	}

	switch ( evt.id) {
	
	case Event.GOT_FOCUS:
		HasFocus = true;
		if ( OC == evt.target ) {
			GUIHandler last = CurrentFocusHandler;
			if ( LastFocusHandler != null &&      // check if for some reason the GUI did
			     LastFocusHandler != this &&      // mess up the focus event order.
			     LastFocusHandler.HasFocus ) {    // We enforce a lostFocus -> gotFocus
				LastFocusHandler.HasFocus = false;  // order to make things more portable
				LastFocusHandler.OsFocusLost.notifyObservers();
				if ( LastFocusHandler.Fi != null )
					LastFocusHandler.Fi.lostFocus();
			}
			CurrentFocusHandler = this;
			LastFocusHandler = last;
		}
		
		if ( Fi != null)
			Fi.gotFocus();
		OsFocusGot.notifyObservers();
		return false;                           // false passes to frame
		
	case Event.LOST_FOCUS:
		if ( HasFocus ) {                       // maybe we got the new gotFocus first
			HasFocus = false;                     // don't depend on event order (see above)
//			if ( OC.isShowing() ) {               // OS2 bug workaround
				OsFocusLost.notifyObservers();
				if ( Fi != null)
					Fi.lostFocus();
//			}
		}
		return false;                           // false passes to frame
		
	case Event.KEY_ACTION_RELEASE:
	case Event.KEY_RELEASE:
		Key.ActiveKey = 0;
		return true;
		
	case Event.KEY_ACTION:
	case Event.KEY_PRESS:
		if (IsDisabled )
			return true;

		if ( Ki == null) 
			return false;

		int mk = evt.key;

		if ( evt.controlDown() ) {
			if ( Awt.AwtToolkit == Awt.TK_OS2){
				if ( evt.shiftDown() )
					mk |= 32;				                 // toLower
			}

			if ( (mk >= 1) && (mk <= 26))
				mk += 96;                          // toLower
			else // Windows alt-gr workaround (has controlDown !)
				Ki.charInput( (char) mk, evt.modifiers);
		}

		Key.ActiveKey = mk;

		if ( evt.modifiers < 2) {             // single or shift key ?
			if ( Key.isAlphaNumKey( mk) ){
				Ki.charInput( (char) mk, evt.modifiers);
				return true;
			}
		}	

		if ( ! Ki.vKeyInput( mk, evt.modifiers) ){  // hardwired or used in socket
			if ( ! checkHotKey( mk, evt.modifiers) )
				checkDefaultKey( mk, evt.modifiers);
		}

		return true;
		
	case Event.MOUSE_DOWN:
		if ( IsDisabled )
			return true;

		if ( Awt.AwtToolkit == Awt.TK_OS2 || Awt.AwtToolkit == Awt.TK_WIN ) {
			SkipEvent = Event.MOUSE_DRAG;
		}

		if ( SingleInstWnd != null ) {
			if ( !isSingleInstWndOwner( Fr) ) {
				disposeSingleInstWnd();
				SkipEvent = Event.MOUSE_UP;
				return true;
			}
			disposeSingleInstWnd();
		}

		if ( CurrentMouseHandler != this )
			return true;

		if ( !HasFocus && Fi != null )
			Fi.setFocus();
	
		if ( Mi == null)
			return false;

		if ( evt.modifiers == 4){
			Mouse.down( 2, evt.clickCount);
			Mi.mouse2Down( evt);
		}	
		else {
			Mouse.down( 1, evt.clickCount);
			Mi.mouse1Down( evt);
		}
		if ( PopUpWnd != null)
			PopUpWnd.toFront();
		OsMouseBtn.notifyObservers( evt);	
		return true;
		
	case Event.MOUSE_UP:
		if (IsDisabled )
			return true;

		if ( Awt.AwtToolkit == Awt.TK_WIN) {
			if ( (evt.x == -1) && (evt.y == -1)) {
				SkipEvent = Event.MOUSE_DOWN;
				return true;
			}
		}

		if ( CurrentMouseHandler != this )
			return true;

		if ( Mi == null)
			return false;

		Mouse.up();

		if ( Mouse.is1Active() ){
			Mi.mouse1Up( evt);
			if ( Mouse.wasDblClicked() )
				Mi.mouse1DblClick( evt);
			else if ( Mouse.wasClicked() )
				Mi.mouse1Click( evt);
		}
		else if ( Mouse.is2Active() ) {
			Mi.mouse2Up( evt);
			if ( Mouse.wasDblClicked() )
				Mi.mouse2DblClick( evt);
			else if ( Mouse.wasClicked() ) {
				popUpMenuAt( evt.x - 10, evt.y - 10);
				Mi.mouse2Click( evt);
			}
		}
		OsMouseBtn.notifyObservers( evt);
		Mouse.reset();
		return true;
		
	case Event.MOUSE_MOVE:
		if ( CurrentMouseHandler != this ) {    // justified Windows paranoia
			if ( CurrentMouseHandler != null ) {
				if ( CurrentMouseHandler.Fr == OC ) // Windows sometimes sends
					return true;      // move events to the target AND its Frame
				CurrentMouseHandler.OsMouseExit.notifyObservers();
				if ( CurrentMouseHandler.Mi != null )
					CurrentMouseHandler.Mi.mouseExit( evt);
			}

			CurrentMouseHandler = this;		
			OsMouseEnter.notifyObservers();
			if ( OC.isEnabled() )
				Fr.setCursor( CursorType );
			if ( Mi != null)
				Mi.mouseEnter( evt);
		}

		if ( Mi != null)
			Mi.mouseMove( evt);
		
		// Owner.setCursor( CursorType);
		return true;
		
	case Event.MOUSE_ENTER:
		if ( evt.target != OC )
			return true;
			
		if ( CurrentMouseHandler != null && CurrentMouseHandler != this ) {
			CurrentMouseHandler.OsMouseExit.notifyObservers();
			if ( CurrentMouseHandler.Mi != null )
				CurrentMouseHandler.Mi.mouseExit( evt);
		}
		CurrentMouseHandler = this;

		OsMouseEnter.notifyObservers();
		
		if ( OC.isEnabled() )
			Fr.setCursor( CursorType );
			
		if ( Mi != null)
			Mi.mouseEnter( evt);
			
		return true;
		
	case Event.MOUSE_EXIT:
		//  Owner.setCursor( Frame.DEFAULT_CURSOR);
		if ( CurrentMouseHandler == this ) {
			OsMouseExit.notifyObservers();
			if ( Mi != null)
				Mi.mouseExit( evt);
			CurrentMouseHandler = null;
		}
		return true;
		
	case Event.MOUSE_DRAG:
		if ( evt.target != OC )
			return true;

		if ( Mi == null)
			return false;
		if ( Mouse.is1Active() )
			Mi.mouse1Drag( evt);
		else
			Mi.mouse2Drag( evt);
		OsMouseBtn.notifyObservers( evt);
		return true;
	}

	return false;
}

public static boolean hasSingleInstWnd () {
	return (SingleInstWnd != null);
}

public HotKey hotKeyAt( int key, int mod ){
	Integer ik;

	if ( (HotKeys == null) || (HotKeys.isEmpty()) )
		return null;

	ik = new Integer( key + mod * 256);

	return ((HotKey)HotKeys.get( ik));
}

public static boolean isSingleInstWndOwner ( Frame owner ) {
	if ( SingleInstWnd == null )
		return false;
	else
		return ( ((Window)SingleInstWnd).getParent() == owner );
}

public static Component lastFocusOwner () {
	return ( LastFocusHandler != null ) ? LastFocusHandler.OC : null;
}

void menuClosed ( boolean restoreFocus ){
	PopUpWnd = null;
	SingleInstWnd = null;

	if ( Fi != null && restoreFocus )
		Fi.setFocus();
}

boolean popUpMenuAt( int x, int y){
	Point	pt;

	if ( PopUpWnd != null){
		PopUpWnd.toFront();
		return false;
	}

	if ( MenuCont == null)
		return false;

	pt = Awt.getDesktopLocation( OC, x, y);

	PopUpWnd = new MenuWindow( Fr, this);
	PopUpWnd.setContents( MenuCont);
	PopUpWnd.popUpAt( pt.x, pt.y);

	// simple toFront() not sufficient because of popmenu invoke in inactive toplevels
	Awt.DefToolkit.sync();
	CommandQueue.append( new ToFrontCmd( PopUpWnd));
	SingleInstWnd = PopUpWnd;

	return true;
}

public boolean removeHotKey( int c, int mods) {
	Integer   key;

	if ( HotKeys == null)
		return false;

	key = new Integer( c + mods * 256);

	if ( ! HotKeys.containsKey( key))
		return false;

	HotKeys.remove( key);
	return true;
}

public void setMenu( Vector v){
	MenuCont = v;
}
}

class MenuWindow
  extends java.awt.Window
  implements SingleInstInterface
{
	int BorderWidth = 2;
	Vector Choices = null;
	FontMetrics Fm;
	int ItemHeight;
	GUIHandler Owner;
	MenuWindow Parent = null;
	MenuItem Selection = null;
	int SepHeight = 4;
	MenuWindow SubPane = null;
	int TYOffs;
	Frame UserFrame = null;
	static FontMetrics DefFm;
	boolean RestoreFocus = true;

static {
	DefFm = Awt.getFontMetrics( Awt.MenuFont);
}

public MenuWindow( Frame userFrame, GUIHandler gh) {
	super( userFrame );
	UserFrame = userFrame;
	Owner = gh;
	setFont( null);
}

public MenuWindow( MenuWindow mw) {

	super(mw.UserFrame);

	UserFrame = mw.UserFrame;
	Owner     = mw.Owner;
	Parent    = mw;

	setFont( null);
}

void cancel( ) {
	if ( (Selection != null) && (! Selection.isDisabled()) ){
		redrawItem( Selection, true);
		Awt.DefToolkit.sync();
		try { Thread.sleep( 50); } catch ( Exception x ) {}

		// make sure popup is closed before command is executed because
		// the command could bring up another topwindow (requesting the focus)
		// while the popup is trying to restore the focus to its owner
		topPane().dispose();
		Awt.DefToolkit.sync();
		
		Owner.OsCommand.notifyObservers( Selection.getSelector() );
		Owner.Fr.deliverEvent( new Event( Owner.Fr, Event.ACTION_EVENT, Selection.getSelector() ));
		Selection = null;
	}
	else {
		topPane().dispose();
	}
}

public void dispose() {
	if ( Parent == null){
		for ( MenuWindow mw = SubPane; mw != null; mw = mw.SubPane)
			mw.dispose();
		Owner.menuClosed( RestoreFocus);
	}
	super.dispose();
}

public boolean disposeRequest( Component nextFocus) {
	RestoreFocus = false;
	dispose();
	return true;
}

void disposeSubMenus() {
	for ( MenuWindow mw = SubPane; mw != null; mw = mw.SubPane)
		mw.dispose();
	SubPane = null;
	requestFocus();
}

public boolean handleEvent(Event evt) {

	MenuItem mi = itemAt( evt.y );

	switch( evt.id) {
	case Event.MOUSE_DRAG:
	case Event.MOUSE_MOVE:		
		if ( evt.modifiers == 0){
			if ( (evt.x != -1) || (evt.y != -1) )
				watchSelection( mi);
		}			
		return true;	    	
	case Event.MOUSE_ENTER:
		//    ((Frame)getParent()).setCursor( Frame.HAND_CURSOR);
		return true;
	case Event.MOUSE_EXIT:
		Selection = null;
		if ( isShowing() )
			redraw();
		return true;
	case Event.MOUSE_DOWN:
		requestFocus();
		if ( evt.modifiers == 0)
			watchSelection( mi);
		return true;
	case Event.MOUSE_UP:
		// open submenu on demand (mouse click, not move) to avoid
		// event confusion when moving the pointer very fast over the popup
		if ( Selection != null && Selection.SubItems != null) {
			redrawItem( Selection, true);
			openSubMenu( Selection);
		}
		else {	
			if (SubPane == null) {
				if( (evt.x != -1) || (evt.y != -1))
					cancel();
			}
		}
		return true;
	case Event.KEY_ACTION:
	case Event.KEY_PRESS:
		if ( evt.key == 27) {	//ESC
			Selection = null;
			cancel();
			return true;
		}
		if ( (evt.key == 10) || evt.key == 1007 ) {	//ENTER or RIGHT
			if ( !openSubMenu( Selection) )
				cancel();
			return true;
		}
		if ( evt.key == 1004) {	//UP
			selectPrevItem();
			return true;
		}
		if ( evt.key == 1005) {	//DOWN
			selectNextItem();
			return true;
		}
		if ( evt.key == 1006) { //LEFT
			if ( (mi != null) && Choices.indexOf( mi) == 0){
				if( Parent != null) {
					disposeSubMenus();
					dispose();
					Parent.SubPane = null;
					Parent.requestFocus();
				}
			}	
			return true;
		}
		break;

	}	    
	return false;
}

public MenuItem itemAt ( String txt) {
	MenuItem mi;

	for (Enumeration e = Choices.elements() ; e.hasMoreElements();) {
		mi = (MenuItem)e.nextElement();
		if ( txt.equals( mi.Text))
			return mi;
	}

	return null;
}

public MenuItem itemAt ( int y ) {
	int       offs= ItemHeight;
	MenuItem  mi;

	for (Enumeration e = Choices.elements() ; e.hasMoreElements();) {
		mi = (MenuItem)e.nextElement();
		if ( mi.isSeparator() )
			offs += SepHeight;
		else{
			if ( y <= offs)
				return mi;
			offs += ItemHeight;
		}	
	}

	return null;
}

int maxHeight(){
	int maxH = 0;
	for ( Enumeration e = Choices.elements(); e.hasMoreElements();){
		if ( ((MenuItem)e.nextElement()).isSeparator() )
			maxH += SepHeight;
		else
			maxH += ItemHeight;
	}

	return maxH + 2*BorderWidth + 1;  // add extra deco contour space
}

protected int maxWidth() {
	int cx, max=0;

	for (Enumeration e = Choices.elements() ; e.hasMoreElements();) {
		cx = Fm.stringWidth (((MenuItem)e.nextElement()).Text);
		if ( cx > max)
			max = cx;
	}

	return (max + 2 * BorderWidth + 25) + 1;  // add extra deco contour space
}

public boolean openSubMenu( MenuItem mi) {
	Rectangle rect = bounds();

	if( (mi == null) || (mi.SubItems == null) || (mi.isDisabled()) )
		return false;

	if( SubPane != null ) {
		if ( SubPane.Choices.equals( mi.SubItems)){
			SubPane.requestFocus();
			return true;
		}
		disposeSubMenus();
	}

	SubPane = new MenuWindow( this );

	if ( Awt.AwtToolkit == Awt.TK_WIN) {
		SubPane.reshape( 0, 0, 0, 0);
		SubPane.show();
		SubPane.move( rect.x + rect.width - 2 * BorderWidth,
		              rect.y + yPosOf( mi));
		SubPane.setContents( mi.SubItems);
	}
	else {
		SubPane.move( rect.x + rect.width - 2 * BorderWidth,
		              rect.y + yPosOf( mi));
		SubPane.setContents( mi.SubItems);
		SubPane.show();
	}

	SubPane.requestFocus();

	return true;	
}

public void paint( Graphics g) {
	redraw( g);
}

public void popUpAt( int x, int y) {
	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	int w = maxWidth();
	int h = maxHeight();

	if ( x + w > d.width)
		x = d.width - w;
	if ( y + h > d.height)
		y = d.height - h;

	Selection = itemAt( 0);

	if ( Awt.AwtToolkit == Awt.TK_WIN ) {
		// WIN workaround: Window instances can only be reshaped if already visible
		reshape( 0,0,0,0); show(); reshape( x, y, w, h);
	}
	else {
		reshape( x, y, w, h);
		show();
	}

	requestFocus();
}

void redraw () {
	Graphics g = getGraphics();
	if ( g != null )
		redraw( g);
	g.dispose();
}

void redraw ( Graphics g) {

	boolean     sel;
	MenuItem    mi;
	Dimension   s = size();
	int         yOffs = 1;
	int         cs = Choices.size();

	int         x0 = BorderWidth + 1;
	int         w  = s.width - 2*BorderWidth - 1;
	int         yo;

	GraphicsLib.paintButton( g, 0, 0, s.width, s.height, false, Awt.MenuBackClr);

	for ( int i=0; i<cs; i++) {
		mi = (MenuItem)Choices.elementAt( i);;
		sel = mi.equals( Selection);

		if ( sel){
			GraphicsLib.paint3dBox( g, x0, yOffs + BorderWidth, w, ItemHeight, false, null);
		}

		if ( mi.isSeparator() ){
			yo = yOffs + SepHeight / 2;
			g.setColor( Awt.ShadowDarkClr);
			g.drawLine( 4, yo+1, s.width - 4, yo+1);
			g.setColor( Awt.ShadowBrightClr);
			g.drawLine( 4, yo+2, s.width - 4, yo+2);
			yOffs += SepHeight;
		}	
		else {
			mi.drawAt( g, 8, yOffs+ItemHeight-TYOffs);
			if ( mi.SubItems != null){
				GraphicsLib.drawRightTri( g, s.width-15, yOffs+ItemHeight/3,
				                          ItemHeight/2, ItemHeight/2, sel);
			}
			yOffs += ItemHeight;
		}	
	}
}

void redrawItem ( MenuItem mi, boolean highLight ) {
	Graphics    g = getGraphics();
	boolean     sel = mi.equals( Selection);
	Dimension   s = size();
	int         yOffs = yPosOf( mi) + 1;

	int         x0 = BorderWidth + 1;
	int         y0;
	int         w  = s.width - 2*BorderWidth - 1;

	if ( g == null )
		return;

	g.setColor( Awt.MenuBackClr);
	g.fillRect( BorderWidth, yOffs + BorderWidth,
	            s.width-2*BorderWidth, ItemHeight);

	if ( sel) {
		GraphicsLib.paint3dBox( g, x0, yOffs + BorderWidth, w, ItemHeight, false, null);
	}

	mi.drawAt( g, 8, yOffs+ItemHeight-TYOffs, highLight);

	if ( mi.SubItems != null){
		w = ItemHeight>>1;
		GraphicsLib.drawRightTri( g, s.width-15, yOffs+ItemHeight/3, w, w, sel);
	}

	g.dispose();
}

public void requestFocus( Object obj){
	requestFocus();
}

public boolean selectItem( MenuItem mi) {
	MenuItem mit;

	if ( mi == null || mi.equals( Selection) || mi.isSeparator() )
		return false;

	if ( Selection != null) {
		mit = Selection;
		Selection = null;
		redrawItem( mit, false);
	}

	Selection = mi;
	redrawItem( Selection, false);

	return true;
}

public boolean selectNextItem() {
	MenuItem mi;
	int cs = (Selection != null) ? Choices.indexOf( Selection) : -1;

	if ( cs > Choices.size() - 2)
		return false;

	for ( int idx = cs + 1; idx < Choices.size(); idx++){
		mi = (MenuItem)Choices.elementAt( idx);
		if ( ! mi.isSeparator() ){
			selectItem( mi);    
			return true;
		}
	}

	return false;
}

public boolean selectPrevItem() {
	MenuItem mi;
	int cs = (Selection != null) ? Choices.indexOf( Selection) : Choices.size();

	if ( cs > 0) {
		for ( int idx = cs - 1; idx > -1; idx--){
			mi = (MenuItem)Choices.elementAt( idx);
			if ( ! mi.isSeparator()){
				selectItem( mi);
				return true;
			}    
		}
	}
	return false;
}

public void setContents( Vector vec){
	Choices   = vec;
	Selection = null;
	resize( maxWidth(), maxHeight());
}

public void setFont( Font fnt) {
	Font uf = ( fnt != null) ? fnt : Awt.MenuFont;

	super.setFont( uf);

	if ( uf.equals( Awt.MenuFont))
		Fm = DefFm;
	else
		Fm = Awt.getFontMetrics( uf);

	ItemHeight = Fm.getHeight()*3/2;
	TYOffs = ((ItemHeight - Fm.getHeight()) / 2) +  Fm.getDescent() - 1;
}

protected MenuWindow topPane(){
	MenuWindow w;
	for ( w = this; w.Parent != null; w = w.Parent);
	return w;
}

boolean watchSelection( MenuItem mi) {	
	if ( (mi == null) || (mi.equals( Selection)) )
		return false;

	selectItem( mi);
	if ( SubPane != null){
		if ( ! (SubPane.Choices.equals( mi.SubItems)))
			disposeSubMenus();
	}

	// Open submenu by moving over the submenu item. This may cause flicker
	// and/or event confusion (when moving the pointer very fast over the menu)
	//	if ( mi.SubItems != null)
	//		openSubMenu( mi);

	return true;	
}

public int yPosOf ( MenuItem mi) {
	int       offs = 0;
	int       s = Choices.size();
	MenuItem  mii;

	for ( int i=0; i<s; i++) {
		mii = (MenuItem)Choices.elementAt( i);
		if ( mii.equals( mi) )
			return offs;
		if ( mii.isSeparator())
			offs += SepHeight;
		else
			offs += ItemHeight;
	}

	return 0;
}
}
