package biss;

import java.awt.Point;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

/**
 * library class providing general static functions on Vectors
 *
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class VectorLib
{

public static int addAllElements ( Vector a, Vector b ) {
	int n = a.size();
	int m = b.size();
	int k = n+m;

	a.ensureCapacity( k);
	for ( int i=0; i<m; i++)
		a.addElement( b.elementAt(i));

	return k;
}

public static Vector elementsFromTo ( Vector list, int start, int end ) {
	int s = list.size();
	Vector v = new Vector( list.size() );
	for ( int i=0; i<s; i++){
		if ( (i >= start) && (i <= end))
			v.addElement( list.elementAt( i));
	}
	return v;
}

public static Object firstEqualElement ( Vector a, Object o ) {
	int i = a.indexOf( o);
	if ( i >= 0 )
		return a.elementAt( i);
	else
		return null;
}

public static int insertAllElementsBefore ( Vector a, Vector b, Object insObj ) {
	int n = a.size();
	int m = b.size();
	int k = n+m;
	int iPos = a.indexOf( insObj);

	a.ensureCapacity( k);
	for ( int i=m-1; i>=0; i--)
		a.insertElementAt( b.elementAt(i), iPos);

	return k;
}

public static int insertAllElementsBehind ( Vector a, Vector b, Object insObj ) {
	int n = a.size();
	int m = b.size();
	int k = n+m;
	int iPos = a.indexOf( insObj);

	a.ensureCapacity( k);
	for ( int i=m-1; i>=0; i--)
		a.insertElementAt( b.elementAt(i), iPos+1);

	return k;
}

public static void quickSort ( Vector a, VectorSorter s ) {
	int i, j, sl, sr;
	Stack sf = new Stack();
	Object v, e;
	Point  p = new Point( 0, a.size()-1);
	int    m = a.size();

	while ( true ){
		while ( p.y > p.x ) {
			v = a.elementAt( p.y);

			for ( i= p.x -1, j= p.y;; ) {
				if ( s != null ) {
					while ( ++i < m  && s.compare( a.elementAt( i), v) < 0 );
					while ( --j >= 0 && s.compare( a.elementAt( j), v) > 0 );
				}
				else {
					String vs = v.toString();
					while ( ++i < m  && a.elementAt(i).toString().compareTo( vs) < 0 );
					while ( --j >= 0 && a.elementAt(j).toString().compareTo( vs) > 0 );
				}
				if ( i >= j ) break;
				swap( a, i, j);
			}
			swap( a, i, p.y);

			if ( (sl = i-p.x) > (sr = p.y-i) ) {
				if ( sl > 1 )  sf.push( new Point( p.x, (i-1)));
				p.x = i+1;
			}
			else {
				if ( sr > 1 )  sf.push( new Point( (i+1), p.y));
				p.y = i-1;
			}
		}
		if ( sf.empty() ) break;
		p = (Point)sf.pop();
	}
}

public static int removeAllElements ( Vector list, Vector removeList ) {
	int i=0;

	if ( list == null || removeList == null || removeList.size() == 0 )
		return 0;

	for ( Enumeration e = removeList.elements(); e.hasMoreElements(); ) {
		Object obj = e.nextElement();
		if ( list.removeElement( obj) ) i++;
	}
	return i;
}

public static boolean replaceFirstEqualElement ( Vector a, Object o ) {
	int i = a.indexOf( o);
	if ( i >= 0 ){
		a.setElementAt( o, i);
		return true;
	}
	else
		return false;
}

public static void sortIn ( Vector vec, Object obj ) {
	sortIn( vec, obj, true, null);
}

public static void sortIn ( Vector vec, Object obj, VectorSorter sorter ) {
	sortIn( vec, obj, true, sorter);
}

public static void sortIn ( Vector vec, Object obj,
              boolean ignoreIdent, VectorSorter sorter ) {
	if ( vec == null || obj == null ) return;

	int n = vec.size();
	if ( n == 0 ){
		vec.addElement( obj);
	}
	else {
		for ( int i=n-1; i>= 0; i-- ) {
			Object o = vec.elementAt( i);
			if ( ignoreIdent || o != obj ) {
				int cmp = (sorter == null) ? 
				obj.toString().compareTo( o.toString()) : sorter.compare( obj, o);
				if ( cmp >= 0 ) {
					vec.insertElementAt( obj, i+1); return;
				}
			}
		}
		vec.insertElementAt( obj, 0);
	} 
}

public static void sortInAll (Vector vec, Enumeration add, VectorSorter sorter ) {
	if ( vec == null || add == null ) return;
	for (; add.hasMoreElements();)
		sortIn( vec, add.nextElement(), sorter);
}

public static void sortInAll (Vector vec, Vector add, VectorSorter sorter ) {
	if ( vec == null || add == null ) return;

	int i, m=add.size();
	for ( i=0; i<m; i++ )
		sortIn( vec, add.elementAt(i), sorter);
}

public static void swap ( Vector a, int i, int j ) {
	Object e = a.elementAt( i);
	a.setElementAt( a.elementAt( j), i);
	a.setElementAt( e, j);
}

public static Vector vectorFromArray ( Object[] oa ) {
	Vector v = new Vector( oa.length);
	for ( int i=0; i<oa.length; i++)
		v.addElement( oa[i]);
	return v;
}
}
