package biss;

import java.io.ByteArrayOutputStream;

/**
 * PrintStream which does not write any output but just counts
 * newlines (usable to quickly determine line numbers)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class DummyCLPrintStream
  extends CLPrintStream
{

public DummyCLPrintStream () {
	super( new ByteArrayOutputStream(0));
}

public synchronized void write ( byte b[], int off, int len ) {
	int max = off+len;
	for ( int i=off; i<max; i++ )
		if ( b[i] == (byte)'\n' ) Line++;
}

public synchronized void write ( int b ) {
	if ( b == '\n' ) Line++;
}
}
