package biss.jde;

import biss.PackageProperties;
import biss.awt.Awt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.util.Vector;

/**
 * package class of package biss.jde (initialized from the package
 * property file "biss.jde")
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class Jde
{
	public static PackageProperties Values = new PackageProperties( "biss.jde");
	public static String[] SrcRoots;
	public static String[] Excludes;
	public static String ClassRoot;
	public static String[] Docs;
	public static boolean AutoLoadCls;
	public static int NDirs;
	public static int NPackages;
	public static int NCUs;
	public static int NTypes;
	public static int CacheCheck;
	public static int CacheKeep;
	public static Font TextFont;
	public static Font SmallFont;
	public static FontMetrics SmallFontMetrics;
	public static Font SmallFixFont;
	public static FontMetrics SmallFixFontMetrics;
	public static Color KeywordClr;
	public static Color LiteralClr;
	public static Color CommentClr;
	public static Color AccessClr;
	public static Color AbstractClr;
	public static Color ActiveCUClr;
	public static Color CacheCUClr;
	public static String HomeDir;
	public static Rectangle LibBrowserRect;
	public static Rectangle CUBrowserRect;
	public static Rectangle CompOutRect;
	public static String DesignDrawCls;
	public static boolean ColorizeSyntax;

static {
	Toolkit tk = Toolkit.getDefaultToolkit();

	initFonts();

	SmallFontMetrics = tk.getFontMetrics( SmallFont);
	SmallFixFontMetrics = tk.getFontMetrics( SmallFixFont);

	KeywordClr = Values.getColor( "KeywordClr", Color.red);
	LiteralClr = Values.getColor( "LiteralClr", Color.magenta);
	CommentClr = Values.getColor( "CommentClr", new Color(160, 160, 160));

	AccessClr = Values.getColor( "AccessClr", Color.green);
	AbstractClr = Values.getColor( "AbstractClr", Color.gray);
	ActiveCUClr = Values.getColor( "ActiveCUClr", Color.red);
	CacheCUClr = Values.getColor( "CacheCUClr", Color.blue);

	HomeDir = System.getProperty( "user.home");

	String defCR = HomeDir + File.separator + "java" 
	+ File.separator + "classes";
	ClassRoot = Values.getString( "ClassRoot", defCR);
	if ( ClassRoot.charAt(0) == '~' )
		ClassRoot = PackageProperties.expandHome( ClassRoot);

	AutoLoadCls = Values.getBoolean ( "AutoLoadCls", true);
	SrcRoots = Values.getPaths( "SrcRoots", System.getProperty( "user.dir"));
	Excludes = Values.getPaths( "Excludes", null);
	Docs = Values.getPaths( "Docs", null);

	DesignDrawCls = Values.getString( "DesignDrawCls", null);

	NDirs     = Values.getInt( "NDirs", 20);
	NPackages = Values.getInt( "NPackages", 20);
	NCUs      = Values.getInt( "NCUs", 200);
	NTypes    = Values.getInt( "NTypes", 300);

	CacheCheck = Values.getInt( "CacheCheck", 180);
	CacheKeep  = Values.getInt( "CacheKeep", 360);

	ColorizeSyntax = Values.getBoolean( "ColorizeSyntax", true);

	// screen positions and sizes of JDE views
	// (can't be based on biss.awt.Awt because of a compiler problem)
	Dimension scr = tk.getScreenSize();
	Rectangle r = new Rectangle();

	r.width = Awt.DlgXUnit * 22;
	r.height = scr.height / 2;
	r.x = scr.width - r.width;
	r.y = scr.height / 10;
	LibBrowserRect = Values.getRectangle( "LibBrowserRect", r);

	r.width = Awt.DlgXUnit * 45;
	r.height = Awt.DlgYUnit * 30;
	r.x = scr.width / 10;
	r.y = scr.height / 10;
	CUBrowserRect = Values.getRectangle( "CUBrowserRect", r);

	r.width = scr.width *2 / 3;
	r.height = scr.height / 4;
	r.x = scr.width - r.width;
	r.y = scr.height - r.height;
	CompOutRect = Values.getRectangle( "CompOutRect", r);
}

static void initFonts () {

	String small = null, smallFix = null;

	switch ( Awt.AwtToolkit ) {
	case Awt.TK_OS2:
		if ( Awt.ScreenWidth < 1024 ) {
			small    = "Dialog"  + ' ' + "PLAIN" + ' ' + 17;
			smallFix = "Courier" + ' ' + "PLAIN" + ' ' + 14;
		}
		else {
			small    = "Dialog"  + ' ' + "PLAIN" + ' ' + 17;
			smallFix = "Courier" + ' ' + "PLAIN" + ' ' + 14;		
		}
		break;
		
	default:
		if ( Awt.ScreenWidth < 1024 ) {
			small    = "Helvetica" + ' ' + "PLAIN" + ' ' + 11;
			smallFix = "Courier"   + ' ' + "PLAIN" + ' ' + 12;
		}
		else {
			small    = "Helvetica" + ' ' + "PLAIN" + ' ' + 12;
			smallFix = "Courier"   + ' ' + "PLAIN" + ' ' + 12;
		}
	}

	SmallFont = Values.getFont( "SmallFont", small);    
	SmallFixFont = Values.getFont( "SmallFixFont", smallFix);
}
}
