package biss.jde;

import java.io.File;
import java.io.FileInputStream;
import java.util.BitSet;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

/**
 * Parser used to analyze CUBrowser TextArea input
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class AcceptParser
  extends Parser
{
	Vector Items;

AcceptParser ( String src ) {
	super( src);
}

void checkParens () throws ParseException {
	CurNt = "lexical-structure";
	Stack p1 = new Stack();
	Stack p2 = new Stack();

	try {
		while ( Scan.nextToken() != 0 ){
			switch ( Scan.Tok ) {
			case '{':  p1.push( new Integer( Scan.Line)); break;
			case '}':  p1.pop(); break;
			case '(':  p2.push( new Integer( Scan.Line)); break;
			case ')':  p2.pop(); break;
			}
		}
	}
	catch ( EmptyStackException x ) {
		throw new ParseException( "unbound '" + (char)Scan.Tok
		                          + "' in line: " + Scan.Line);
	}

	if ( !p1.empty() )
		throw new ParseException( "missing '}' for line: " + p1.peek());

	if ( !p2.empty() )
		throw new ParseException( "missing ')' for line: " + p2.peek());
}

void class_decl ( BitSet mods ) throws ParseException {
	String id;
	String base;
	Vector interfaces;
	CurNt = "class"; CurLn = Scan.Line;

	id = matchString( "class name expected");
	ClassDecl cls = new ClassDecl( mods, id);
	cls.setComment( Scan.lastComment());
	Items.addElement( cls);

	if ( isMatch( JavaScanner.EXTENDS) && (Scan.Tok != JavaScanner.IMPLEMENTS) ) {
		base = matchString( "base class name expected");
		cls.setSuper( base);
	}

	if ( isMatch( JavaScanner.IMPLEMENTS) && Scan.Tok == JavaScanner.STRING ){
		interfaces = id_list();
		cls.setInterfaces( interfaces);
	}

	if ( isMatch( JavaScanner.EXTENDS ) ){
		base = matchString( "base class name expected");
		cls.setSuper( base);
	}

	if ( isMatchValChar( '{' ) ) {
		TDecl = cls;
		while ( !isMatchValChar( '}') )
			field_decl();
	}
}

void interface_decl ( BitSet mods ) throws ParseException {
	String id;
	Vector interfaces;
	CurNt = "interface"; CurLn = Scan.Line;
	id = matchString( "interface name expected");
	InterfaceDecl ifc =new InterfaceDecl( mods,
	                                      id);
	Items.addElement( ifc);
	if ( isMatch( JavaScanner.EXTENDS) || isMatch( JavaScanner.IMPLEMENTS) ) {
		interfaces = id_list();
		ifc.setInterfaces( interfaces);
	}
}

TypeDecl parseDataOrMethod () throws ParseException {
	TDecl = new ClassDecl();
	Scan.nextToken();
	while ( Scan.Tok != 0 ) {
		field_decl();
	}
	return TDecl;
}

Vector parseImports () throws ParseException {
	Items = new Vector( 10);
	Import imp;
	CurNt = "import";
	for ( Scan.nextToken(); Scan.Tok != 0; Scan.nextToken() ) {
		switch ( Scan.Tok ) {
		case JavaScanner.IMPORT:
		case ';': 
			continue;
		case JavaScanner.STRING:
			imp =new Import(Scan.string());
			Items.addElement( imp);
			break;
		default:
			throw new ParseException( "illegal in import spec", Scan);
		}
	}
	return Items;
}

String parsePackage () throws ParseException {
	String pckg;
	Scan.nextToken();

	isMatch( JavaScanner.PACKAGE);
	if ( Scan.Tok == JavaScanner.STRING )
		pckg = Scan.string();
	else if ( Scan.Tok == 0 )
		return null;
	else 
		throw new ParseException( "package name missing", Scan);

	return pckg;
}

Vector parseTypeDecls () throws ParseException {
	Items = new Vector(10);
	BitSet mods;
	CurNt = "type decl"; CurLn = Scan.Line;
	Scan.nextToken();

	while ( Scan.Tok != 0 ) {
		mods = new BitSet( Scan.NKeys);
		for ( int t = Scan.Tok; isMatchSet( CorI_Modifier); t = Scan.Tok )
			mods.set( -t);  // JavaScanner tokens are negative

		if ( Scan.Tok == JavaScanner.STRING || isMatch( JavaScanner.CLASS ) )
			class_decl ( mods);
		else if ( isMatch( JavaScanner.INTERFACE ) )
			interface_decl( mods);
		else {
			throw new ParseException( "'" + Scan.string() + 
			                          "' illegal in class or interface decl");
		}
		while ( isMatchValChar( ';'));
	}
	return Items;
}
}
