package biss.awt;

import java.util.Vector;

/**
 * wrapper object for hierarchically organized data (e.g. a single directory
 * object). Stores display state and Level information. LeveledObjects
 * are usually created by Levelers. Used by LeveledList
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class LeveledObject
{
	final public static int LO_EXPANDABLE = 1;
	final public static int LO_EXPANDED = 2;
	final public static int LO_VISIBLE = 4;
	int Level;
	Object Obj;
	int State;

LeveledObject ( Object obj, int lvl) {
	Obj   = obj;
	Level = lvl;
	State = 0;
}

public static void add (Vector v, Object obj, int lvl) {
	int iLvl = 0;

	try {
		LeveledObject llo = (LeveledObject)v.lastElement();
		iLvl = Math.min( llo.Level+1, lvl);
	}
	catch ( Throwable t) {}

	LeveledObject nlo = new LeveledObject( obj, iLvl);
	int s = v.size();
	int ll = iLvl;

	if ( iLvl == 0)
		nlo.setVisible( true);

	for ( int i=s-1; i>-1; i--){
		LeveledObject lo = (LeveledObject)v.elementAt( i);
		if ( lo.Level >= ll)
			break;
		lo.setExpandable( true);
		ll = lo.Level;
	}

	v.addElement( nlo);
}

public void addState (int flags) {
	State |= flags;
}

public static void expandToLevel (Vector v, int lvl) {
	int s = v.size();

	for ( int i=0; i<s; i++){
		LeveledObject lo = (LeveledObject)v.elementAt( i);
		if (lo.Level <= lvl)
			lo.setVisible( true);
		if ((lo.Level < lvl) && lo.isExpandable() )
			lo.setExpanded( true);
	}

}

public Object getObject () {
	return Obj;
}

public static void initialize (Vector v) {
	int s = v.size();

	for ( int i=0; i<s; i++){
		LeveledObject lo = (LeveledObject)v.elementAt( i);
		if ( lo.Level == 0)
			lo.setVisible( true);
		if ( i<s-1){
			LeveledObject lon = (LeveledObject)v.elementAt( i+1);
			if ( lon.Level > lo.Level){
				lon.Level = lo.Level + 1;
				lo.setExpandable( true);
			}
		}
	}  
}

public static void insert (Vector v, Object obj, int lvl, int idx) {
	LeveledObject ilo;
	int iLvl = 0;

	try {
		ilo = (LeveledObject)v.elementAt( idx-1);
		iLvl = Math.min( ilo.Level+1, lvl);
	}
	catch ( Throwable t) {}

	LeveledObject nlo = new LeveledObject( obj, iLvl);
	int ll = iLvl;

	if ( iLvl == 0)
		nlo.setVisible( true);

	for ( int i=idx-1; i>-1; i--){
		LeveledObject lo = (LeveledObject)v.elementAt( i);
		if ( lo.Level >= ll)
			break;
		lo.setExpandable( true);
		ll = lo.Level;
	}

	v.insertElementAt( nlo, idx);
}

public boolean isExpandable () {
	return ( State == (LO_VISIBLE | LO_EXPANDABLE));
}

public boolean isExpanded () {
	return ( (State & LO_EXPANDED) != 0);
}

public boolean isShrinkable () {
	return ( State == (LO_VISIBLE | LO_EXPANDABLE | LO_EXPANDED));
}

public boolean isVisible () {
	return ( (State & LO_VISIBLE) != 0);
}

public static boolean lastLevelIdx (Vector v, int idx, int lvl) {
	int s = v.size();

	for ( int i=idx+1; i<s; i++){
		LeveledObject lo = (LeveledObject)v.elementAt( i);
		if ( lo.Level < lvl)     return true;
		if ( lo.Level == lvl)    return false;
	}

	return true;
}

public int level () {
	return Level;
}

public void setExpandable () {
	State |= LO_EXPANDABLE;
}

public void setExpandable ( boolean state) {
	if ( state)  State |= LO_EXPANDABLE;
	else         State &= ~LO_EXPANDABLE;
}

public void setExpanded ( boolean state) {
	if ( state)  State |= LO_EXPANDED;
	else         State &= ~LO_EXPANDED;
}

public void setVisible ( boolean state) {
	if ( state)  State |= LO_VISIBLE;
	else         State &= ~LO_VISIBLE;
}

public void subState (int flags) {
	State &= ~flags;
}
}
