package biss.awt;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * abstract base used by ImageProducers like the GIFProducer. Does all the
 * consumer handling and enable its descendants to focus on data formats
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
abstract public class ImageBuilder
  implements java.awt.image.ImageProducer
{
	Vector Consumers = new Vector(2);
	String Error;
	int Width;
	int Height;
	ColorModel CM;
	int ScanLine;
	int Hints;
	Object Source;
	Hashtable Properties;
	int Offset;
	boolean IsProducing = false;

public void addConsumer ( ImageConsumer ic ) {
	if ( ic != null && !Consumers.contains( ic) )
		Consumers.addElement( ic);

	if ( !IsProducing )
		startProduction();	
}

void errorNotify () {
	Enumeration e;
	ImageConsumer ic;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.imageComplete( ImageConsumer.IMAGEERROR);
	}

	IsProducing = false;
}

void imageComplete ( int status ) {
	Enumeration e;
	ImageConsumer ic;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.imageComplete( status);
	}

	if ( status == ImageConsumer.STATICIMAGEDONE )
		IsProducing = false;
}

public boolean isConsumer(ImageConsumer ic) {
	return Consumers.contains( ic);
}

public void removeConsumer(ImageConsumer ic) {
	Consumers.removeElement( ic);
}

public void requestTopDownLeftRightResend(ImageConsumer ic) {

}

void setColorModel ( ColorModel cm ) {
	Enumeration e;
	ImageConsumer ic;

	CM = cm;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.setColorModel( cm );
	}
}

void setDimensions ( int width, int height, int scanLine, int offset ) {
	Enumeration e;
	ImageConsumer ic;

	Width = width;
	Height = height;
	ScanLine = scanLine;
	Offset = offset;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.setDimensions( Width, Height);
	}
}

void setHints ( int hintFlags ) {
	Enumeration e;
	ImageConsumer ic;

	Hints = hintFlags;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.setHints( hintFlags);
	}
}

void setPixels ( byte[] pixels, int start, int end ) {
	Enumeration e;
	ImageConsumer ic;
	int x, y, w, h;

	x = 0;
	y = 0;
	w = Width;
	h = Height;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.setPixels( x, y, w, h, CM, pixels, Offset, ScanLine);
	}
}

void setProperties ( Hashtable props ) {
	Enumeration e;
	ImageConsumer ic;

	Properties = props;

	for ( e = Consumers.elements(); e.hasMoreElements(); ){
		ic = (ImageConsumer) e.nextElement();
		ic.setProperties( Properties);
	}
}

abstract void startProduction();

public synchronized void startProduction ( ImageConsumer ic ) {
	addConsumer( ic);
}
}
