package biss.awt;

import biss.ObserverSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Decoration;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;

/**
 * java.awt.Panel replacement used as base for various biss.awt
 * container widgets
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Compound
  extends Panel
  implements FocusSetInterface
{
	Border FBorder = new Border();
	Layouter Lo = new Layouter( this);
	int Width = 0;
	int Height = 0;
	public ObserverSocket OsFocusGot = new ObserverSocket( this);
	public ObserverSocket OsFocusLost = new ObserverSocket( this);
	public boolean Enabled = true;
	Component PeerTarget;
	PaintCmd RetainPainter = (Awt.FilterPaints > 0) ? new PaintCmd( this) : null;

public boolean canGetFocus () {
	return isEnabled() && isShowing();
}

public synchronized void disable () {
	Component[] ca = getComponents();
	for ( int i=0; i<ca.length; i++ )
		ca[i].disable();
	Enabled = false;
}

public void dispose () {
	//java.awt.peer.ComponentPeer interface
	getPeer().dispose();
}

public synchronized void enable () {
	Component[] ca = getComponents();
	for ( int i=0; i<ca.length; i++ )
		ca[i].enable();
	Enabled = true;
}

public boolean focusNext () {
	return false;
}

public boolean focusPrev () {
	return false;
}

public Frame getFrame() {
	Container so = (PeerTarget != null) ? PeerTarget.getParent() : getParent();
	for ( ; so != null; so =so.getParent() ) {
		if ( so instanceof Frame)
			return (Frame)so;
	}
	return null;
}

public Container getParent(){
	if ( PeerTarget != null)
		return PeerTarget.getParent();
	return super.getParent();
}

public boolean handleEvent( Event evt) {
	if ( PeerTarget != null ){
		boolean ret = PeerTarget.handleEvent( evt);
		if ( ret) return ret;
	}
	return super.handleEvent( evt);
}

public boolean hasFocus () {
	return false;
}

public boolean isEnabled () {
	return Enabled;
}

public void paint() {
	if ( isShowing() ) {
		Graphics g = getGraphics();
		if ( g != null){
			paint( g);
			g.dispose();
		}
	}
}

public void paint( Graphics g) {

	// infamous ScreenUpdater neutralizer
	if ( RetainPainter != null && RetainPainter.checkPaintSeries() )
		return;

	FBorder.drawBorder( g, Width, Height);
	redraw( g);

	Decoration.paint( g, this);
}

void peerEvent ( int id, Object arg) {
	if ( PeerTarget != null)
		PeerTarget.deliverEvent( new Event( PeerTarget, id, arg));
}

public void redraw () {
	Graphics g = getGraphics();
	if ( g != null ) {
		redraw( g);
		g.dispose();
	}
}

public void redraw( Graphics g) {
}

public synchronized void reshape( int x, int y, int width, int height) {

	Width = width;
	Height = height;

	super.reshape( x, y, width, height);
	layout();
}

public void setBackground ( Color clr ) {
}

public void setBorder( int bs){
	FBorder.setBorder( bs);
}

public void setCursor( int type){
	Frame fr = getFrame();
	if ( fr.getCursorType() != type)
		fr.setCursor( type);
}

public boolean setFocus () {
	return false;
}

public void setFont ( Font fnt ) {
}

public void setForeground ( Color clr ) {
}

void setPeerTarget ( Component peerTarget ) {
	Color fg, bg;
	Font  fnt;

	PeerTarget = peerTarget;

	if ( (fg = peerTarget.getForeground()) != null )
		setForeground( fg);

	if ( (bg = peerTarget.getBackground()) != null )
		setBackground( bg);

	if ( (fnt = peerTarget.getFont()) != null )
		setFont( fnt);
}
}
