package biss;


/**
 * lib class providing general static functions on Strings 
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class StringLib
  implements CharTypes
{

public static int indexOfId ( String source, String pattern ) {
	return indexOfId( source, pattern, 0);
}

public static int indexOfId ( String source, String pattern, int iStart ) {
	int i = iStart, j;
	int n = pattern.length();
	int m = source.length();

	while ( (i=source.indexOf( pattern, i)) >= 0 ) {
		if ( i == 0 || !IsAN[ source.charAt(i-1)] ) {
			j = i+n;
			if ( j == m || !IsAN[ source.charAt(j)] )
				return i;
		}
		i += n;
	}

	return -1;
}

public static void main ( String[] args ) {
	//System.out.println( StringLib.indexOfId( args[0], args[1]));
	// System.out.println( StringLib.replaceAll( args[0], args[1], args[2]));
	System.out.println( StringLib.valueOf( -10, 8));
}

public static int occurencesOf ( String source, char c ) {
	int ocr = 0;
	for ( int i=0; i<source.length(); i++){
		if ( source.charAt( i) == c)
			ocr++;
	}
	return ocr;
}

public static String replaceAll ( String source, String pattern, String replace ) {
	int m = source.length();
	int n = pattern.length();
	int o = (replace != null) ? replace.length() : 0;
	StringBuffer s = new StringBuffer( m);
	int i, l;
	for ( l=0; (i = source.indexOf( pattern, l)) >= 0; l=i+n ){
		if ( i > l )
			s.append( source.substring( l, i));
		if ( o > 0 )
			s.append( replace);
	}
	if ( l < m )
		s.append( source.substring( l, m) );

	return s.toString();
}

public static String valueOf ( int n, int len ) {
	char[] a = new char[len];
	int x = (n > 0) ? n : -n;
	int r;
	int i, j;
	for (i=len-1, r= x/10; i >= 0; i-- ) {
		if ( x > 0 ) {
			a[i] = (char) ((x - (r*10)) + '0');
			x = r;
			r = x / 10;
		}
		else {
			if ( n < 0 ) {
				a[i] = '-';
				n = -n;
			}
			else
				a[i] = ' ';
		}
	}
	return String.valueOf( a);
}
}
