/*  VER 201   TAB P   $Id: doit.c,v 1.12 1998/09/11 16:37:43 src Exp $
 *
 *  an NNTP news exchange client
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: doit.c,v $
 *  Revision 1.12  1998/09/11 16:37:43  src
 *  Lockfile for logfile of posted articles and for posted article folder.
 *
 *  Revision 1.11  1998/09/09 07:32:11  src
 *  Version 1.1
 *
 *  Revision 1.10  1998/09/03 03:51:35  src
 *  Fixed bad syntax messages
 *
 *  Revision 1.9  1998/09/02 06:50:30  src
 *  newsx version 1.0
 *
 *  Revision 1.8  1998/09/02 06:34:41  src
 *  Support @-syntax in newsfeeds, and support AUTHINFO GENERIC
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "nntp.h" 
#include "news.h"

#include <string.h>
#include <signal.h>

/*
 *  locals
 */
static void 
set_signals(void);
static RETSIGTYPE 
sig_ignore(int signo);

static int did_interrupt = 0;

/*
 *  do it
 *  return exit status
 */
int 
doit(void)
{
    int ret;
    time_t starttime,endtime;
    char *article_name = 0;

    progtitle("begin");
    set_signals();

    if (enquire_opt) {
	if (!history_lookup(enquire_opt)) {
	    printf("no\n");
	    return 12;
	}
	printf("yes\n");
	return 0;
    }

    if (!no_host_lock) {
	/* 
	 *  lock other newsxes accessing same host out first
	 */
	char lockname[PATH_MAX];

	progtitle("locking host access");
	build_filename(lockname,LOCK_PREFIX,hostname,NULL,NULL);
	lock(NULL,lockname);
    }

    log_open();

    time(&starttime);
    log_msg(L_DEBUG,"newsx %s %s", VERSION, text_time(starttime));
    log_msg(L_DEBUG,"server: %s, spool: %s", hostname, spoolname);

    /* load the active file before we connect to the server */
    if (!nopull_opt || group_newlist || group_desc) {
	load_sys();
	load_active();
    }

    /* see if there are any articles batched up */
    if (!nopost_opt && !(article_name = despool_line())) {
	log_msg(L_DEBUG,"outgoing spool is empty");
	if (nopull_opt) {
	    /* don't bother */
	    return 0;
	}
    }

    /* set up the connection to the server */
    if (!noaction_opt) switch (ret = open_server(hostname,hostport)) {
    case -1 :
	return 3;
    case OK_CANPOST:
	++post_allowed;
	log_msg(L_DEBUG,"OK, can post");
	break;
    case OK_NOPOST:
	log_msg(L_DEBUG,"OK, but can't post");
	break;
    default:
	log_msg(L_ERR,"can't talk to \"%s\": got response code %d", hostname, ret);
	return 4;
    }

    /* start the timer now */
    time(&starttime);

    /* We might need to do MODE READER before AUTHINFO or afterwards.
     * readbeforeauth_opt switches which way round we do things. -- PMM
     */

    /* if authinfo details supplied, then use 'em */
    if (!readbeforeauth_opt && ai_username)
       do_authinfo(ai_username,ai_password);
	
    /* switch INN to nnrpd instead of innd if needed */
    if (!ihave_opt && mode_reader_opt > 0)
       do_mode_reader();

    if (readbeforeauth_opt && ai_username)
	do_authinfo(ai_username,ai_password);

    /* get the active newgroup list from the server */
    if (group_list || group_newlist) {
	get_list();
	if (!nopull_opt || group_desc) {
	    /* the active list may have been updated by now... */
	    clear_active();
	    load_active();
	}
    }

    /* get the newgroup descriptions from the server */
    if (group_desc || group_alldesc) {
	get_desc(); 
    }

    /* now put the actual articles */
    if (article_name && !zap_opt)
	despool(article_name);

    /* might need to do the switch here */
    if (ihave_opt && mode_reader_opt >= 0)
	do_mode_reader();

    /* and pull any new articles */
    if (!nopull_opt) {
	log_msg(L_DEBUG,"fetching news");
	if (!pull(spoolname)) {
	    /*
	     *  socket timed out, or we were interrupted.
	     *  since this may have been caused by an impatient user
	     *  interrupting, we try to clean up after us by closing
	     *  the server connection as good as we can.
	     */
	    if (!noaction_opt)
		close_server(1);
	    return 9;
	}
    }

    /* time for goodbye */
    if (!noaction_opt)
	if (!close_server(0)) return 9;

    time(&endtime); 

    statistics(starttime,endtime);

    /* lock will be removed in main() */

    /* reached so far: everything is all right */
    return 0;
}

/*
 *  some don't have this, so give them a surrogate
 */
#ifndef HAVE_STRSIGNAL
char *
strsignal(int sig)
{
    static char buf[10];
    sprintf(buf,"%d",sig);
    return buf;
}
#endif

/*
 *  common for the next two functions...
 */
void
do_cleanup(char *title, int exitcode)
{
    static int again = 0;

    if (++again >= 10) {
	/* this definitely should not happen... */
	_exit(exitcode);
    }

    progtitle(title);

    /* clean up fetching and spooling */
    pull_cleanup(1);

    /* remove any locks */
    unlock_exit(exitcode);
}

/*
 *  exit program 
 *  save as much as we can, then clean up locks etc
 */
void
exit_cleanup(int exitcode)
{
    do_cleanup(did_interrupt ? "exit via interrupt" : "exit",exitcode);
}

/*
 *  signal handler to report signal in log and possibly
 *  submit remaining batch to news and dump uncollected message ids.
 */
static RETSIGTYPE 
sig_interrupt(int signo)
{
    /* pretty primitive, but it works of sort */
    extern int alarm_active;

    ++did_interrupt;
    if (alarm_active) {
	signal(signo, sig_interrupt); /* allow more interrupts */
	progtitle("interrupt -> alarm");
	log_msg(L_ERR,"received signal while alarm active: %s",
						strsignal(signo));
	/* alarm enabled, so treat it as such */
	sig_alrm(signo);
	return;
    }
    signal(signo, sig_ignore); /* ignore further interrupts of the same kind */
    log_msg(L_ERR,"received signal: %s", strsignal(signo));

    do_cleanup("interrupt",1);
}

/*
 *  signal handler to ignore signal
 */
static RETSIGTYPE 
sig_ignore(int signo)
{
    signal(SIGUSR1, sig_ignore);
    log_msg(L_DEBUGMORE,"received signal: %s", strsignal(signo));
}

/*
 *  set up signal handler to catch appropriate signals.
 */
static void 
set_signals(void)
{
    /* these signals all causes us to terminate gracefully: */
    signal(SIGHUP,  sig_interrupt);
    signal(SIGINT,  sig_interrupt);
    signal(SIGQUIT, sig_interrupt);
    signal(SIGTERM, sig_interrupt);

    /* this signal is just to check that we are alive: */
    signal(SIGUSR1, sig_ignore);
}

