/*								-*- C++ -*-
 * $Id: WIN_radiobox.h,v 1.2 1997-01-15 14:58:06+01 mho Exp $
 *
 * Purpose: radio box panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef RadioBox_h
#define RadioBox_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;
class wxPanel;

class wxRadioBox : public wxItem {
DECLARE_DYNAMIC_CLASS(wxRadioBox)
public:
    wxRadioBox(void);
    wxRadioBox(wxPanel *panel, wxFunction func, Const char *label,
	       int x = -1, int y = -1, int width = -1, int height = -1,
	       int n = 0, char **choices = NULL,
	       int dim = 0, long style = wxHORIZONTAL,
	       Constdata char *name = wxRadioBoxNameStr);
    wxRadioBox(wxPanel *panel, wxFunction func, Const char *label,
	       int x = -1, int y = -1, int width = -1, int height = -1,
	       int n = 0, wxBitmap **choices = NULL,
	       int dim = 0, long style = wxHORIZONTAL,
	       Constdata char *name = wxRadioBoxNameStr);
    ~wxRadioBox(void);

    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		int x = -1, int y = -1, int width = -1, int height = -1,
		int n = 0, char **choices = NULL,
		int dim = 0, long style = wxHORIZONTAL,
		Constdata char *name = wxRadioBoxNameStr);
    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		int x = -1, int y = -1, int width = -1, int height = -1,
		int n = 0, wxBitmap **choices = NULL,
		int dim = 0, long style = wxHORIZONTAL,
		Constdata char *name = wxRadioBoxNameStr);

    void  Enable(int item, Bool enable);
    int   FindString(char *s);
    char  *GetLabel(int item);
    int   GetSelection(void);
    char  *GetStringSelection(void);
    int   Number()				{ return num_toggles; }
    void  SetLabel(int item, char *label);
    void  SetLabel(int item, wxBitmap *bitmap);
    void  SetSelection(int n);
    char  *GetString (int N) { return GetLabel(N); }
    void  SetStringSelection(char *s);
    Bool  Show(int item, Bool show);
    // root methods to parent class
    virtual void  ChangeColours(void);
    virtual void  Enable(Bool enable)	{ wxItem::Enable(enable); }
    virtual void  SetFont(wxFont *font);
    virtual char  *GetLabel(void)	{ return wxItem::GetLabel(); }
    virtual void  SetLabel(char *label)	{ wxItem::SetLabel(label); }
    virtual Bool  Show(Bool show)	{ return wxItem::Show(show); }
    virtual int   GetNumberOfRowsOrCols(void)  { return num_Rows; }
    virtual void  SetNumberOfRowsOrCols(int n) { num_Rows = n; }
private:
    #ifdef Have_Xt_Types
    static void EventCallback(Widget w, XtPointer clientData, XtPointer ptr);
    #endif

    void* toggles; // of type Widget*
    wxBitmap* bmps;
    int   num_toggles;
    int   num_Rows;
};

#endif // RadioBox_h
