/*								-*- C++ -*-
 * $Id: WIN_scrollbar.h,v 1.1 1996-09-25 11:07:11+02 mho Exp $
 *
 * Purpose: scrollbar panel item
 *
 * Authors: Mark Newsam, Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Mark)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef ScrollBar_h
#define ScrollBar_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;

class wxScrollBar : public wxItem {
DECLARE_DYNAMIC_CLASS(wxScrollBar);
public:
    wxScrollBar(void);
    wxScrollBar(wxPanel *panel, wxFunction func,
		int x = -1, int y = -1, int width = -1, int height = -1,
		long style = wxHORIZONTAL,
		Constdata char *name = wxScrollBarNameStr);

    Bool Create(wxPanel *panel, wxFunction func,
		int x = -1, int y = -1, int width = -1, int height = -1,
		long style = wxHORIZONTAL,
		Constdata char *name = wxScrollBarNameStr);

    void SetValue(int viewStart);
    int  GetValue(void);

    char *GetLabel(void);
    void SetLabel(char *label);

    void SetPageLength(int pageLength);
    void SetObjectLength(int objectLength);
    void SetViewLength(int viewLength);
    void GetValues(int *viewStart, int *viewLength, int *objectLength,
		   int *pageLength);

    void Command(wxCommandEvent& event);
private:
    int pLength, oLength, vLength, pos;
    int orientation;

#ifdef Have_Xt_Types
    static void EventCallback(Widget w, XtPointer clientData, XtPointer sinfo);
    Bool        HandleCallback(XtPointer ev);
    void        SetScrollBar(void);
#endif
};

#endif // ScrollBar_h
