/* Risk! for Linux..
 * countries.h
 *
 * Copyright (C) 1998 Joel Nordell
 *
 * This file is protected under the GPL license.
 */

#ifndef __GAMEDEFS_H__
#define __GAMEDEFS_H__

#include <gtk/gtk.h>

/************************ TURN STATES ************************/
typedef enum {
  BEGINNING,
  PLACING_ARMIES,
  ATTACKING,
  FORTIFYING
} TurnState;
/*************************************************************/

/************************ GAME OBJECT ************************/
typedef struct _Game {
  int num_players;	/* How many players? */
  int current_player;	/* Whose turn is it? */
  TurnState state;	/* State of the current turn */
} GameObject;
/*************************************************************/

/*********************** PLAYER OBJECT ***********************/
typedef struct _Player {
  char name[100];       /* Player's name */
  GdkColor color;       /* Player's color */
  int total_armies;     /* Total number of armies */
  int armies_in_hand;   /* Armies waiting to be placed */
} Player;
/*************************************************************/

/********************* CONTINENT OBJECT **********************/
typedef struct _Continent {
  char *name;           /* Name of continent */
  int armies_awarded;   /* Number of armies continent is worth */
  int num_countries;    /* Number of countries in continent */
  int countries[12];    /* List of countries in continent */
} Continent;  
/*************************************************************/

/********************** COUNTRY OBJECT ***********************/
typedef struct _Country {
  char *name;           /* Name of country */
  int continent;        /* Continent it belongs to */

  GdkBitmap *bitmap;    /* Pointer to bitmap of country */

  int width;            /* Width of country's bitmap */
  int height;           /* Height of country's bitmap */
  int xpos;             /* X Position of country's bitmap */
  int ypos;             /* Y Position of country's bitmap */

  int xtext;            /* X Position to write text */   
  int ytext;            /* Y Position to write text */

  int num_neighbors;    /* Number of neighboring countries */
  int neighbors[6];     /* Neighboring Countries */

  float lightness;      /* Lightness of country's color */
  GdkColor color;	/* Current color of country */

  int owner;		/* Which player owns this country */

  int num_armies;       /* Number of armies on the country */
} Country;
/*************************************************************/

#define MAX_PLAYERS		6

#define NUM_COUNTRIES		42
#define ALASKA			0
#define NORTHWEST_TERRITORY	1
#define ALBERTA			2
#define GREENLAND		3
#define ONTARIO			4
#define QUEBEC			5
#define WESTERN_UNITED_STATES	6
#define EASTERN_UNITED_STATES	7
#define CENTRAL_AMERICA		8
#define VENEZUELA		9
#define PERU			10
#define BRAZIL			11
#define ARGENTINA		12
#define ICELAND			13
#define SCANDINAVIA		14
#define GREAT_BRITAIN		15
#define NORTHERN_EUROPE		16
#define UKRAINE			17
#define WESTERN_EUROPE		18
#define SOUTHERN_EUROPE		19
#define NORTH_AFRICA		20
#define EGYPT			21
#define EAST_AFRICA		22
#define CONGO			23
#define SOUTH_AFRICA		24
#define MADAGASCAR		25
#define URAL			26
#define AFGHANISTAN		27
#define MIDDLE_EAST		28
#define INDIA			29
#define SIAM			30
#define CHINA			31
#define MONGOLIA		32
#define SIBERIA			33
#define IRKUTSK			34
#define YAKUTSK			35
#define KAMCHATKA		36
#define JAPAN			37
#define INDONESIA		38
#define NEW_GUINEA		39
#define WESTERN_AUSTRALIA	40
#define EASTERN_AUSTRALIA	41

#define NUM_CONTINENTS		6
#define NORTH_AMERICA		0
#define SOUTH_AMERICA		1
#define EUROPE			2
#define AFRICA			3
#define ASIA			4
#define AUSTRALIA		5

/********************* PUBLIC VARIABLES **********************/
#ifndef __GAME_C__
extern Player Players[MAX_PLAYERS];
extern Continent Continents[NUM_CONTINENTS];
extern Country Countries[NUM_COUNTRIES];
extern char  country_xbm_data[NUM_COUNTRIES][5000];
#endif
/*************************************************************/

#endif /* __GAMEDEFS_H__ */

