"""Maintains arbitrary output windows."""

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Tkinter import *
import string

import empQueue

###########################################################################
#############################  Simple window  #############################
class SimpDisp(empQueue.baseDisp):
    """Display command output in its own window."""
    def __init__(self, disp, title = "Empire output", width=None):
	empQueue.baseDisp.__init__(self, disp)

	# Create root window
	self.Root = Toplevel(class_='Output')
	self.Root.title(title)
	self.Root.iconname(title)
##	self.Root.minsize(1, 1)

	title = string.lower(string.split(title, None, 1)[0])

	# Create text box and scrollbar
	scrollY = Scrollbar(self.Root, name='scrollY')
	scrollY.pack(side=RIGHT, fill=Y)
	self.Text = Text(self.Root, name=title, state=DISABLED,
			 yscrollcommand=scrollY.set)
	self.Text.pack(side=LEFT, expand=1, fill=BOTH)
	scrollY['command'] = self.Text.yview
	scrollY.focus()

	# Allow configurable width
	if width!=None:
	    self.Text['width']=width

	self.Root.protocol('WM_DELETE_WINDOW', self.goAway)

    def goAway(self):
	self.data = empQueue.doNothing
	self.Root.destroy()

    def data(self, line):
	if self.data is empQueue.doNothing:
	    # Window was closed
	    return
	self.Text['state'] = NORMAL
	self.Text.insert(END, line+"\n")
	self.Text['state'] = DISABLED
