#include <qpainter.h>
#include "messagebox.h"

MsgViewItem::MsgViewItem(Message *theMsg, unsigned short theIndex, QListView *parent) : QListViewItem(parent), msg(theMsg)
{ 
   index = (unsigned short)theIndex;
   
   setText(0, "*");
   setText(1, msg.cmdStr());
   setText(2, msg.timeRec());
   setText(3, msg.directEvent() ? "*" : " ");
   setText(4, msg.licqSent() ? msg.licqVerStr() : "");
}


void MsgViewItem::paintCell( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
   if (index != -1) 
      QListViewItem::paintCell(p, QColorGroup(cg.foreground(), cg.background(), cg.light(), cg.dark(), cg.mid(), QColor("blue"), cg.base()), column, width, align);
   else
      QListViewItem::paintCell(p, cg, column, width, align);

   // add line to bottom and right side
   p->setPen(cg.mid());
   p->drawLine(0, height() - 1, width - 1, height() - 1);
   p->drawLine(width - 1, 0, width - 1, height() - 1);
}


const char *MsgViewItem::key (int column, bool ascending) const
{
   // does nothing for now
   static char tmpString[64];
   sprintf(tmpString, "%s", QListViewItem::key(column, ascending));
   return (tmpString);

}



//-----MsgView::constructor------------------------------------------------------------------------
MsgView::MsgView (QWidget *parent = 0, const char *name = 0) : QListView(parent, name)
{
   addColumn("N", 25);
   addColumn("Event Type", 105);
   addColumn("Time Received", 150);
   addColumn("D", 25);
   addColumn("Licq", 50);
   setColumnAlignment(0, AlignCenter);
   setColumnAlignment(3, AlignCenter);
   setColumnAlignment(4, AlignRight);
   setAllColumnsShowFocus (true); 
   
   QPalette pal(palette());
   QColorGroup normal(pal.normal());
   QColorGroup newNormal(normal.foreground(), normal.background(), normal.light(), normal.dark(),
                         normal.mid(), normal.text(), QColor(192, 192, 192));
   setPalette(QPalette(newNormal, pal.disabled(), newNormal));
   setStyle(WindowsStyle);
   setFrameStyle(QFrame::Panel | QFrame::Sunken);

}

Message *MsgView::currentMsg(void)
{
   if (currentItem() == NULL) return (NULL);
   return (&((MsgViewItem *)currentItem())->msg);
}


//-----MsgView::mouseReleaseEvent------------------------------------------------------------------
void MsgView::mouseReleaseEvent(QMouseEvent *e)
{
   // does nothing special
   QListView::mouseReleaseEvent(e);
}


//-----MsgView::markRead---------------------------------------------------------------------------
void MsgView::markRead(short index)
{
   MsgViewItem *e = (MsgViewItem *)firstChild();
   if (e == NULL) return;

   if (e->index == index) 
   {
      e->index = -1;
      e->setText(0, "");
   }
   else if (e->index > index) 
      e->index--;
   
   while ((e = (MsgViewItem *)e->nextSibling()) != NULL) 
   {
      if (e->index == index) 
      {
         e->index = -1;
         e->setText(0, "");
      }
      else if (e->index > index) 
         e->index--;
   }


}
