#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifndef KLICQ_H
#define KLICQ_H
 
#include "icq.h"
#include "licqgui.h"
#include <kapp.h>
#include <kwm.h>
#include <qpopmenu.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpixmap.h>

class KLicq : public QLabel
{
	Q_OBJECT

public:
	KLicq(QWidget *parent=0);
	~KLicq();
	
	void reset();

signals:
	void change_status_from_dock(int);
	void quitapp();
	void lowericq();
	void raiseicq();

public slots:
        void change_dock_status(unsigned short int stat);
        void m_dock();

protected slots:	
	void popresult(int index);
	        
protected:
	void m_popupMenu(int x,int y);
        void mousePressEvent(QMouseEvent *);
	QPixmap *pmOnline, *pmOffline, *pmAway, *pmDnd, *pmOccupied, *pmNa, *pmMessage;         
	
private:
	void m_displayPixmap();
	bool m_isDocked;
	unsigned short int OwnerStatus;
};

#endif
