/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: Node.java,v 1.1 1997/09/17 11:31:05 kwagen Exp $
 */

package vrml.external;

import iicm.vrml.pw.Field;
import iicm.vrml.pw.MFColor;
import iicm.vrml.pw.MFFloat;
import iicm.vrml.pw.MFInt32;
import iicm.vrml.pw.MFNode;
import iicm.vrml.pw.MFRotation;
import iicm.vrml.pw.MFString;
import iicm.vrml.pw.MFVec2f;
import iicm.vrml.pw.MFVec3f;
import iicm.vrml.pw.SFBool;
import iicm.vrml.pw.SFColor;
import iicm.vrml.pw.SFFloat;
import iicm.vrml.pw.SFImage;
import iicm.vrml.pw.SFInt32;
import iicm.vrml.pw.SFNode;
import iicm.vrml.pw.SFRotation;
import iicm.vrml.pw.SFString;
import iicm.vrml.pw.SFTime;
import iicm.vrml.pw.SFVec2f;
import iicm.vrml.pw.SFVec3f;
import iicm.vrml.vrwave.Scene;
import vrml.external.exception.*;
import vrml.external.field.*;

public class Node
{
  /**
   * Get a string specifying the type of this node.
   */

  public String getType ()
  {
    return pwnode_.nodeName ();
  }


  /**
   * Means of getting a handle to an EventIn of this node.
   */

  public EventIn getEventIn (String name) throws InvalidEventInException
  {
    Field eventin = pwnode_.getEvent (name, Field.F_EVENTIN);

    if (eventin == null)
      throw new InvalidEventInException ();

    EventIn e;
    int type = FieldTypes.UnknownType;

    if (eventin instanceof MFColor)
    {
      e = new EventInMFColor ();
      type = FieldTypes.MFCOLOR;
    }
    else if (eventin instanceof MFFloat)
    {
      e = new EventInMFFloat ();
      type = FieldTypes.MFFLOAT;
    }
    else if (eventin instanceof MFInt32)
    {
      e = new EventInMFInt32 ();
      type = FieldTypes.MFINT32;
    }
    else if (eventin instanceof MFNode)
    {
      e = new EventInMFNode ();
      type = FieldTypes.MFNODE;
    }
    else if (eventin instanceof MFRotation)
    {
      e = new EventInMFRotation ();
      type = FieldTypes.MFROTATION;
    }
    else if (eventin instanceof MFString)
    {
      e = new EventInMFString ();
      type = FieldTypes.MFSTRING;
    }
    else if (eventin instanceof MFVec2f)
    {
      e = new EventInMFVec2f ();
      type = FieldTypes.MFVEC2F;
    }
    else if (eventin instanceof MFVec3f)
    {
      e = new EventInMFVec3f ();
      type = FieldTypes.MFVEC3F;
    }
    else if (eventin instanceof SFBool)
    {
      e = new EventInSFBool ();
      type = FieldTypes.SFBOOL;
    }
    else if (eventin instanceof SFColor)
    {
      e = new EventInSFColor ();
      type = FieldTypes.SFCOLOR;
    }
    else if (eventin instanceof SFFloat)
    {
      e = new EventInSFFloat ();
      type = FieldTypes.SFFLOAT;
    }
    else if (eventin instanceof SFImage)
    {
      e = new EventInSFImage ();
      type = FieldTypes.SFIMAGE;
    }
    else if (eventin instanceof SFInt32)
    {
      e = new EventInSFInt32 ();
      type = FieldTypes.SFINT32;
    }
    else if (eventin instanceof SFNode)
    {
      e = new EventInSFNode ();
      type = FieldTypes.SFNODE;
    }
    else if (eventin instanceof SFRotation)
    {
      e = new EventInSFRotation ();
      type = FieldTypes.SFROTATION;
    }
    else if (eventin instanceof SFString)
    {
      e = new EventInSFString ();
      type = FieldTypes.SFSTRING;
    }
    else if (eventin instanceof SFTime)
    {
      e = new EventInSFTime ();
      type = FieldTypes.SFTIME;
    }
    else if (eventin instanceof SFVec2f)
    {
      e = new EventInSFVec2f ();
      type = FieldTypes.SFVEC2F;
    }
    else if (eventin instanceof SFVec3f)
    {
      e = new EventInSFVec3f ();
      type = FieldTypes.SFVEC3F;
    }
    else
    {
      System.err.println ("vrml.external.Node. internal error: field type " + eventin.fieldName () + " not yet handled");
      e = new EventIn ();
    }

    e.initialize (eventin, type, scene_);

    return e;
  }


  /**
   * Means of getting a handle to an EventOut of this node.
   */
   
  public EventOut getEventOut (String name) throws InvalidEventOutException
  {
    Field eventout = pwnode_.getEvent (name, Field.F_EVENTOUT);

    if (eventout == null)
      throw new InvalidEventOutException ();

    EventOut e;
    int type = FieldTypes.UnknownType;

    if (eventout instanceof MFColor)
    {
      e = new EventOutMFColor ();
      type = FieldTypes.MFCOLOR;
    }
    else if (eventout instanceof MFFloat)
    {
      e = new EventOutMFFloat ();
      type = FieldTypes.MFFLOAT;
    }
    else if (eventout instanceof MFInt32)
    {
      e = new EventOutMFInt32 ();
      type = FieldTypes.MFINT32;
    }
    else if (eventout instanceof MFNode)
    {
      e = new EventOutMFNode ();
      type = FieldTypes.MFNODE;
    }
    else if (eventout instanceof MFRotation)
    {
      e = new EventOutMFRotation ();
      type = FieldTypes.MFROTATION;
    }
    else if (eventout instanceof MFString)
    {
      e = new EventOutMFString ();
      type = FieldTypes.MFSTRING;
    }
    else if (eventout instanceof MFVec2f)
    {
      e = new EventOutMFVec2f ();
      type = FieldTypes.MFVEC2F;
    }
    else if (eventout instanceof MFVec3f)
    {
      e = new EventOutMFVec3f ();
      type = FieldTypes.MFVEC3F;
    }
    else if (eventout instanceof SFBool)
    {
      e = new EventOutSFBool ();
      type = FieldTypes.SFBOOL;
    }
    else if (eventout instanceof SFColor)
    {
      e = new EventOutSFColor ();
      type = FieldTypes.SFCOLOR;
    }
    else if (eventout instanceof SFFloat)
    {
      e = new EventOutSFFloat ();
      type = FieldTypes.SFFLOAT;
    }
    else if (eventout instanceof SFImage)
    {
      e = new EventOutSFImage ();
      type = FieldTypes.SFIMAGE;
    }
    else if (eventout instanceof SFInt32)
    {
      e = new EventOutSFInt32 ();
      type = FieldTypes.SFINT32;
    }
    else if (eventout instanceof SFNode)
    {
      e = new EventOutSFNode ();
      type = FieldTypes.SFNODE;
    }
    else if (eventout instanceof SFRotation)
    {
      e = new EventOutSFRotation ();
      type = FieldTypes.SFROTATION;
    }
    else if (eventout instanceof SFString)
    {
      e = new EventOutSFString ();
      type = FieldTypes.SFSTRING;
    }
    else if (eventout instanceof SFTime)
    {
      e = new EventOutSFTime ();
      type = FieldTypes.SFTIME;
    }
    else if (eventout instanceof SFVec2f)
    {
      e = new EventOutSFVec2f ();
      type = FieldTypes.SFVEC2F;
    }
    else if (eventout instanceof SFVec3f)
    {
      e = new EventOutSFVec3f ();
      type = FieldTypes.SFVEC3F;
    }
    else
    {
      System.err.println ("vrml.external.Node. internal error: field type " + eventout.fieldName () + " not yet handled");
      e = new EventOut ();
    }
    
    e.initialize (eventout, type, scene_);

    return e;
  }


  /** VRwave implementation. do not call from applets */

  private iicm.vrml.pw.Node pwnode_;
  private Scene scene_;

  public Node (iicm.vrml.pw.Node pwnode, Scene scene)
  {
    pwnode_ = pwnode;
    scene_ = scene;
  }

  public iicm.vrml.pw.Node getpwNode ()
  {
    return pwnode_;
  }
}
