/*********************************************************************
 * vi:set ts=4 nowrap:
 *
 * $Id: syserrs.c,v 1.1 1998/12/06 15:30:57 nicb Exp $
 *
 * System call handlers
 *
 * These calls can be used in any system call situation, to handle
 * the trivial error cases
 *
 * Originally written by Nicola Bernardini [nicb@axnet.it]
 *
 * This module is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#include <stdarg.h>
#include <errno.h>
#include <stdio.h>

#include "config.h"

static void
_syscall_message(const int cmd_code, const char *type, const char *message,
	va_list args)
{
	char buffer[256] = { '\0' };
	sprintf(buffer, "System call %s: [%s] - %s\n", type, strerror(errno),
		message);
	
	(void) vfprintf(stderr, buffer, args);
	fflush(stderr);
}

int
syscall_warning(const int cmd_code, const char *message, ...)
{
	if (cmd_code < 0)
	{
		va_list args;
		va_start(args, message);

		_syscall_message(cmd_code, "warning", message, args);

		va_end(args);
	}

	return cmd_code;
}

int
syscall_fatal(const int cmd_code, const int exit_value, const char *message, ...)
{
	/*
	 * FIXME: now we should exit the csound way, i.e. with die();
	 * unfortunately, die() does ignore the exit value we've set,
	 * so we loose information... and we better exit with exit :-)
	 */
	if (cmd_code < 0)
	{
		va_list args;
		va_start(args, message);

		_syscall_message(cmd_code, "fatal error", message, args);
		exit(exit_value);
	}
	
	return cmd_code;
}
