/********************************************************************************
* Copyright (c) Erik Kunze 1999
*
* The archive is a part of the registered Spectrum emulator package 'XZX',
* and may not be distributed.  The copyright holder makes no representations
* about the suitability of this software for any purpose.  It is provided "as
* is" without express or implied warranty. THE CODE MAY NOT BE MODIFIED OR
* REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*
* $Id: breakpoint.h,v 1.2 1999/01/14 16:56:33 erik Rel $
*******************************************************************************/
#ifndef _XZX_BREAKPOINT_H
#define _XZX_BREAKPOINT_H
typedef struct _breakpoint {
int page;
uns16 addr;
uns8 opcode;
char opstr[16];
} Breakpoint;
extern unsigned int BpSet(int, uns16);
extern void BpUnset(unsigned int);
extern unsigned int BpUnsetAll(void);
extern void BpDestroy(unsigned int);
extern unsigned int BpDestroyAll(void);
extern Breakpoint *BpRetrieve(unsigned int);
extern unsigned int BpLookup(int, uns16);
#endif
