/*
 *  Copyright (C) 1998,9 by Marco G"otze.
 *
 *  This code is part of the wmpinboard source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#ifndef WMPINBOARD_H_INCLUDED
#define WMPINBOARD_H_INCLUDED

#include <X11/Xlib.h>

#include "features.h"

#define VERSION "wmpinboard 0.9.2 (1 Sep 99)"

#define MAX_NOTES 20  /* maximal number of notes */

#define STRING_BUF_SIZE 128  /* size of buffers for font descr. & suchlike */

#define C_NUM 20                   /* number of colors */
#define C_INNER palette[C_NUM].fg  /* mask color (interior of notes etc.) */
#define C_OUTER palette[C_NUM].bg  /* mask color (exterior of notes etc.) */
#define C_EXTRA palette[C_NUM].cr  /* additional mask color */

/* program modes with respect to interactive behavior... */
#define M_NOOP 0  /* "normal" mode (pinboard view) */
#define M_EDIT 1  /* edit mode */
#define M_MOVE 2  /* note being dragged (implies M_NOOP) */
#define M_BBAR 3  /* button bar being displayed (implies M_EDIT) */
#define M_DRAW 4  /* sketch mode, drawing (implies M_EDIT) */
#define M_ERAS 5  /* sketch mode, erasing (implies M_EDIT) */

/* command line actions */
#define A_DUMP     0  /* "cooked" dump */
#define A_DUMP_RAW 1  /* raw dump */
#define A_IRON     2  /* "iron" notes */
#define A_DEL      3  /* delete a now */
#define A_ADD      4  /* add "cooked" */
#define A_ADD_RAW  5  /* add raw */
#define A_EXPORT   6  /* export sketch */

#define BBAR_ANI_INT  2000L  /* usecs interval for panel animation */
#define NOTE_ANI_INT 15000L  /* usecs interval for note animation */

typedef struct {
  int col;
  int x, y;
  char text[10*6];
  int cursor;
  char sketch[(64/8)*64];   /* bitfield; last byte used for other purposes... */
  char creases[(16/8)*16];  /* dto. */
} data_t;

typedef struct {
  unsigned long fg, bg, cr;  /* foreground, background, crease color */
} palette_t;

extern Display *display;
extern Window win;
extern XImage *img;
extern Pixmap app;
extern GC normalGC, fontGC, fillGC;
#ifdef CREASES
extern GC creaseGC;
#endif
extern XFontStruct *font;

extern const char c_group[C_NUM];
extern int notes_count;
extern data_t ndata[MAX_NOTES];
extern palette_t palette[C_NUM+1];

#endif  /* WMPINBOARD_H_INCLUDED */

