char *init_scheme_string = "\
\n\
\n\
\n\
\n\
\n\
\n\
\n\
\n\
(use-modules (app scwm optargs))\n\
\n\
(define-public guile-version (+ (string->number (major-version)) \n\
				(/ (string->number (minor-version)) 10)))\n\
\n\
\n\
\n\
(if (> guile-version 1.3)\n\
    (setvbuf (current-output-port) _IONBF))\n\
\n\
\n\
(define quit scwm-quit)\n\
(undefine scwm-quit)\n\
\n\
(define FIXED-FONT (make-font \"fixed\"))\n\
\n\
\n\
\n\
\n\
(set-not-menu-foreground! \"black\")\n\
(set-not-menu-background! \"gray\")\n\
\n\
\n\
(set-highlight-foreground! \"white\")\n\
(set-highlight-background! \"navyblue\")\n\
(set-icon-font! FIXED-FONT)\n\
(set-title-font! FIXED-FONT)\n\
(set-title-justify! \'center)\n\
\n\
\n\
\n\
(define hack-interactive-move rubber-band-move)\n\
(define hack-interactive-resize rubber-band-resize)\n\
\n\
\n\
\n\
(define* (resize-or-raise)\n\
  \"Perform a resize, raise, or lower based on the mouse-event-type.\n\
To be bound to a window decoration: click does `raise-window\',\n\
motion does `interactive-resize\', and double-click does\n\
`lower-window\'.\"\n\
  (interactive)\n\
  (case (mouse-event-type)\n\
    ((click) (raise-window))\n\
    ((motion) (hack-interactive-resize))\n\
    ((double-click) (lower-window))))\n\
\n\
(define* (move-or-raise)\n\
  \"Perform a move, raise, or lower based on the mouse-event-type.\n\
To be bound to a window decoration: click does `raise-window\',\n\
motion does `interactive-move\', and double-click does\n\
`lower-window\'.\"\n\
  (interactive)\n\
  (case (mouse-event-type)\n\
    ((click) (raise-window))\n\
    ((motion) (hack-interactive-move))\n\
    ((double-click) (lower-window))))\n\
\n\
\n\
\n\
(bind-mouse \'frame-corners 1 resize-or-raise)\n\
\n\
(bind-mouse \'(title frame-sides) 1 move-or-raise)\n\
\n\
(bind-mouse \'icon 1 #f deiconify-window)\n\
\n\
(let ((default-menu (make-menu \n\
		     (list\n\
		      (make-menuitem \"Default Menu\" #f)\n\
		      (make-menuitem \"Exit SCWM\" quit))\n\
		     (make-color \"gray\") (make-color \"black\")\n\
		     (make-color \"slate gray\") FIXED-FONT)))\n\
  (bind-mouse \'root 1 #f (lambda () (popup-menu default-menu))))\n\
\n\
\n\
\n\
\n\
\n\
(define (with-grabbed-server thunk)\n\
  \"Execute THUNK with the X server grabbed.\"\n\
  #f)\n\
\n\
(let ((xgs X-grab-server)\n\
      (xugs X-ungrab-server))\n\
  (set! with-grabbed-server (lambda (thunk)\n\
			      (dynamic-wind xgs thunk xugs))))\n\
\n\
\n\
(undefine X-grab-server)\n\
(undefine X-ungrab-server)\n\
\n\
\n\
\n\
(if (not (defined? \'run-hook))\n\
    \n\
    (define-public (run-hook hook-list . args)\n\
      \"Runs the procedures in HOOK-LIST, each getting ARGS as their arguments.\n\
If any error, the others still run.  The procedures are executed in the\n\
order in which they appear in HOOK-LIST\"\n\
      (for-each (lambda (p) \n\
		  (catch #t\n\
			 (lambda () (apply p args))\n\
			 (lambda args\n\
			   (display \"Error running hook: \")\n\
			   (write p)\n\
			   (newline))))\n\
		hook-list)))\n\
\n\
\n\
(if (not (defined? \'reset-hook!))\n\
    (defmacro-public reset-hook! (hook)\n\
      `(set! ,hook ())))\n\
\n\
(if (not (defined? \'make-hook))\n\
    (begin\n\
      \n\
      (define-public (make-hook . n) ())\n\
      (define-public hook? list?))\n\
    \n\
    (define-public (hook? h) \n\
      (and (pair? h) (eq? (car h) \'hook))))\n\
\n\
(define-public (append-hook! hook proc)\n\
  \"Add PROC to HOOK at the end of the list.\"\n\
  (add-hook! hook proc #t))\n\
\n\
\n\
\n\
(define-public *scwm-modules* \'())\n\
\n\
(define-public (scwm-module-loaded? module)\n\
  \"Return #t iff MODULE has been loaded.\"\n\
  (let ((entry (assoc module *scwm-modules*))) \n\
    (and entry (null? (cdr entry)))))\n\
\n\
\n\
\n\
\n\
\n\
(define (use-scwm-module-note-success module)\n\
  (let ((entry (assoc module *scwm-modules*)))\n\
    (if (not entry)\n\
	(set! *scwm-modules* (cons (cons module \'()) *scwm-modules*))\n\
	(let ((eval-after-load-proc (cdr entry)))\n\
	  (if (not (null? eval-after-load-proc))\n\
	      (let ((answer (eval-after-load-proc)))\n\
		(set-cdr! entry \'())\n\
		answer))))))\n\
\n\
(define-public (eval-after-load module proc)\n\
  \"Run PROC after MODULE is loaded.\n\
Run PROC immediately if MODULE has already been loaded.\"\n\
  (if (scwm-module-loaded? module)\n\
      (proc)\n\
      (set! *scwm-modules* (cons (cons module proc) *scwm-modules*))))\n\
\n\
(define (process-use-scwm-module module)\n\
  (if (symbol? module)\n\
      (set! module (append \'(app scwm) (list module))))\n\
  (catch #t\n\
	 (lambda ()\n\
	   (process-use-modules (list module))\n\
	   (use-scwm-module-note-success module)\n\
	   (run-hook load-processing-hook -1)\n\
	   module)\n\
	 (lambda (key . args)\n\
	   (display \"Error loading module: \")\n\
	   (display module) (newline)\n\
	   (catch #t\n\
		  (lambda () \n\
		    (apply handle-system-error (cons key args)) \n\
		    (backtrace))\n\
		  (lambda (key . args) #t))\n\
	   #f)))\n\
\n\
(define-public (process-use-scwm-modules module-list)\n\
  \"Returns a list of all the modules loaded in successfully.\n\
Modules that failed to load have #f in their place in the\n\
list instead of the module.\"\n\
  (map process-use-scwm-module (reverse module-list)))\n\
\n\
(defmacro use-scwm-modules modules\n\
  `(process-use-scwm-modules \',modules))\n\
\n\
(X-property-set! \'root-window \"_WIN_WM_NAME\" \"scwm\")\n\
(X-property-set! \'root-window \"_WIN_WM_VERSION\" (scwm-version))\n\
";
