/*
    The QuickLaunch Applet - Mini-icon launchers for the GNOME Panel
    Copyright (C) 1999  Fbio Gomes de Souza
    QuickLaunch Homepage: http://members.xoom.com/fabiofb/quicklaunch

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Author: Fbio Gomes de Souza <fabiofb@altavista.net>

*/

#include <gnome.h>
#include <gdk_imlib.h>
#include <dirent.h>
#include <applet-widget.h>
#include <stdio.h>
#include <sys/stat.h>
#define VERSION_STRING "0.7"
#define UNKNOWN_ICON "gnome-unknown.png"

void reload_data(void);


typedef struct {
  GtkWidget *button;
  GtkObject *dedit;
  GnomeDesktopEntry *dentry;
} Launcher;

GList *launcher_widgets = NULL;
GList *launchers = NULL;
GtkWidget *label;
GtkWidget *launcher_table;
GtkWidget *wnd;
GtkObject *dedit;

gint rows=2;
gint cols=2;
gint appcount=0;
gint orientation=0;

char *directory = NULL;

void cb_about(AppletWidget * widget,gpointer data)
{
  GtkWidget *about;
  const gchar *authors[]=
  {"Fabio Gomes de Souza <fabiofb@altavista.net>",NULL};

  about=gnome_about_new(_("The QuickLaunch Applet"),VERSION_STRING,
			"(c) 1999 Fabio Gomes de Souza",
			authors,_("Released under the GNU General Public "
				  "License\n\n"
				  "This applet adds some pretty small icons "
				  "for your launchers to your panel, like the "
				  "windowish QuickLaunch toolbar, avoiding "
				  "that annoying huge GNOME launchers."),
			NULL);
    gtk_widget_show(about);
    data = NULL;
    widget = NULL;
}

void launch_app_cb(GtkWidget *widget,gpointer data)
{
  static gint i;
  GnomeDesktopEntry *dentry;

  i=GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget),"index"));
  dentry=g_list_nth(launchers,i)->data;
  g_print("Launching: %s\n",dentry->name);
  gnome_desktop_entry_launch(dentry);
}

void destroy_launcher_widgets(void) 
{
  GList *p;
  p = launcher_widgets;

  while (p)
    {
      gtk_widget_destroy(GTK_WIDGET(p->data));
      p = p->next;
    }
  if (launcher_widgets)
    {
      g_list_free(launcher_widgets);
    }
  if (label) {
    gtk_widget_destroy(GTK_WIDGET(label));
    label = NULL;
  }
  launcher_widgets=NULL;
}

void cb_properties_apply(GtkWidget *widget,int page,gpointer index)
{
  GnomeDesktopEntry *dentry;
  GnomeDesktopEntry *old_dentry;
  static gint i;

  i=GPOINTER_TO_INT(index);
  old_dentry=g_list_nth(launchers,i)->data;
  dentry=gnome_dentry_get_dentry(GNOME_DENTRY_EDIT(dedit));
  if (dentry) {
    dentry->location = old_dentry->location;
    gnome_desktop_entry_save(dentry);
    reload_data();
  }
}

void cb_properties_close(GtkWidget *widget, int page,gpointer data)
{
  gtk_widget_destroy(widget);
  gtk_object_destroy(dedit);
  dedit = NULL;
}

static GtkWidget * create_properties_dialog(gint index)
{
  static gint i;
  GnomeDesktopEntry *dentry;
  GtkWidget *dialog;

  i=index;
  dentry=g_list_nth(launchers,i)->data;  

  dialog = gnome_property_box_new();
  gtk_window_set_title(GTK_WINDOW(dialog),_("Launcher Properties"));
  gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,FALSE,TRUE);
  
  dedit=gnome_dentry_edit_new_notebook(
       GTK_NOTEBOOK(GNOME_PROPERTY_BOX(dialog)->notebook));

  gnome_dentry_edit_set_dentry(GNOME_DENTRY_EDIT(dedit),dentry);

  gtk_signal_connect_object(GTK_OBJECT(dedit),"changed",
			    GTK_SIGNAL_FUNC(gnome_property_box_changed),
			    GTK_OBJECT(dialog));

  gtk_signal_connect(GTK_OBJECT(dialog),"apply",
		     GTK_SIGNAL_FUNC(cb_properties_apply),
		     index);
  gtk_signal_connect(GTK_OBJECT(dialog),"destroy",
		     GTK_SIGNAL_FUNC(cb_properties_close),
		     NULL);
  return dialog;
}

void cb_launcher_properties(GtkWidget *widget,gpointer index)
{
  GtkWidget *dialog;
  GtkWidget *button;
  static gint i;

  if (dedit) 
    return;
  i=GPOINTER_TO_INT(index);
  button = g_list_nth(launcher_widgets,i)->data;
  dialog = gtk_object_get_data(GTK_OBJECT(button),"properties-box");

  dialog = create_properties_dialog(index);
  gtk_object_set_data(GTK_OBJECT(button),"properties-box",dialog);
  gtk_widget_show_all(dialog);
}

void cb_launcher_delete(GtkWidget *widget,gint *index)
{
  static gint i;
  GnomeDesktopEntry *dentry;
  
  i=(gint)index;
  dentry=g_list_nth(launchers,i)->data;  
  unlink(dentry->location);
  reload_data();
}

void launcher_table_update(void) 
{
  gint x=0;
  gint y=0;
  gint c,i;
  GtkWidget *button;
  GtkWidget *pixmap;
  GtkWidget *menu;
  GnomeDesktopEntry *dentry;
  GnomeUIInfo uinfo[5] = {
    GNOMEUIINFO_END,
    GNOMEUIINFO_END,
    GNOMEUIINFO_END,
    GNOMEUIINFO_END,
    GNOMEUIINFO_END,
  };

  destroy_launcher_widgets();
  c=g_list_length(launchers);
  if (orientation)
    gtk_table_resize(GTK_TABLE(launcher_table),c/2,1);
  else
    gtk_table_resize(GTK_TABLE(launcher_table),1,c/2);
  if (c == 0) {
    label=gtk_label_new("Please drop\nlaunchers here");
    gtk_table_attach_defaults(GTK_TABLE(launcher_table),label,0,1,0,1);
    gtk_widget_show(label);
    return;
  }
  for (i=0; i < c; i++) 
    {
      dentry=(g_list_nth(launchers,i))->data;

      if (!dentry->icon)
	dentry->icon = gnome_pixmap_file(UNKNOWN_ICON);

      button=gtk_button_new();
      pixmap=gnome_stock_pixmap_widget_at_size(NULL,dentry->icon,16,16);
      gtk_container_set_border_width(GTK_CONTAINER(button),0);
      gtk_container_add(GTK_CONTAINER(button),pixmap);
      gtk_widget_show(pixmap);
      if (!orientation)
	gtk_table_attach_defaults(GTK_TABLE(launcher_table),button,
				  x,x+1,y,y+1);
      else
	gtk_table_attach_defaults(GTK_TABLE(launcher_table),button,
				  y,y+1,x,x+1);
      gtk_container_queue_resize(GTK_CONTAINER(launcher_table));
      gtk_container_clear_resize_widgets(GTK_CONTAINER(launcher_table));
      gtk_widget_show(button);
      gtk_object_set_data(GTK_OBJECT(button),"index",(gint *)i);
      gtk_signal_connect(GTK_OBJECT(button),"clicked",
			 GTK_SIGNAL_FUNC(launch_app_cb),NULL);
      applet_widget_set_widget_tooltip(APPLET_WIDGET(wnd),button,dentry->name);
      launcher_widgets=g_list_append(launcher_widgets,button);

      uinfo[0].type            = GNOME_APP_UI_ITEM;
      uinfo[0].label           = N_("Launcher properties...");
      uinfo[0].hint            = NULL;
      uinfo[0].moreinfo        = cb_launcher_properties;
      uinfo[0].user_data       = (gint *)i;
      uinfo[0].unused_data     = NULL;
      uinfo[0].pixmap_type     = GNOME_APP_PIXMAP_NONE;
      uinfo[0].pixmap_info     = GNOME_STOCK_MENU_OPEN;
      uinfo[0].accelerator_key = 0;
      uinfo[0].ac_mods         = (GdkModifierType) 0;
      uinfo[0].widget          = NULL;

      uinfo[1].type            = GNOME_APP_UI_ITEM;
      uinfo[1].label           = N_("Delete launcher");
      uinfo[1].hint            = NULL;
      uinfo[1].moreinfo        = cb_launcher_delete;
      uinfo[1].user_data       = (gint *)i;
      uinfo[1].unused_data     = NULL;
      uinfo[1].pixmap_type     = GNOME_APP_PIXMAP_NONE;
      uinfo[1].pixmap_info     = GNOME_STOCK_MENU_OPEN;
      uinfo[1].accelerator_key = 0;
      uinfo[1].ac_mods         = (GdkModifierType) 0;
      uinfo[1].widget          = NULL;

      menu = gnome_popup_menu_new(uinfo);
      gnome_popup_menu_attach(menu,button,GINT_TO_POINTER(i));

      y++;
      if (y == 2)
      {
	y=0;
	x++;
      }
    }
}

void add_launcher(const char *filename)
{
  GnomeDesktopEntry *dentry;

  appcount++;
  dentry=gnome_desktop_entry_load(filename);
  if (dentry == NULL)
    return;
  launchers=g_list_append(launchers,dentry);

}

void scan_dir(char *dirname)
{
  struct dirent *dent;
  DIR *dir;
  
  directory=dirname;
  dir=opendir(dirname);
  if (dir == NULL) 
    return;
  while ((dent = readdir(dir)) != NULL) 
    {
      if (dent->d_name[0] == '.') 
	continue;

      add_launcher(g_concat_dir_and_file(dirname,dent->d_name));
    }
  closedir(dir);
  launcher_table_update();

}

void reload_data(void)
{
  destroy_launcher_widgets();
  g_list_free(launchers);
  launchers = NULL;
  scan_dir(directory);
}

void cb_applet_destroy(GtkWidget *applet,gpointer data)
{
  g_print("Destroying applet\n");
  destroy_launcher_widgets();
  gtk_exit(0);
}

void drop_launcher(gchar *filename)
{
  GnomeDesktopEntry *dentry;

  dentry=gnome_desktop_entry_load(filename);
  if (dentry == NULL)
    return;  
  dentry->location=g_concat_dir_and_file(directory,g_basename(filename));
  gnome_desktop_entry_save(dentry);
  
}

void drag_data_received(GtkWidget *widget,
			GdkDragContext *context,
			gint x,
			gint y,
			GtkSelectionData *selection_data,
			guint info,
			guint time,
			gpointer data)
{
  GList *names;
  
  names = gnome_uri_list_extract_filenames ((char *)selection_data->data);
  g_list_foreach(names,(GFunc)drop_launcher,NULL);
  g_list_free(names);
  reload_data();
}

int msg_destroy(GtkWidget *widget,gpointer data)
{
  gtk_exit(1);
}

void cb_change_orient(GtkWidget *widget,PanelOrientType orient,gpointer data)
{
  switch(orient) {
  case ORIENT_UP:
  case ORIENT_DOWN:
    orientation=0;
    break;
  case ORIENT_LEFT:
  case ORIENT_RIGHT:
    orientation=1;
    break;
  }
  launcher_table_update();
}

int init_quicklaunch(void)
{

  GtkWidget *frame;
  GtkWidget *msg;

  static GtkTargetEntry drop_types [] = {
    { "text/uri-list",0,0 },
  };
  static gint n_drop_types = sizeof(drop_types) / sizeof(drop_types)[0];

  directory=gnome_util_home_file("quicklaunch");
  if (!g_file_test(directory,G_FILE_TEST_ISDIR))
    if (mkdir(directory,S_IRWXU)) {
      msg=gnome_message_box_new("Cannot create directory:\n"
				"~/.gnome/quicklaunch.\nAborting",
				GNOME_MESSAGE_BOX_ERROR);
      gtk_widget_show(msg);
      gtk_signal_connect(GTK_OBJECT(msg),"destroy",
			 GTK_SIGNAL_FUNC(msg_destroy),NULL);
      return 1;
    }

  wnd=applet_widget_new("quicklaunch_applet");
  gtk_signal_connect(GTK_OBJECT(wnd),"destroy",
		     GTK_SIGNAL_FUNC(cb_applet_destroy),NULL);
  gtk_signal_connect(GTK_OBJECT(wnd),"change_orient",
		     GTK_SIGNAL_FUNC(cb_change_orient),NULL);
  launcher_table=gtk_table_new(rows,cols,FALSE);
  gtk_container_set_resize_mode(GTK_CONTAINER(launcher_table),
				GTK_RESIZE_QUEUE);
  frame=gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);
  gtk_container_add(GTK_CONTAINER(frame),launcher_table);
  applet_widget_add(APPLET_WIDGET(wnd),frame);
  applet_widget_register_stock_callback(APPLET_WIDGET(wnd),
					"about",
					GNOME_STOCK_MENU_ABOUT,
					_("About..."),
					cb_about,
					NULL);
  gtk_drag_dest_set(GTK_WIDGET(wnd),
		    GTK_DEST_DEFAULT_MOTION | 
		    GTK_DEST_DEFAULT_HIGHLIGHT |
		    GTK_DEST_DEFAULT_DROP,
		    drop_types,n_drop_types,
		    GDK_ACTION_COPY);

  gtk_signal_connect(GTK_OBJECT(wnd),"drag_data_received",
		     GTK_SIGNAL_FUNC(drag_data_received),NULL);

  gtk_widget_realize(wnd);
  gtk_widget_show(launcher_table);
  gtk_widget_show(frame);
  gtk_widget_show(wnd);

  reload_data();
  return 0;
}

int main(int argc,char *argv[])
{
  applet_widget_init("quicklaunch_applet",VERSION_STRING,
		     argc,argv,NULL,0,NULL);
  init_quicklaunch();
  applet_widget_gtk_main();
  gtk_exit(0);
  return 0;
}









