/* Copyright (C) 1989, 1995, 1997, 1998 Aladdin Enterprises.  All rights reserved.
  
  This file is part of GNU Ghostscript.
  
  GNU Ghostscript is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
  anyone for the consequences of using it or for whether it serves any
  particular purpose or works at all, unless he says so in writing.  Refer to
  the GNU General Public License for full details.
  
  Everyone is granted permission to copy, modify and redistribute GNU
  Ghostscript, but only under the conditions described in the GNU General
  Public License.  A copy of this license is supposed to have been given to
  you along with GNU Ghostscript so you can know your rights and
  responsibilities.  It should be in a file named COPYING.  Among other
  things, the copyright notice and this notice must be preserved on all
  copies.
  
  Aladdin Enterprises is not affiliated with the Free Software Foundation or
  the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
  does not depend on any other GNU software.
*/

/*$Id: gdevx.h,v 1.4 1999/04/01 05:31:20 fedor Exp $ */
/* Requires gxdevice.h and x_.h */

#ifndef gdevx_INCLUDED
#  define gdevx_INCLUDED

#if defined(DISPLAYGHOSTSCRIPT) && !defined(DEBUG)
/* Unfortunately, we need to get data from the gstate for DGS */
/* namely, to make the X offsets.  The window and gc are there, too */
#include "igstate.h"
#endif

/* Required for gx_device_common below -jsc */
#ifdef DISPLAYGHOSTSCRIPT
#include "gxdevice.h"
#endif

/* flags for what type of system is in control of the window */
typedef enum {
  gs_x_gs, gs_x_ghostview
#ifdef DISPLAYGHOSTSCRIPT
  , gs_x_dpsagent
#endif
} gs_x_winowner;

#define GSX_GS        (0)
#define GSX_GHOSTVIEW (1)
#ifdef DISPLAYGHOSTSCRIPT
#define GSX_DPSAGENT  (2)
#endif

/* Define the type of an X pixel. */
typedef unsigned long x_pixel;

/* Define a rectangle structure for update bookkeeping */
typedef struct rect_s {
    int xo, yo, xe, ye;
} rect;

/* Define dynamic color hash table structure */
struct x11color_s;
typedef struct x11color_s x11color;
struct x11color_s {
    XColor color;
    x11color *next;
};

/* Define PostScript to X11 font name mapping */
struct x11fontmap_s;
typedef struct x11fontmap_s x11fontmap;
struct x11fontmap_s {
    char *ps_name;
    char *x11_name;
    char **std_names;
    char **iso_names;
    int std_count, iso_count;
    x11fontmap *next;
};

/* Define pixel value to RGB mapping */
typedef struct x11_rgb_s {
    gx_color_value rgb[3];
    bool defined;
} x11_rgb_t;

/* device name */
extern char gs_x11_type_name[];

#if defined(DISPLAYGHOSTSCRIPT)
/* state (per gstate) for Display GhostScript */
/* if DEBUG is on, define only in gdevx.c (cleaner) */
/* but its faster to inline them here */
/* technically, more might belong here...
   however, this is for DisplayGhostScript and we know we don't need
   those */
typedef struct gx_device_X_state_s {
    Colormap cmap;
    Window win;
    GC gc;
    /* A backing pixmap so X will handle exposure automatically */
    Pixmap bpixmap;		/* 0 if useBackingPixmap is false, */
                                /* or if it can't be allocated */
    Pixmap dest;
    gs_matrix initial_matrix;	/* the initial transformation */
    int width, height;
} gx_device_X_state;
#endif

/* Define the X Windows device */
typedef struct gx_device_X_s {
    gx_device_common;
    bool IsPageDevice;

    /* An XImage object for writing bitmap images to the screen */
    XImage image;

    /* Global X state */
    Display *dpy;
    Screen *scr;
    XVisualInfo *vinfo;

#ifndef DISPLAYGHOSTSCRIPT
    /* marked as hidden to enforce the use of the defines */
    Colormap cmap_hidden;
    Window win_hidden;
    GC gc_hidden;
    /* A backing pixmap so X will handle exposure automatically */
    Pixmap bpixmap_hidden;	/* 0 if useBackingPixmap is false, */
				/* or if it can't be allocated */
    Pixmap dest_hidden;		/* bpixmap if non-0, else win */
    gs_matrix initial_matrix_hidden;	/* the initial transformation */
#define xdev_cmap_inline(xdev) (xdev->cmap_hidden)
#define xdev_set_cmap_inline(xdev, _cmap) ((void)(xdev->cmap_hidden = _cmap))
#define xdev_win_inline(xdev) (xdev->win_hidden)
#define xdev_set_win_inline(xdev, _win) ((void)(xdev->win_hidden = _win))
#define xdev_gc_inline(xdev) (xdev->gc_hidden)
#define xdev_set_gc_inline(xdev, _gc) ((void)(xdev->gc_hidden = _gc))
#define xdev_bpixmap_inline(xdev) (xdev->bpixmap_hidden)
#define xdev_set_bpixmap_inline(xdev, _bpixmap) ((void)(xdev->bpixmap_hidden = _bpixmap))
#define xdev_dest_inline(xdev) (xdev->dest_hidden)
#define xdev_set_dest_inline(xdev, _dest) ((void)(xdev->dest_hiden = _dest))
#define xdev_initial_matrix_inline(xdev) (&(xdev->initial_matrix))
#else
#ifndef DEBUG
  /* its "cleaner" not to have these here, as they require other includes that */
  /* we really shouldn't have... but its much faster */
#define xdev_state_inline(xdev) ((gx_device_X_state*)(gs_state_driver_data_inline(igs)))
#define xdev_cmap_inline(xdev) (((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->cmap)
#define xdev_set_cmap_inline(xdev, _cmap) ((void)(((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->cmap = _cmap))
#define xdev_win_inline(xdev) (((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->win)
#define xdev_set_win_inline(xdev, _win) ((void)(((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->win = _win))
#define xdev_gc_inline(xdev) (((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->gc)
#define xdev_set_gc_inline(xdev, _gc) ((void)(((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->gc = _gc))
#define xdev_bpixmap_inline(xdev) (((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->bpixmap)
#define xdev_set_bpixmap_inline(xdev, _bpixmap) ((void)(((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->bpixmap = _bpixmap))
#define xdev_dest_inline(xdev) (((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->dest)
#define xdev_set_dest_inline(xdev, _dest) ((void)(((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->dest = _dest))
#define xdev_initial_matrix_inline(xdev) (&(((gx_device_X_state*)(gs_state_driver_data_inline(igs)))->initial_matrix))
#endif
#endif

    /* An optional Window ID supplied as a device parameter */
    Window pwin;

    gs_x_winowner owner;	/* flag to tell if ghostview or dpsagent is in control */
    Window mwin;		/* window to receive ghostview or dpsagent messages */
/* Don't include standard colormap stuff for X11R3 and earlier */
#if HaveStdCMap
    XStandardColormap *std_cmap;	/* standard color map if available */
#endif
    Atom NEXT, PAGE, DONE;	/* Atoms used to talk to ghostview */
    x_pixel colors_or;		/* 'or' of all device colors used so far */
    x_pixel colors_and;		/* 'and' ditto */
/* start area needing to be moved into gstate */
    rect update;		/* region needing updating */
    long up_area;		/* total area of update */
    /* (always 0 if no backing pixmap) */
    int up_count;		/* # of updates since flush */

    /* An intermediate pixmap for the stencil case of copy_mono */
    struct {
	Pixmap pixmap;
	GC gc;
	int raster, height;
    } cp;

    /* Structure for dealing with the halftone tile. */
    /* Later this might become a multi-element cache. */
    struct {
	Pixmap pixmap;
	Pixmap no_pixmap;	/* kludge to get around X bug */
	gx_bitmap_id id;
	int width, height, raster;
	x_pixel fore_c, back_c;
    } ht;

    /* Cache the function and fill style from the GC */
    int function;
    int fill_style;
    Font fid;
/* end area */
#define set_fill_style(style)\
  if ( xdev->fill_style != style )\
    XSetFillStyle(xdev->dpy, xdev_gc_inline(xdev), (xdev->fill_style = style))
#define set_function(func)\
  if ( xdev->function != func )\
    XSetFunction(xdev->dpy, xdev_gc_inline(xdev), (xdev->function = func))
#define set_font(font)\
  if ( xdev->fid != font )\
    XSetFont(xdev->dpy, xdev_gc_inline(xdev), (xdev->fid = font))

    x_pixel back_color, fore_color;

    Pixel background, foreground;
#define X_max_color_value 0xffff
#define cube_index(r,g,b) (((r) * xdev->color_info.dither_colors + (g)) * \
				  xdev->color_info.dither_colors + (b))
    x_pixel *dither_colors;
    ushort color_mask;
    int num_rgb;
    x11color *(*dynamic_colors)[];
    int max_dynamic_colors, dynamic_size, dynamic_allocs;
    x11_rgb_t *color_to_rgb;	/* [256] */
    int color_to_rgb_size;

#define note_color(pixel)\
  xdev->colors_or |= pixel,\
  xdev->colors_and &= pixel
#define set_back_color(pixel)\
  if ( xdev->back_color != pixel )\
   { xdev->back_color = pixel;\
     note_color(pixel);\
     XSetBackground(xdev->dpy, xdev_gc_inline(xdev), pixel);\
   }
#define set_fore_color(pixel)\
  if ( xdev->fore_color != pixel )\
   { xdev->fore_color = pixel;\
     note_color(pixel);\
     XSetForeground(xdev->dpy, xdev_gc_inline(xdev), pixel);\
   }

    /* Defaults set by resources */
    Pixel borderColor;
    Dimension borderWidth;
    String geometry;
    int maxGrayRamp, maxRGBRamp;
    String palette;
    String regularFonts;
    String symbolFonts;
    String dingbatFonts;
    x11fontmap *regular_fonts;
    x11fontmap *symbol_fonts;
    x11fontmap *dingbat_fonts;
    Boolean useXFonts, useFontExtensions, useScalableFonts, logXFonts;
    float xResolution, yResolution;

    /* Flags work around various X server problems. */
    Boolean useBackingPixmap;
    Boolean useXPutImage;
    Boolean useXSetTile;

    /* Buffered text awaiting display */
    struct {
	int item_count;
#define IN_TEXT(xdev) ((xdev)->text.item_count != 0)
	int char_count;
	gs_int_point origin;
	int x;			/* after last buffered char */
#define MAX_TEXT_ITEMS 12
	XTextItem items[MAX_TEXT_ITEMS];
#define MAX_TEXT_CHARS 25
	char chars[MAX_TEXT_CHARS];
    } text;
/*
 * All the GC parameters are set correctly when we buffer the first
 * character: we must call DRAW_TEXT before resetting any of them.
 * DRAW_TEXT assumes xdev->text.{item,char}_count > 0.
 */
#define DRAW_TEXT(xdev)\
   XDrawText(xdev->dpy, xdev_dest_inline(xdev), xdev_gc_inline(xdev), xdev->text.origin.x,\
	     xdev->text.origin.y, xdev->text.items, xdev->text.item_count)

} gx_device_X;

/* function to keep track of screen updates */
void x_update_add(P5(gx_device *, int, int, int, int));
void gdev_x_clear_window(P1(gx_device_X *));
int x_catch_free_colors(P2(Display *, XErrorEvent *));
int gdev_x_set_drawable(P2(gx_device_X *, Drawable));

/* Number used to distinguish when resolution was set from the command line */
#define FAKE_RES (16*72)

#if defined(DISPLAYGHOSTSCRIPT) && defined(DEBUG)
/* non-inlines for DISPLAYGHOSTSCRIPT users ... here to enforce code cleanliness */
gx_device_X_state * xdev_state_inline(P1(gx_device_X const *));
Colormap xdev_cmap_inline(P1(gx_device_X const *));
void xdev_set_cmap_inline(P2(gx_device_X *, Colormap));
Window xdev_win_inline(P1(gx_device_X const *));
void xdev_set_win_inline(P2(gx_device_X *, Window));
GC xdev_gc_inline(P1(gx_device_X const *));
void xdev_set_gc_inline(P2(gx_device_X *, GC));
Pixmap xdev_bpixmap_inline(P1(gx_device_X *));
void xdev_set_bpixmap_inline(P2(gx_device_X *, Pixmap));
Pixmap xdev_dest_inline(P1(gx_device_X *));
void xdev_set_dest_inline(P2(gx_device_X *, Pixmap));
gs_matrix * xdev_initial_matrix_inline(P1(gx_device_X *));
#endif

#endif /* gdevx_INCLUDED */
