#include "../include/aftersteplib.h"

/****************************************************************************
 * 
 * Loads a single color
 *
 ****************************************************************************/
unsigned long
GetColor (char *name)
{
  XColor color;
  XWindowAttributes attributes;

  XGetWindowAttributes (dpy, RootWindow (dpy, screen), &attributes);
  color.pixel = 0;
  if (!XParseColor (dpy, attributes.colormap, name, &color))
    fprintf (stderr, "%s: can't parse %s\n", MyName, name);
  else if (!XAllocColor (dpy, attributes.colormap, &color))
    fprintf (stderr, "%s: can't alloc %s\n", MyName, name);
  return color.pixel;
}
