/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com>
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */
#include "rcfile.h"
#include "misc.h"
#include "gcommon.h"
#include "changes.h"
#include "excludes.h"

extern struct site_t *all_sites;
extern GtkWidget *site_list, *status_bar;

extern GtkWidget *main_area_box, *area_data;
extern GtkWidget *the_tree;
extern GtkWidget *excludes_clist, *excludes_entry;

extern struct site_info *area_contents_s;
extern struct file_info *area_contents_f;

extern struct site_t *selected_site;

GtkWidget *make_site_info_area (struct site_t *the_site) {
   /* Used to arrange all the frames I'll be adding */
   GtkWidget *table, *subtable;
   GtkWidget *tablet;
   GtkWidget *label;
   gint files_on_site;
   extern bool rcfile_saved;
   bool should_save_at_end = false;
   gchar *remote_directory_tmp;
   /* It's not necessary to have all the widget allocations in a struct, 
    * but i like the look of the resulting code slightly more than
    * a huge great list of allocations.
    */
  
   char *window_title, *info;
   
   if (rcfile_saved) 
     should_save_at_end = true;
   area_contents_s = malloc (sizeof (struct site_info));
   window_title = (char *) malloc (50 + strlen(the_site->name));
   sprintf (window_title, "Information and attributes for site '%s'", the_site->name);
   
   area_contents_s->frame = gtk_frame_new (window_title);
   gtk_container_set_border_width (GTK_CONTAINER (area_contents_s->frame), 5);

   /* Table is used to arrange various frames in the main site frame */
   table = gtk_hbox_new (FALSE, 3);

   gtk_container_set_border_width (GTK_CONTAINER (table), 8);
   gtk_container_add (GTK_CONTAINER (area_contents_s->frame), table);
   
   /* Now we add things to the table. */
   
   /* Server details */
   area_contents_s->site_details_frame = gtk_frame_new ("Server Details");
   gtk_widget_show (area_contents_s->site_details_frame);
   tablet = gtk_table_new (4, 2, FALSE);
   gtk_table_set_col_spacings (GTK_TABLE (tablet), 2);
   gtk_table_set_row_spacings (GTK_TABLE (tablet), 3);
   gtk_container_set_border_width (GTK_CONTAINER (tablet), 5);

   gtk_widget_show (tablet);
   gtk_container_add (GTK_CONTAINER (area_contents_s->site_details_frame),
		      tablet);
   label = gtk_label_new ("Host Name:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   
   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 0, 1);
   area_contents_s->servername = gtk_entry_new ();
   /* This seems very odd. According to the docs, I should be using the
    * activate signal, yet it doesn't seem to work, and changed does! */
   gtk_signal_connect (GTK_OBJECT (area_contents_s->servername), "changed",
		       GTK_SIGNAL_FUNC (change_host_name), NULL);
   gtk_entry_set_text (GTK_ENTRY (area_contents_s->servername), 
		       (const gchar *) the_site->server);
   gtk_widget_show (area_contents_s->servername);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->servername,
			      1, 2, 0, 1);
   
/*   label = gtk_label_new ("Port:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 1, 2);*/
   /* Change from an entry to optionmenu or combo.
    * Find out what the possible values are though first. */
/*   area_contents_s->port = gtk_entry_new ();
   gtk_entry_set_text (GTK_ENTRY (area_contents_s->port),
		       (const gchar *) "port number");
   gtk_widget_show (area_contents_s->port);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->port,
			      1, 2, 1, 2);*/

   /* Protocol option */
   label = gtk_label_new ("Protocol:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 1, 2);
   
   area_contents_s->protocol = gtk_option_menu_new ();
   area_contents_s->proto_box = gtk_menu_new();
   
   area_contents_s->proto_ftp = gtk_menu_item_new_with_label ("FTP");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->proto_ftp),
		       "activate",
		       GTK_SIGNAL_FUNC (change_protocol),
		       (gpointer) "ftp");
   gtk_widget_show (area_contents_s->proto_ftp);
   
   area_contents_s->proto_dav = gtk_menu_item_new_with_label ("WebDAV");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->proto_dav),
		       "activate",
		       GTK_SIGNAL_FUNC (change_protocol),
		       (gpointer) "dav");
   gtk_widget_show (area_contents_s->proto_dav);
   
   gtk_menu_append (GTK_MENU (area_contents_s->proto_box), 
		    area_contents_s->proto_ftp);
   gtk_menu_append (GTK_MENU (area_contents_s->proto_box), 
		    area_contents_s->proto_dav);
  
   gtk_option_menu_set_menu (GTK_OPTION_MENU (area_contents_s->protocol),
			     area_contents_s->proto_box);
   if (selected_site->protocol == siteproto_ftp) {
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->protocol),
				   0);
   } else if (selected_site->protocol == siteproto_http) {
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->protocol),
				   1);
   }

   gtk_widget_show (area_contents_s->protocol);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->protocol,
			      1, 2, 1, 2);
   
   label = gtk_label_new ("Username:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 2, 3);
   area_contents_s->username = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (area_contents_s->username), "changed",
		       GTK_SIGNAL_FUNC (change_username), NULL);
   gtk_entry_set_text (GTK_ENTRY (area_contents_s->username),
		       (const gchar *) the_site->username);
   gtk_widget_show (area_contents_s->username);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->username,
			      1, 2, 2, 3);
   
   label = gtk_label_new ("Password:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 3, 4);
   area_contents_s->password = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (area_contents_s->password), "changed",
		       GTK_SIGNAL_FUNC (change_password), NULL);
   gtk_entry_set_text (GTK_ENTRY (area_contents_s->password),
		       (const gchar *) the_site->password);
   gtk_entry_set_visibility (GTK_ENTRY (area_contents_s->password), false);
   gtk_widget_show (area_contents_s->password);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->password,
			      1, 2, 3, 4);

   /* Directory info */

   area_contents_s->dir_frame = gtk_frame_new ("Locations");
   gtk_widget_show (area_contents_s->dir_frame);
   tablet = gtk_table_new (3, 2, FALSE);
   gtk_table_set_col_spacings (GTK_TABLE (tablet), 2);
   gtk_table_set_row_spacings (GTK_TABLE (tablet), 3);
   gtk_container_set_border_width (GTK_CONTAINER (tablet), 5);

   gtk_widget_show (tablet);
   gtk_container_add (GTK_CONTAINER (area_contents_s->dir_frame), tablet);

   /* Local directory */
   
   label = gtk_label_new ("Directory for local files:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label,
			      0, 1, 0, 1);
   gtk_widget_show (label);

   area_contents_s->local_dir = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (area_contents_s->local_dir), "changed",
		       GTK_SIGNAL_FUNC (change_local_dir), NULL);
   gtk_entry_set_text (GTK_ENTRY (area_contents_s->local_dir),
		       (const gchar *) the_site->local_root_user);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->local_dir,
			      1, 2, 0, 1);
   gtk_widget_show (area_contents_s->local_dir);

   /* Remote directory */
   
   label = gtk_label_new ("Directory for remote files:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label,
			      0, 1, 1, 2);
   gtk_widget_show (label);

   area_contents_s->remote_dir = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (area_contents_s->remote_dir), "focus-out-event",
		       GTK_SIGNAL_FUNC (change_remote_dir), NULL);
   
   gtk_entry_set_text (GTK_ENTRY (area_contents_s->remote_dir),
		       (const gchar *) the_site->remote_root_user);

   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->remote_dir,
			      1, 2, 1, 2);
   gtk_widget_show (area_contents_s->remote_dir);
   
   /* URL */
   
   label = gtk_label_new ("Root URL of the remote site:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label,
			      0, 1, 2, 3);
   area_contents_s->url = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (area_contents_s->url), "changed",
		       GTK_SIGNAL_FUNC (change_url), NULL);
   if (the_site->url)
     gtk_entry_set_text (GTK_ENTRY (area_contents_s->url),
			 (const gchar *) the_site->url);
   gtk_widget_show (area_contents_s->url);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->url,
			      1, 2, 2, 3);
   
   /* Flags frame (toggle buttons) */
   
   area_contents_s->flags_frame = gtk_frame_new ("Update attributes");
   gtk_widget_show (area_contents_s->flags_frame);
   tablet = gtk_vbox_new (0, true);
   gtk_container_set_border_width (GTK_CONTAINER (tablet), 5);

   gtk_widget_show (tablet);
   gtk_container_add (GTK_CONTAINER (area_contents_s->flags_frame),
		      tablet);
   area_contents_s->nodelete = gtk_check_button_new_with_label ("Delete remote file if local is deleted.");
   if (! the_site->nodelete) {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (area_contents_s->nodelete), TRUE);
   }
   gtk_signal_connect (GTK_OBJECT (area_contents_s->nodelete ), "toggled",
		       GTK_SIGNAL_FUNC (change_delete), NULL);
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->nodelete, true, true, 2);
   gtk_widget_show (area_contents_s->nodelete);
   
   area_contents_s->checkmoved = gtk_check_button_new_with_label ("Move remote file if local file is moved.");
   if (the_site->checkmoved) {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (area_contents_s->checkmoved), TRUE);
   }
   gtk_signal_connect (GTK_OBJECT (area_contents_s->checkmoved ), "toggled",
		       GTK_SIGNAL_FUNC (change_move_status ), NULL);
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->checkmoved, true, true, 2);
   gtk_widget_show (area_contents_s->checkmoved);

   area_contents_s->ftp_mode = gtk_check_button_new_with_label ("Use passive mode FTP.");
   if (the_site->ftp_pasv_mode) {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (area_contents_s->ftp_mode), TRUE);
   }
#ifdef USE_DAV
	if (the_site->protocol == siteproto_http)
	  gtk_widget_set_sensitive(area_contents_s->ftp_mode, FALSE);
#endif
   gtk_signal_connect (GTK_OBJECT (area_contents_s->ftp_mode ), "toggled",
		       GTK_SIGNAL_FUNC (change_passive_ftp ), NULL);
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->ftp_mode, true, true, 2);
   gtk_widget_show (area_contents_s->ftp_mode);

   area_contents_s->nooverwrite = gtk_check_button_new_with_label ("When uploading changed files, first delete them.");
   if (the_site->nooverwrite) {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (area_contents_s->nooverwrite), TRUE);
   }
   gtk_signal_connect (GTK_OBJECT (area_contents_s->nooverwrite ), "toggled",
							  GTK_SIGNAL_FUNC (change_nooverwrite ), NULL);
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->nooverwrite, true, true, 2);
   gtk_widget_show (area_contents_s->nooverwrite);

#if 0
   /* http options */
   area_contents_s->http_expect_continue = gtk_check_button_new_with_label ("Enable \"Expect: 100-continue\" workaround");
   if (the_site->http_no_expect)
     gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (area_contents_s->http_expect_continue), TRUE);
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->http_expect_continue, 
		       true, true, 1);
   if (the_site->protocol == siteproto_ftp) {
     gtk_widget_set_sensitive(area_contents_s->http_expect_continue, FALSE);
   }
   gtk_signal_connect (GTK_OBJECT (area_contents_s->http_expect_continue ), "toggled",
							  GTK_SIGNAL_FUNC (change_http_expect ), NULL);
   gtk_widget_show (area_contents_s->http_expect_continue);
   
   area_contents_s->limit_connections = gtk_check_button_new_with_label ("Limit the number of Http connections");

   if (the_site->http_limit)
     gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (area_contents_s->limit_connections), TRUE);
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->limit_connections, 
		       true, true, 1);
   if (the_site->protocol == siteproto_ftp) {
     gtk_widget_set_sensitive(area_contents_s->limit_connections, FALSE);
   }
   gtk_signal_connect (GTK_OBJECT (area_contents_s->limit_connections ), "toggled",
							  GTK_SIGNAL_FUNC (change_http_limit ), NULL);
   gtk_widget_show (area_contents_s->limit_connections);
#endif

   /* These were in the site_t struct, but aren't actually implemented.
    * According to Joe.

    area_contents_s->is_http_persistant = gtk_check_button_new_with_label ("HTTP DAV functions are persistant.");
   gtk_box_pack_start (GTK_BOX (tablet), area_contents_s->is_http_persistant,
		       true, true, 2);
   gtk_widget_show (area_contents_s->is_http_persistant);
	*/

   /* File attributes (permissions/sym links) */
   
   area_contents_s->file_attrib_frame = gtk_frame_new ("File attributes");
   gtk_widget_show (area_contents_s->file_attrib_frame);
   tablet = gtk_table_new (2, 2, false);
   gtk_table_set_col_spacings (GTK_TABLE (tablet), 2);
   gtk_table_set_row_spacings (GTK_TABLE (tablet), 3);
   gtk_container_set_border_width (GTK_CONTAINER (tablet), 5);

   gtk_widget_show (tablet);
   gtk_container_add (GTK_CONTAINER (area_contents_s->file_attrib_frame),
		      tablet);

   label = gtk_label_new ("Permissions Mode:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 0, 1);
   
   area_contents_s->perms_mode = gtk_option_menu_new ();
   area_contents_s->perms_mode_menu = gtk_menu_new();
   
   area_contents_s->perms_ignore = gtk_menu_item_new_with_label ("Ignore all");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->perms_ignore),
		       "activate",
		       GTK_SIGNAL_FUNC (change_perms),
		       (gpointer) "ignore");
   gtk_widget_show (area_contents_s->perms_ignore);
   area_contents_s->perms_exec = gtk_menu_item_new_with_label ("Executables only");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->perms_exec),
		       "activate",
		       GTK_SIGNAL_FUNC (change_perms),
		       (gpointer) "exec");
   gtk_widget_show (area_contents_s->perms_exec);
   area_contents_s->perms_all = gtk_menu_item_new_with_label ("Maintain for all");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->perms_all),
		       "activate",
		       GTK_SIGNAL_FUNC (change_perms),
		       (gpointer) "all");
   gtk_widget_show (area_contents_s->perms_all);
   
   gtk_menu_append (GTK_MENU (area_contents_s->perms_mode_menu),
		    area_contents_s->perms_ignore);
   gtk_menu_append (GTK_MENU (area_contents_s->perms_mode_menu),
		    area_contents_s->perms_exec);
   gtk_menu_append (GTK_MENU (area_contents_s->perms_mode_menu),
		    area_contents_s->perms_all);
   
   gtk_option_menu_set_menu (GTK_OPTION_MENU (area_contents_s->perms_mode),
			     area_contents_s->perms_mode_menu);

   /* Set the current value correctly */
   switch (selected_site->perms) {
    case sitep_ignore:
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->perms_mode), 0);
      break;
    case sitep_exec:
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->perms_mode), 1);
      break;
    case sitep_all:
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->perms_mode), 2);
      break;
   }

   gtk_widget_show (area_contents_s->perms_mode);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->perms_mode,
			      1, 2, 0, 1);
   
   label = gtk_label_new ("Symbolic Links:");
   gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);

   gtk_widget_show (label);
   gtk_table_attach_defaults (GTK_TABLE (tablet), label, 0, 1, 1, 2);
   
   area_contents_s->sym_link_mode = gtk_option_menu_new ();
   area_contents_s->sym_link_mode_menu = gtk_menu_new();
   
   area_contents_s->sym_follow = gtk_menu_item_new_with_label ("Follow all");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->sym_follow),
		       "activate",
		       GTK_SIGNAL_FUNC (change_sym_mode),
		       (gpointer) "follow");
   gtk_widget_show (area_contents_s->sym_follow);
   area_contents_s->sym_ignore = gtk_menu_item_new_with_label ("Ignore links");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->sym_ignore),
		       "activate",
		       GTK_SIGNAL_FUNC (change_sym_mode),
		       (gpointer) "ignore");
   gtk_widget_show (area_contents_s->sym_ignore);
   area_contents_s->sym_maintain = gtk_menu_item_new_with_label ("Maintain links");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->sym_maintain),
		       "activate",
		       GTK_SIGNAL_FUNC (change_sym_mode),
		       (gpointer) "maintain");
   gtk_widget_show (area_contents_s->sym_maintain);

   gtk_menu_append (GTK_MENU (area_contents_s->sym_link_mode_menu),
		    area_contents_s->sym_follow);
   gtk_menu_append (GTK_MENU (area_contents_s->sym_link_mode_menu),
		    area_contents_s->sym_ignore);
   gtk_menu_append (GTK_MENU (area_contents_s->sym_link_mode_menu),
		    area_contents_s->sym_maintain);
   
   gtk_option_menu_set_menu (GTK_OPTION_MENU (area_contents_s->sym_link_mode),
			     area_contents_s->sym_link_mode_menu);

   /* Set the current value correctly */
   switch (selected_site->symlinks) {
    case sitesym_follow:
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->sym_link_mode), 0);
      break;
    case sitesym_ignore:
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->sym_link_mode), 1);
      break;
    case sitesym_maintain:
      gtk_option_menu_set_history (GTK_OPTION_MENU (area_contents_s->sym_link_mode), 2);
      break;
   }

   gtk_widget_show (area_contents_s->sym_link_mode);
   gtk_table_attach_defaults (GTK_TABLE (tablet), area_contents_s->sym_link_mode,
			      1, 2, 1, 2);


   /* 'Advanced' stuff... Excludes & name mappings so far. */
   
   area_contents_s->advanced_frame = gtk_frame_new ("Advanced");
/*   gtk_container_set_border_width (GTK_CONTAINER (area_contents_s->advanced_frame), 5);*/
   gtk_widget_show (area_contents_s->advanced_frame);

   area_contents_s->advanced_notebook = gtk_notebook_new ();
   gtk_widget_show (area_contents_s->advanced_notebook);
   
   area_contents_s->excludes_vbox = gtk_vbox_new (FALSE, 2);
   label = gtk_label_new ("Excludes");
   gtk_widget_show (label);
   gtk_notebook_append_page (GTK_NOTEBOOK (area_contents_s->advanced_notebook),
			     GTK_WIDGET (area_contents_s->excludes_vbox),
			     GTK_WIDGET (label));
   gtk_widget_show (area_contents_s->excludes_vbox);
   
   excludes_clist = gtk_clist_new (1);
   gtk_clist_set_selection_mode (GTK_CLIST (excludes_clist), GTK_SELECTION_SINGLE);
/*   gtk_clist_set_column_width (GTK_CLIST (excludes_clist), 0, 100);*/
   populate_excludes ();
   gtk_clist_columns_autosize (GTK_CLIST (excludes_clist));
   gtk_signal_connect (GTK_OBJECT (excludes_clist), "select_row",
		       GTK_SIGNAL_FUNC (select_exclude), NULL);
/*   gtk_clist_select_row (GTK_CLIST (excludes_clist), 0, 0);*/
   gtk_clist_set_shadow_type (GTK_CLIST (excludes_clist), GTK_SHADOW_IN);
   
   area_contents_s->excludes_scroller = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (area_contents_s->excludes_scroller),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
   gtk_container_add (GTK_CONTAINER (area_contents_s->excludes_scroller),
		      excludes_clist);
   gtk_widget_show (area_contents_s->excludes_scroller);
   gtk_box_pack_start (GTK_BOX (area_contents_s->excludes_vbox), area_contents_s->excludes_scroller,
		       TRUE, TRUE, 5);
   gtk_widget_show (excludes_clist);
   
   area_contents_s->excludes_hbox = gtk_hbox_new (FALSE, 1);
   gtk_widget_show (area_contents_s->excludes_hbox);
   label = gtk_label_new ("Exclude:");
   gtk_box_pack_start (GTK_BOX (area_contents_s->excludes_hbox),
		       label, FALSE, FALSE, 1);
   gtk_widget_show (label);
   
   excludes_entry = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (excludes_entry), "changed",
		       GTK_SIGNAL_FUNC (change_exclude), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->excludes_hbox),
		       excludes_entry, TRUE, TRUE, 1);
   gtk_widget_show (excludes_entry);
   
   area_contents_s->excludes_new = gtk_button_new_with_label ("New");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->excludes_new),
		       "clicked", GTK_SIGNAL_FUNC (add_exclude), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->excludes_hbox),
		       area_contents_s->excludes_new, FALSE, FALSE, 1);
   gtk_widget_show (area_contents_s->excludes_new);
   
   area_contents_s->excludes_delete = gtk_button_new_with_label ("Delete");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->excludes_delete),
		       "clicked", GTK_SIGNAL_FUNC (remove_exclude), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->excludes_hbox),
		       area_contents_s->excludes_delete, FALSE, FALSE, 1);
   gtk_widget_show (area_contents_s->excludes_delete);
   
   gtk_box_pack_start (GTK_BOX (area_contents_s->excludes_vbox),
		       area_contents_s->excludes_hbox, FALSE, FALSE, 5);

   /* Name mappings */
   
/*   label = gtk_label_new ("Name Mappings");
   			  gtk_widget_show (label);
   area_contents_s->name_map_vbox = gtk_vbox_new (FALSE, 2);
   gtk_notebook_append_page (GTK_NOTEBOOK (area_contents_s->advanced_notebook),
			     GTK_WIDGET (area_contents_s->name_map_vbox),
			     GTK_WIDGET (label));
   gtk_widget_show (area_contents_s->name_map_vbox);
   
   name_map_clist = gtk_clist_new_with_titles (2, map_title);
   gtk_clist_set_selection_mode (GTK_CLIST (name_map_clist), GTK_SELECTION_SINGLE);
   gtk_clist_set_column_width (GTK_CLIST (name_map_clist), 0, 100);
   populate_name_map ();
   gtk_clist_columns_autosize (GTK_CLIST (excludes_clist));
   gtk_signal_connect (GTK_OBJECT (name_map_clist), "select_row",
		       GTK_SIGNAL_FUNC (select_name_map), NULL);

   area_contents_s->name_map_scroller = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (area_contents_s->name_map_scroller),
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
   gtk_container_add (GTK_CONTAINER (area_contents_s->name_map_scroller),
		      name_map_clist);
   gtk_widget_show (area_contents_s->name_map_scroller);

   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_vbox), area_contents_s->name_map_scroller,
		       TRUE, TRUE, 5);
   gtk_widget_show (name_map_clist);
   
   area_contents_s->name_map_hbox = gtk_hbox_new (FALSE, 1);
   gtk_widget_show (area_contents_s->name_map_hbox);
   label = gtk_label_new ("Local name:");
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_hbox),
		       label, FALSE, FALSE, 1);
   gtk_widget_show (label);
   
   name_map_local_entry = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (name_map_local_entry), "changed",
		       GTK_SIGNAL_FUNC (change_local_map), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_hbox),
		       name_map_local_entry, TRUE, TRUE, 1);
   gtk_widget_show (name_map_local_entry);
   
   area_contents_s->name_map_new = gtk_button_new_with_label ("New");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->name_map_new),
		       "clicked", GTK_SIGNAL_FUNC (add_name_map), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_hbox),
		       area_contents_s->name_map_new, FALSE, FALSE, 1);
   gtk_widget_show (area_contents_s->name_map_new);
   
   area_contents_s->name_map_delete = gtk_button_new_with_label ("Delete");
   gtk_signal_connect (GTK_OBJECT (area_contents_s->name_map_delete),
		       "clicked", GTK_SIGNAL_FUNC (remove_name_map), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_hbox),
		       area_contents_s->name_map_delete, FALSE, FALSE, 1);
   gtk_widget_show (area_contents_s->name_map_delete);
   
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_vbox),
		       area_contents_s->name_map_hbox, FALSE, FALSE, 2);
*/
   /* Remote widget */   
/*   area_contents_s->name_map_hbox = gtk_hbox_new (FALSE, 1);
   gtk_widget_show (area_contents_s->name_map_hbox);
   label = gtk_label_new ("Remote name:");
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_hbox),
		       label, FALSE, FALSE, 1);
   gtk_widget_show (label);
   
   name_map_remote_entry = gtk_entry_new ();
   gtk_signal_connect (GTK_OBJECT (name_map_remote_entry), "changed",
		       GTK_SIGNAL_FUNC (change_remote_map), NULL);
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_hbox),
		       name_map_remote_entry, TRUE, TRUE, 1);
   gtk_widget_show (name_map_remote_entry);
      
   gtk_box_pack_start (GTK_BOX (area_contents_s->name_map_vbox),
		       area_contents_s->name_map_hbox, FALSE, FALSE, 2);
*/   
   /* Put the 'advanced' notebook into the frame. */
   gtk_container_add (GTK_CONTAINER (area_contents_s->advanced_frame),
		      area_contents_s->advanced_notebook);   

   
   /* Info summary */

   area_contents_s->info_frame = gtk_frame_new ("Statistics");
   gtk_widget_show (area_contents_s->info_frame);
   area_contents_s->evbox = gtk_event_box_new ();
   gtk_widget_show (area_contents_s->evbox);
   
   files_on_site = selected_site->numnew + selected_site->numchanged + selected_site->numdeleted + selected_site->nummoved + selected_site->numunchanged;
   
   info = malloc (BUFSIZ);
   if ( ! selected_site->is_different) {
      sprintf(info, "The local site contains %d files, none of which have changed since the last update.",
	      files_on_site);
   } else {
      sprintf(info, "The local site has changed since the last update:\n%d files have been added, %d files have changed, %d files have been deleted, %d files have been moved, %d remain unchanged.\nThere are currently %d files on the local site.",
	      selected_site->numnew,
	      selected_site->numchanged,
	      selected_site->numdeleted,
	      selected_site->nummoved,
	      selected_site->numunchanged,
	      files_on_site);
   }
   label = gtk_label_new (info);
   free (info);
   gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
   
   /* TODO: Add a config option for more stats, like how much space the new
    * files take up, how many excludes, etc. */
   
   gtk_container_add (GTK_CONTAINER (area_contents_s->evbox), label);
   gtk_container_add (GTK_CONTAINER (area_contents_s->info_frame), area_contents_s->evbox);
   gtk_widget_show (label);
   
   /* Left side of site widgets */
   subtable = gtk_vbox_new (FALSE, 3);
   gtk_widget_show (subtable);
   gtk_box_pack_start (GTK_BOX (subtable), area_contents_s->site_details_frame, TRUE, TRUE, 2);
   gtk_box_pack_start (GTK_BOX (subtable), area_contents_s->flags_frame, TRUE, TRUE, 2);
   gtk_box_pack_start (GTK_BOX (subtable), area_contents_s->info_frame, TRUE, TRUE, 2);
   
   gtk_box_pack_start (GTK_BOX (table), subtable, TRUE, TRUE, 1);

   /* Right side of site widgets */
   subtable = gtk_vbox_new (FALSE, 3);
   gtk_widget_show (subtable);
   gtk_box_pack_start (GTK_BOX (subtable), area_contents_s->dir_frame, TRUE, TRUE, 2);
   gtk_box_pack_start (GTK_BOX (subtable), area_contents_s->file_attrib_frame, TRUE, TRUE, 2);
   gtk_box_pack_start (GTK_BOX (subtable), area_contents_s->advanced_frame, TRUE, TRUE, 2);
   
   gtk_box_pack_start (GTK_BOX (table), subtable, TRUE, TRUE, 1);
   
   gtk_widget_show (table);

   area_contents_s->container = area_contents_s->frame;
/*   gtk_container_set_border_width (GTK_CONTAINER (area_contents_s->container), 20);*/
   
   gtk_widget_set_sensitive (area_contents_s->local_dir, FALSE);
/*   gtk_widget_set_sensitive (area_contents_s->remote_dir, FALSE);*/
   gtk_widget_show (area_contents_s->frame);   
   if (should_save_at_end)
     rcfile_saved = true;
   return area_contents_s->frame;
}

