/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */

#include "resynch.h"
#include "gcommon.h"

GtkWidget *fetch_list_window, *fetch_list_bar, *fetch_message;
GtkWidget *close_fetch_button, *begin_fetch_button;
GtkWidget *anim;

extern struct site_t *selected_site;

new_anim_frame (GnomeAnimator *anima, GnomePixmap *image) {
   gnome_animator_append_frame_from_gnome_pixmap (GNOME_ANIMATOR (anima),
						  GNOME_PIXMAP (image),
						  0, 0, 500);
}

int fetch_site_list_please (GtkWidget *update_button, gpointer data) {
  /*   
   GtkWidget *vbox, *table, *hbox, *tmp_pic;
   GtkWidget *label, *button;
   extern GtkWidget *connection_label;
   
#include "fetch1.xpm"
#include "fetch2.xpm"
#include "fetch3.xpm"
#include "fetch4.xpm"
#include "fetch5.xpm"
#include "fetch6.xpm"
   
   
   if (selected_site == NULL) {
      fe_status ("You must select a site if you want to fetch a remote list!");
      return 0;
   }

   fetch_list_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_widget_set_usize (GTK_WIDGET (fetch_list_window), 390, -1);
   gtk_window_set_title (GTK_WINDOW (fetch_list_window), "Transfer Progress");
   gtk_container_set_border_width (GTK_CONTAINER (fetch_list_window), 5);
   gtk_window_set_modal (GTK_WINDOW (fetch_list_window), true);
   
   vbox = gtk_vbox_new (FALSE, 2);
   
   anim = gnome_animator_new_with_size(350, 70);
   gnome_animator_set_loop_type (GNOME_ANIMATOR (anim),
				 GNOME_ANIMATOR_LOOP_RESTART);
   tmp_pic = gnome_pixmap_new_from_xpm_d_at_size (fetch1_xpm,
						  350, 70);
   new_anim_frame (GNOME_ANIMATOR (anim), GNOME_PIXMAP (tmp_pic));
   tmp_pic = gnome_pixmap_new_from_xpm_d_at_size (fetch2_xpm,
						  350, 70);
   new_anim_frame (GNOME_ANIMATOR (anim), GNOME_PIXMAP (tmp_pic));
   tmp_pic = gnome_pixmap_new_from_xpm_d_at_size (fetch3_xpm,
						  350, 70);
   new_anim_frame (GNOME_ANIMATOR (anim), GNOME_PIXMAP (tmp_pic));
   tmp_pic = gnome_pixmap_new_from_xpm_d_at_size (fetch4_xpm,
						  350, 70);
   new_anim_frame (GNOME_ANIMATOR (anim), GNOME_PIXMAP (tmp_pic));
   tmp_pic = gnome_pixmap_new_from_xpm_d_at_size (fetch5_xpm,
						  350, 70);
   new_anim_frame (GNOME_ANIMATOR (anim), GNOME_PIXMAP (tmp_pic));
  
   gtk_box_pack_start (GTK_BOX (vbox), anim, TRUE, TRUE, 2);
   
   hbox = gtk_hbox_new (FALSE, 2);
   label = gtk_label_new ("Fetch status: ");
   gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 2);
   fetch_message = gtk_label_new ("Awaiting user input.");
   gtk_widget_show (fetch_message);
   connection_label = fetch_message;
   gtk_box_pack_start (GTK_BOX (hbox), fetch_message, TRUE, TRUE, 2);
   
   gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 2);
 
   fetch_list_bar = gtk_progress_bar_new ();
   gtk_progress_set_activity_mode (GTK_PROGRESS (fetch_list_bar), 1);
   
   gtk_box_pack_start (GTK_BOX (vbox), fetch_list_bar, FALSE, FALSE, 2);
*/   
   /* buttons */
   /*   hbox = gtk_hbox_new (FALSE, 2);
   begin_fetch_button = gtk_button_new_with_label ("Begin");
   gtk_signal_connect (GTK_OBJECT (begin_fetch_button), "clicked", 
		       GTK_SIGNAL_FUNC (start_fetch_list), NULL);
   gtk_box_pack_end (GTK_BOX (hbox), begin_fetch_button, FALSE, FALSE, 2);

   close_fetch_button = gtk_button_new_with_label ("Close");
   gtk_signal_connect (GTK_OBJECT (close_fetch_button), "clicked",
		       GTK_SIGNAL_FUNC (close_fetch_window), NULL);
   gtk_box_pack_end (GTK_BOX (hbox), close_fetch_button, FALSE, FALSE, 2);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 2);
   
   gtk_container_add (GTK_CONTAINER (fetch_list_window), vbox);
   gtk_widget_show_all (fetch_list_window);*/
   return 1;
}

void close_fetch_window (void) {
  extern GtkWidget *connection_label;

  gtk_window_set_modal (GTK_WINDOW (fetch_list_window), FALSE);
  gtk_widget_destroy (fetch_list_window);
  connection_label = NULL;
}
   
int start_fetch_list (void) {
   pthread_t fetch_thread_id = 0;
   
   if ( pthread_create (&fetch_thread_id, NULL, actual_fetch_list, 
			NULL) != 0) {
      fe_status ("There was a problem creating the thread to fetch site info.\n");
      return 0;
   }
   if (fetch_thread_id != 0)
     pthread_join (fetch_thread_id, NULL);
   gnome_animator_stop (GNOME_ANIMATOR (anim));
   gtk_window_set_modal (GTK_WINDOW (fetch_list_window), FALSE);
   return 1;
}

void *actual_fetch_list (void *nothing) {
   int ret;
   
   pthread_detach (pthread_self());
   gnome_animator_start (GNOME_ANIMATOR (anim));
   gtk_widget_set_sensitive (begin_fetch_button, false);
   gtk_widget_set_sensitive (close_fetch_button, false);

   ret = verifysite_gnome (selected_site);
	if (ret)
	  return NULL;
   ret = site_fetch (selected_site);

   switch (ret) {
   case SITE_OK:
     gtk_label_set (GTK_LABEL (fetch_message), "Remote site's file list successfully fetched.");
     site_writefiles (selected_site);
     break;
   case SITE_UNIMPL:
     gtk_label_set (GTK_LABEL (fetch_message), "Fetch mode not implemented for this protocol.");
     break;
   case SITE_AUTH:
     gtk_label_set (GTK_LABEL (fetch_message), "Could not authenticate you with the remote server.");
     break;
   case SITE_LOOKUP:
     gtk_label_set (GTK_LABEL (fetch_message), "Host name lookup failed.");
     break;
   case SITE_CONNECT:
      gtk_label_set (GTK_LABEL (fetch_message), "Could not connect to remote site.");
     break;
   case SITE_FAILED:
      gtk_label_set (GTK_LABEL (fetch_message), "The fetch failed. No reason given.");
     break;
   default:
     gtk_label_set (GTK_LABEL (fetch_message), "This should never appear. Please contact the maintainer.");
   }
   gtk_widget_set_sensitive (close_fetch_button, TRUE);
   return NULL;
}

void fe_fetch_found( const struct site_file_t *file ) {
   gchar *info2;
   gchar *info = "Found information for ";
   
   info2 = file->rel_local;
   /*   info2 = (gchar *) malloc (BUFSIZ);
	strncpy (info2, strcat (info, file->rel_local),  (size_t) (strlen (info) + strlen (file->rel_local)) ) ; */
      
   gtk_label_set (GTK_LABEL (fetch_message), info2);
   gtk_progress_bar_update (GTK_PROGRESS_BAR (fetch_list_bar), 0.1);
   while (gtk_events_pending() > 0)
     gtk_main_iteration();
   return;
}

