/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */
#include "misc.h"
#include "gcommon.h"

extern struct site_t *all_sites;
extern GtkWidget *status_bar;

GtkWidget *excludes_clist, *excludes_entry;
extern struct site_t *selected_site;

int exclude_row = -1;

void populate_excludes (void) {
   struct exclude_t *current;
   gchar *to_add[1];
   
   for (current=selected_site->excludes; current!=NULL; current=current->next) {
      to_add[0] = current->pattern;
      exclude_row = gtk_clist_append (GTK_CLIST (excludes_clist), to_add);
      gtk_clist_set_row_data (GTK_CLIST (excludes_clist), exclude_row,
			      (gpointer) current);
   }
}

void select_exclude (GtkWidget *list, gint row) {
   gchar *to_change;
   exclude_row = row;

   gtk_clist_get_text (GTK_CLIST (excludes_clist), row, 0, &to_change);
   gtk_entry_set_text (GTK_ENTRY (excludes_entry), to_change);
	gtk_entry_select_region (GTK_ENTRY (excludes_entry), 0, -1);
}

void change_exclude (GtkWidget *entry, gpointer data) {
   gchar *text;
   extern bool rcfile_saved;
   struct exclude_t *selected_exclude_struct;

   if (exclude_row < 0)
     return;
   text = gtk_entry_get_text (GTK_ENTRY (entry));
   gtk_clist_set_text (GTK_CLIST (excludes_clist), exclude_row, 0, text);
   if (!text)
     return;
   
   selected_exclude_struct = (struct exclude_t *) gtk_clist_get_row_data (GTK_CLIST (excludes_clist),
									  exclude_row);
   selected_exclude_struct->pattern = (char *) malloc (strlen(text)+2);
   selected_exclude_struct->pattern = strdup(text);
   if (*text == '/') {
      selected_exclude_struct->haspath = true;
   } else {
      selected_exclude_struct->haspath = false;
   }
   gtk_widget_grab_focus (excludes_entry);
   rcfile_saved = false;
}

void add_exclude (GtkWidget *button, gpointer data) {
   int added_row;
   gchar *to_add[1];
   struct exclude_t *current, *new_one;
   
   to_add[0] = (char *) malloc (70);
   strcpy (to_add[0], "New exclude expression");
   added_row = gtk_clist_append (GTK_CLIST (excludes_clist), to_add);

   current=selected_site->excludes;

   if (current != NULL) {
     while (current->next != NULL) {
       current=current->next;
     }
   }

   new_one = malloc (sizeof(struct exclude_t));
   new_one->haspath = false;
   new_one->pattern = malloc (70);
   new_one->pattern = strdup(to_add[0]);
   new_one->next = NULL;
   if (!current) {
     new_one->prev = NULL;
     selected_site->excludes = new_one;
   } else {
     new_one->prev = current;
     current->next = new_one;
   }

   gtk_clist_set_row_data (GTK_CLIST (excludes_clist), added_row,
			   (gpointer) new_one);
   
   gtk_clist_select_row (GTK_CLIST (excludes_clist), added_row, 0);
}

void remove_exclude (GtkWidget *button, gpointer data) {
   int i, j;
   struct exclude_t *current, *tmp;
   
   if (exclude_row < 0)
     return;
   current = gtk_clist_get_row_data (GTK_CLIST (excludes_clist), exclude_row);
   tmp = current;
   
   if (current->prev) {
      current->prev->next = current->next;
      if (current->next) {
	current->next->prev = current->next->prev->prev;
      }
   } else { 
      selected_site->excludes = selected_site->excludes->next;
   }
   
   gtk_clist_remove (GTK_CLIST (excludes_clist), exclude_row);
   exclude_row = -1;
   gtk_entry_set_text (GTK_ENTRY (excludes_entry), "");
}
