#ifndef __ALERT_H__
#define __ALERT_H__

#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define MSG_LEN 1024

#define ALERT(obj)          GTK_CHECK_CAST (obj, alert_get_type (), Alert)
#define ALERT_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, alert_get_type (), AlertClass)
#define IS_ALERT(obj)       GTK_CHECK_TYPE (obj, alert_get_type ())


typedef struct _Alert       Alert;
typedef struct _AlertClass  AlertClass;

struct _Alert
{
  GtkWindow window;
  
  char msg[MSG_LEN];
};

struct _AlertClass
{
  GtkWindowClass parent_class;

  void (* alert) (Alert *a);
};

guint          alert_get_type        (void);
GtkWidget*     alert_new             (char *msg);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __ALERT_H__ */
