/* Bluefish HTML Editor
 * wizards.c - much magic is contained within
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 * Copyright (C) 1999 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>

#include <locale.h>
#include <libintl.h>
#define _(STRING) gettext(STRING)

#include "cap.h"
#include "config.h"
#include "widgets.h"
#include "wizards.h"
#include "init.h"
#include "stringlist.h"
#include "bluefish.h"
#include "html.h"
#include "interface.h"
#include "debug.h"

/* external functions I want to use */
extern void flush_queue (void);
extern void destroy_dialog (void);
/* extern void insert_text (gchar *, gchar *); declared in interface.h */
extern void create_dialog (int, int, gchar *);
extern gchar *converttohex (gchar *);

/* local stuff */
void table_wizard_ok (GtkWidget *, gpointer);
void frame_wizard_ok (GtkWidget *, gpointer);

extern gchar *stuff;
gint used_mem, rows, columns, frames, i, z;

void quickstart(GtkWidget * widget, gpointer data) {
   dtd(widget, GINT_TO_POINTER(1));
}

/* Table Wizard */

void
tablewizard (void)
{
  DEBUG_MSG ("table_wizard, started\n");
  create_dialog (300, 100, _("Table Wizard"));
  dialogtable = gtk_table_new (2, 10, 1);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new (_("Number of rows"));
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1, 200.0, 1.0,
					      5.0, 1.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 7, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 7, 10, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new (_("Number of Columns per row"));
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1, 200.0, 1.0,
					      5.0, 1.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 7, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 7, 10, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  create_buttons (GTK_SIGNAL_FUNC(table_wizard_ok), NULL);
  DEBUG_MSG ("table_wizard, finished\n");
}

void
table_wizard_ok (GtkWidget * widget, gpointer data)
{
  gchar *statusbar;

  DEBUG_MSG ("table_wizard_ok, started\n");
  used_mem = 16;
  stuff = g_malloc (used_mem);

  /* gtk forces the value of one if nothing is entered */
  rows = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
  columns = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
  DEBUG_MSG ("table_wizard_ok, rows=%d, columns=%d\n", rows, columns);
  strcpy (stuff, "<table>\n");

  for (i = 0; i < rows; i++)
    {
      strncat (stuff, "\t<tr>\n", used_mem - 1);
      used_mem = used_mem + 16;
      stuff = g_realloc (stuff, used_mem);

      /* this can definitely be optimized */
      for (z = 0; z < columns; z++)
	{
	  strncat (stuff, "\t\t<td></td>\n", used_mem - 1);
	  used_mem = used_mem + 16;
	  stuff = g_realloc (stuff, used_mem);
	}

      strncat (stuff, "\t</tr>\n", used_mem - 1);
      DEBUG_MSG ("table_wizard_ok, i=%d, z=%d\n", i,z);
      statusbar = g_strdup_printf ("Generating row number %d of %d", i + 1, rows);
      statusbar_message (statusbar, 500);
      g_free (statusbar);
    }

  DEBUG_MSG ("table_wizard_ok, stuff=%s\n", stuff);
  insert_text (cap(stuff), cap ("</TABLE>"));
  destroy_dialog ();
}

/* Frame Wizard - yes I know that this isn't too useful now */
/* I'll fix it eventually */

void
framewizard (void)
{
  GSList *group;

  create_dialog (300, 100, _("Frame Wizard"));
  dialogtable = gtk_table_new (2, 10, 1);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new (_("Number of Frames"));
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 2, 2, 10.0, 1.0,
					      5.0, 1.0);
  spin1 = gtk_spin_button_new (adj, 2, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 7, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 7, 10, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  radio1 = gtk_radio_button_new_with_label (NULL, _("Horizontal"));
  group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio1));
  radio2 = gtk_radio_button_new_with_label (group, _("Vertical"));
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio1), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), radio1, 1, 5, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), radio2, 5, 9, 1, 2);
  gtk_widget_show (radio1);
  gtk_widget_show (radio2);

  create_buttons (GTK_SIGNAL_FUNC(frame_wizard_ok), NULL);
}

/*
 * TODO: move this function in separate file
 * 
 * Function: bf_strndup
 * Arguments:
 *      str - pointer to string
 *      number_of - number copies of string
 * Return value:
 *      pointer to new allocated string
 * Description:
 *      calculate, allocate buffer and copies number_of times str to new buffer
 */
gchar *
bf_strndup (const gchar * str, gint number_of)
{
  gchar *retstr;
  gint len = strlen (str) * number_of;
  retstr = g_malloc (len + 1);
  retstr[0] = '\0';
  while (number_of)
    {
      strncat (retstr, str, len);
      number_of--;
    };
  return retstr;
};

/*
 * Function: frame_wizard_ok
 * Arguments:
 *      widget  - pointer to calling widget
 *      data    - data for callback function
 * Return value:
 *      void
 * Description:
 *      Make template and isert into current text buffer
 * ChangeLog:
 *      simplify function ( i hope 8-) )
 */
void
frame_wizard_ok (GtkWidget * widget, gpointer data)
{
  gint active, frames;
  gchar *stuff, *tmp = NULL, *tmp2=NULL;

  active = GTK_TOGGLE_BUTTON (radio1)->active;
  frames = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
  tmp = bf_strndup ("\t<frame>\n", frames);

  tmp2 = bf_strndup (", *", frames -1);
  if (active) {
    stuff = g_strdup_printf ("<frameset cols=\"*%s\">\n%s", tmp2, tmp);
  } else {
    stuff = g_strdup_printf ("<frameset rows=\"*%s\">\n%s", tmp2, tmp);
  }

  g_free (tmp);

  g_strup (stuff);
  insert_text (stuff, cap("</FRAMESET>"));

  g_free (stuff);
  destroy_dialog ();
}
