/* Bluefish HTML Editor
 * interface.c - this file contains the UI code and some init code
 *
 * Copyright (C) 1998-1999 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Changes by Antti-Juhani Kaijanaho <gaia@iki.fi> on 1999-10-20  */


#include <unistd.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>

#include <locale.h>
#include <libintl.h>
#define _(STRING) gettext(STRING)

#include "config.h"

#if HAVE_GTKEDITOR
#include <gtkeditor/gtkeditor.h>
#endif

#include "bluefish.h"
#include "interface.h"
#include "init.h"
#include "undo.h"
#include "snr.h"
#include "toolbars.h"
#include "callbacks.h"
#include "rpopup.h"
#include "debug.h"

#include "pixmaps/bluefish_icon.xpm"
#ifndef NOSPLASH
#include "pixmaps/bluefish.xpm"
#endif

GtkWidget *cust_handle_box, *handle_box, *html_handle_box;

/* local "global" variables */
gint context_id = 0;

/* ---------------------
 * local declarations
 * --------------------- */
gint statusbar_remove (gpointer message_id);

/* 
 * start of the functions
 * 
 */

void
statusbar_message (gpointer message, gint time)
{

  gint count;

  count = gtk_statusbar_push (GTK_STATUSBAR (main_v->statusbar), context_id, (gchar *) message);
  gtk_timeout_add (time, statusbar_remove, GINT_TO_POINTER (count));
  flush_queue ();
}

gint
statusbar_remove (gpointer message_id)
{
  gtk_statusbar_remove (GTK_STATUSBAR (main_v->statusbar), context_id, GPOINTER_TO_INT (message_id));
  return 0;
}



/* void add_to_statusbar(gchar * text)
   {
   gtk_statusbar_pop(GTK_STATUSBAR(main_v->statusbar), gtk_statusbar_get_context_id
   (GTK_STATUSBAR(main_v->statusbar), ""));
   gtk_statusbar_push(GTK_STATUSBAR(main_v->statusbar),
   gtk_statusbar_get_context_id(GTK_STATUSBAR
   (main_v->statusbar), ""), text);
   flush_queue();
   } */

GtkWidget *apply_font_style(GtkWidget *this_widget, gchar *fontstring) {
  GdkFont *tmpfont;
  GtkStyle *style;
  
  style = gtk_style_new ();
  tmpfont = style->font;

  style->font = gdk_fontset_load (fontstring);
  if (style->font)
    {
      gdk_font_unref (tmpfont);
      gtk_widget_push_style (style);
      gtk_widget_set_style (GTK_WIDGET (this_widget), style);
      gtk_widget_pop_style ();
      DEBUG_MSG ("apply_font_style, style applied\n");
    }
  else
    {
      DEBUG_MSG ("apply_font_style, font = NULL, fontstring=%s\n", fontstring);
      style->font = tmpfont;
      gtk_style_unref (style);
    }
	 return this_widget;
}

void
notebook_changed (void)
{
  gint cur;

  /* This one is called when you click on the notebook
     it _should_ be called also when you use the keys to change the page */

  cur = 1 + (gint) gtk_notebook_current_page (GTK_NOTEBOOK (main_v->notebook));
  DEBUG_MSG ("notebook_changed, cur=%d\n", cur);
  main_v->current_document = NULL;
  main_v->current_document = g_list_nth_data (main_v->documentlist, cur);
  if (main_v->current_document == NULL) {
#ifdef DEBUG
    DEBUG_MSG ("notebook_changed, main_v->current_document == NULL\n");
#endif  
  }else {
    gtk_widget_grab_focus(GTK_WIDGET(main_v->current_document->textbox));
  }
}


    /*
     * this used to be the callback, but I'll put this in doc_insert_text_cb
     * and doc_delete_text_cb 
     */
/* void textbox_key_press(void)
   {
   current_document->modified = 1;
   }
 */

/* this function destroys the current_document */
void
destroy_current_document (void)
{
  if (main_v->current_document != NULL)
    {
      DEBUG_MSG ("destroy_current_document, started, notebook=%p\n", main_v->notebook);
      /* this introduces a memleak, but at least the gtkeditor widget
         doesn't crash anymore
         gtk_widget_ref(GTK_WIDGET(current_document->textbox)); */
      DEBUG_MSG ("destroy_current_document, textbox=%p\n", main_v->current_document->textbox);
      gtk_notebook_remove_page (GTK_NOTEBOOK (main_v->notebook),
	       gtk_notebook_current_page (GTK_NOTEBOOK (main_v->notebook)));
      DEBUG_MSG ("destroy_current_document, g_list_length(documentlist)=%d\n",
		 g_list_length (main_v->documentlist));
      if (g_list_length (main_v->documentlist) > 1)
	{
	  g_list_remove (main_v->documentlist, main_v->current_document);
	}
      else
	{
	  g_list_remove (main_v->documentlist, main_v->current_document);
	  DEBUG_MSG ("destroy_current_document, removed from documentlist\n");
	  g_list_free (main_v->documentlist);
	  DEBUG_MSG ("destroy_current_document, freed documentlist\n");
	  main_v->documentlist = NULL;
	  DEBUG_MSG ("destroy_current_document, documentlist = NULL\n");
	}
      DEBUG_MSG ("destroy_current_document, g_list_length(documentlist)=%d\n",
		 g_list_length (main_v->documentlist));
      if (main_v->current_document->filename != NULL)
	{
	  g_free (main_v->current_document->filename);
	}
      g_free (main_v->current_document);
      gtk_notebook_set_page (GTK_NOTEBOOK (main_v->notebook), ((gint) g_list_length
					       (main_v->documentlist) - 1));
      notebook_changed ();
    }
  else
    {
      DEBUG_MSG
	("destroy_current_document, cannot close a NULL current_document\n");
    }
}

void replace_text(const gchar *newstring, gint pos, gint len) {
	DEBUG_MSG("replace_text, started, pos=%d, len=%d, newstring=%s, strlen(newstring)=%d\n", pos, len, newstring, strlen(newstring));
	gtk_editable_delete_text(GTK_EDITABLE(main_v->current_document->textbox), pos, len);
	DEBUG_MSG("replace_text, text deleted\n");
	gtk_editable_insert_text(GTK_EDITABLE(main_v->current_document->textbox), newstring, strlen(newstring), &pos);	
}

/* Why const?  Because you may not modify the text! */
void
insert_text (const gchar * before, const gchar * after)
{
  guint startp, endp, currentp, tmp, selection;

/* freeze the textbox, this is better when inserting large blocks */
#if HAVE_GTKEDITOR
  gtk_sctext_freeze (GTK_SCTEXT (main_v->current_document->textbox));
#else
  gtk_text_freeze (GTK_TEXT (main_v->current_document->textbox));
#endif

#ifdef DEBUG
#if HAVE_GTKEDITOR
  DEBUG_MSG ("insert_text, get_point=%d\n", gtk_sctext_get_point (GTK_SCTEXT (main_v->current_document->textbox)));
  DEBUG_MSG ("insert_text, gap_position tmp=%d\n", GTK_SCTEXT (main_v->current_document->textbox)->gap_position);
  DEBUG_MSG ("insert_text, cursor_mark->index tmp=%d\n", GTK_SCTEXT (main_v->current_document->textbox)->cursor_mark.index);
  DEBUG_MSG ("insert_text, point->index tmp=%d\n", GTK_SCTEXT (main_v->current_document->textbox)->point.index);
  DEBUG_MSG ("insert_text, text_end tmp=%d\n", GTK_SCTEXT (main_v->current_document->textbox)->text_end);
#else
  DEBUG_MSG ("insert_text, get_point=%d\n", gtk_text_get_point (GTK_TEXT (main_v->current_document->textbox)));
  DEBUG_MSG ("insert_text, gap_position tmp=%d\n", GTK_TEXT (main_v->current_document->textbox)->gap_position);
  DEBUG_MSG ("insert_text, cursor_mark->index tmp=%d\n", GTK_TEXT (main_v->current_document->textbox)->cursor_mark.index);
  DEBUG_MSG ("insert_text, point->index tmp=%d\n", GTK_TEXT (main_v->current_document->textbox)->point.index);
  DEBUG_MSG ("insert_text, text_end tmp=%d\n", GTK_TEXT (main_v->current_document->textbox)->text_end);
  DEBUG_MSG ("insert_text, selection_start_pos=%d, selection_end_pos=%d\n", GTK_EDITABLE (main_v->current_document->textbox)->selection_start_pos, GTK_EDITABLE (main_v->current_document->textbox)->selection_end_pos);
#endif
#endif

/* find the current cursor position (not the same as the current insert 
   position you get with gtk_text_get_point()!) */
#if HAVE_GTKEDITOR
  /* this is really shitty, the cursor_mark.index is not working anymore
     so I try gap_position */
  currentp = GTK_SCTEXT (main_v->current_document->textbox)->cursor_mark.index;
#else
  currentp = GTK_TEXT (main_v->current_document->textbox)->cursor_mark.index;
#endif
  selection = GTK_EDITABLE (main_v->current_document->textbox)->has_selection;

/* find the current start and end of a selection */
  if (selection)
    {

      startp = GTK_EDITABLE (main_v->current_document->textbox)->selection_start_pos;
      endp = GTK_EDITABLE (main_v->current_document->textbox)->selection_end_pos;
      /* swap if start and endpoint are the wrong way around (somebody started selecting
         the end of the word and ended with the beginning) */
      if (endp < startp)
	{
	  tmp = endp;
	  endp = startp;
	  startp = tmp;
	}
    }
  else
    {
      /* if no selection at all, startp and endp can be equal to currentp */
      startp = currentp;
      endp = currentp;
    }

  DEBUG_MSG ("insert_text, A currentp = %d, startp=%d, endp=%d\n", currentp,
	     startp, endp);
/* set the point and insert the last bit */
#if HAVE_GTKEDITOR
  gtk_sctext_set_point (GTK_SCTEXT (main_v->current_document->textbox), endp);
  gtk_editable_set_position (GTK_EDITABLE (main_v->current_document->textbox), endp);
  DEBUG_MSG ("insert_text, point set with gtk_sctext, about to insert\n");
  gtk_sctext_insert (GTK_SCTEXT (main_v->current_document->textbox), NULL, NULL, NULL,
		     after, -1);
#else
  gtk_text_set_point (GTK_TEXT (main_v->current_document->textbox), endp);
  gtk_editable_set_position (GTK_EDITABLE (main_v->current_document->textbox), endp);
  gtk_text_insert (GTK_TEXT (main_v->current_document->textbox), NULL, NULL, NULL,
		   after, -1);
#endif
  undo_list_add (main_v->current_document, g_strdup (after), endp, endp +
		 strlen (after), UndoInsert);

/* set the point and insert the first bit */
#if HAVE_GTKEDITOR
  gtk_sctext_set_point (GTK_SCTEXT (main_v->current_document->textbox), startp);
  gtk_editable_set_position (GTK_EDITABLE (main_v->current_document->textbox), startp);
  gtk_sctext_insert (GTK_SCTEXT (main_v->current_document->textbox), NULL, NULL, NULL,
		     before, -1);
#else
  gtk_text_set_point (GTK_TEXT (main_v->current_document->textbox), startp);
  gtk_editable_set_position (GTK_EDITABLE (main_v->current_document->textbox), startp);
  gtk_text_insert (GTK_TEXT (main_v->current_document->textbox), NULL, NULL, NULL,
		   before, -1);
#endif

  undo_list_add (main_v->current_document, g_strdup (before), startp, startp +
		 strlen (before), UndoInsert);
  DEBUG_MSG ("insert_text, B currentp = %d, startp=%d, endp=%d\n", currentp,
	     startp, endp);
/* re-set the selection if there was one */
  if (selection)
    {
      DEBUG_MSG ("insert_text, there was a selection, so we'll re-set that\n");
      GTK_EDITABLE (main_v->current_document->textbox)->selection_start_pos = startp + strlen (before);
      GTK_EDITABLE (main_v->current_document->textbox)->selection_end_pos = endp + strlen (before);
    }
  else
    {
      DEBUG_MSG ("insert_text, no selection, about to set point current_pos=%d to %d\n", GTK_EDITABLE (main_v->current_document->textbox)->current_pos, currentp + strlen (before));
/* re-set the insert point if there was no selection */
#if HAVE_GTKEDITOR
      /* I'm not sure why it crashes here with a selection but it does */
      GTK_EDITABLE (main_v->current_document->textbox)->current_pos = currentp + strlen (before);
    }
  GTK_SCTEXT (main_v->current_document->textbox)->cursor_mark.index = currentp + strlen (before);
  gtk_sctext_set_point (GTK_SCTEXT (main_v->current_document->textbox), currentp + strlen (before));
  DEBUG_MSG ("insert_text, no selection, B, strlen(before)=%d, current_pos=%d\n", strlen (before), GTK_EDITABLE (main_v->current_document->textbox)->current_pos);
#else
      /* and this one crashes if 
		your inserted_text + current_position > previous_text_size
		gtk_editable_set_position (GTK_EDITABLE (main_v->current_document->textbox), (currentp + strlen (before)));*/

      /* so I replaced it with this one */
      GTK_TEXT (main_v->current_document->textbox)->cursor_mark.index = currentp + strlen (before);		
    }
  /* this one doesn't crash with a selection so it can stay here */
  DEBUG_MSG ("insert_text, set point to %d, text lenght=%d\n", (currentp + strlen (before)), gtk_text_get_length (GTK_TEXT (main_v->current_document->textbox)));
  gtk_text_set_point (GTK_TEXT (main_v->current_document->textbox),
		      (currentp + strlen (before)));
#endif
  /* grab focus so we can continue working */
  DEBUG_MSG ("insert_text, about to grab focus\n");
  gtk_widget_grab_focus (GTK_WIDGET (main_v->current_document->textbox));
  DEBUG_MSG ("insert_text, set modified=1\n");
  main_v->current_document->modified = 1;

/* thaw textbox, we're finished */
#if HAVE_GTKEDITOR
  gtk_sctext_thaw (GTK_SCTEXT (main_v->current_document->textbox));
  gtk_editor_hilite_screen (GTK_EDITOR (main_v->current_document->textbox));
#else
  DEBUG_MSG ("insert_text, the last thing to do->thaw\n");
  gtk_text_thaw (GTK_TEXT (main_v->current_document->textbox));
#endif
}


filestruct *
new_document (void)
{
  GtkWidget *tmptable, *tmpscrollbar;
  filestruct *document;
#if HAVE_GTKEDITOR
  GList *entries;
  GdkColor red, grey, blue, green, lblue, dblue, dgreen, dred;
#endif

  /* Here we create a new document, and add it to the GList */
  DEBUG_MSG ("new_document, started\n");
  if (main_v->current_document != NULL)
    {
      if ((main_v->current_document->modified == 0)
	  && (main_v->current_document->filename == NULL)
	  && (g_list_length (main_v->documentlist) == 2))
	{

	  DEBUG_MSG ("new_document, no new needed, the current one is empty\n");
	  return main_v->current_document;
	}
    }

  document = g_malloc0 (sizeof (filestruct));
  DEBUG_MSG ("new_document, malloced at %p\n", document);
  tmptable = gtk_table_new (1, 100, FALSE);	/* yes this 100 has a purpose */
  gtk_table_set_row_spacings (GTK_TABLE (tmptable), 0);
  gtk_table_set_col_spacings (GTK_TABLE (tmptable), 0);
#if HAVE_GTKEDITOR
  DEBUG_MSG ("new_document, GTKEDITOR part started\n");
  red.pixel = blue.pixel = grey.pixel = green.pixel = lblue.pixel = dred.pixel = dgreen.pixel = dblue.pixel = 0;
  red.red = blue.blue = green.green = lblue.blue = blue.blue = 55000;
  red.green = red.blue = blue.red = blue.green = green.red = green.blue = dred.green = dred.blue = dblue.red = dblue.green = dgreen.blue = dgreen.red = 0;
  grey.green = grey.blue = grey.red = lblue.red = lblue.green = dred.red = dgreen.green = dblue.blue = 35000;

  document->textbox = gtk_editor_new (NULL, NULL);
#ifdef DEBUGsyntax
  g_print ("syntax highlighting, check pattern =%d\n", gtk_editor_check_pattern ("<"));
#endif

  entries = gtk_editor_stentry_new ("formatting", "<font\\|<p\\|<br\\|<hr\\|<FONT\\|<P\\|<BR\\|<HR", ">", FALSE, NULL, &red, NULL,
				    gtk_editor_stentry_new ("list", "<ul\\|<ol\\|<UL\\|<OL", ">", FALSE, NULL, &dgreen, NULL,
							    gtk_editor_stentry_new ("table", "<table\\|<tr\\|<td\\|<TABLE\\|<TR\\|<TD", ">", FALSE, NULL, &lblue, NULL,
										    gtk_editor_stentry_new ("head", "<body\\|<meta\\|<BODY\\|<META\\|<!DOCTYPE", ">", FALSE, NULL, &green, NULL,
													    gtk_editor_stentry_new ("imganchor", "<a\\|<img\\|<embed\\|<frame\\|<area\\|<A\\|<IMG\\|<EMBED\\|<FRAME\\|<AREA", ">", FALSE, NULL, &blue, NULL,
  gtk_editor_stentry_new ("forms", "<imput", ">", FALSE, NULL, &dblue, NULL,
			  gtk_editor_stentry_new ("comments", "<!--", "-->", FALSE, NULL, &grey, NULL,
						  NULL)))))));

  gtk_editor_install_stable (GTK_EDITOR (document->textbox), entries);
  gtk_editor_free_pentries (entries);


  entries = gtk_editor_pentry_new ("formatting", "<pre>\\|<\\/pre>\\|<sup>\\|<\\/sup>\\|<sub>\\|<\\/sub>\\|<strong>\\|<\\/strong>\\|<em>\\|<\\/em>\\|<b>\\|<\\/b>\\|<i>\\|<\\/i>\\|<u>\\|<\\/u>\\|<s>\\|<\\/s>\\|<\\/font>\\|<PRE>\\|<\\/PRE>\\|<SUP>\\|<\\/SUP>\\|<SUB>\\|<\\/SUB>\\|<STRONG>\\|<\\/STRONG>\\|<EM>\\|<\\/EM>\\|<B>\\|<\\/B>\\|<I>\\|<\\/I>\\|<U>\\|<\\/U>\\|<S>\\|<\\/S>\\|<\\/FONT>\\|<center>\\|<\\/center>\\|<CENTER>\\|<\\/CENTER>\\|<\\/p>\\|<\\/P>", NULL, &red, NULL,
				   gtk_editor_pentry_new ("styles", "<h1>\\|<\\/h1>\\|<h2>\\|<\\/h2>\\|<h3>\\|<\\/h3>\\|<h4>\\|<\\/h4>\\|<h5>\\|<\\/h5>\\|<h6>\\|<\\/h6>\\|<H1>\\|<\\/H1>\\|<H2>\\|<\\/H2>\\|<H3>\\|<\\/H3>\\|<H4>\\|<\\/H4>\\|<H5>\\|<\\/H5>\\|<H6>\\|<\\/H6>", NULL, &dred, NULL,
							  gtk_editor_pentry_new ("list", "<\\/ul>\\|<\\/ol>\\|<li>\\|<dl>\\|<\\/dl>\\|<dt>\\|<dd>\\|<\\/UL>\\|<\\/OL>\\|<LI>\\|<DL>\\|<\\/DL>\\|<DT>\\|<DD>\\|<\\/LI>\\|<\\/li>", NULL, &dgreen, NULL,
										 gtk_editor_pentry_new ("table", "<\\/table>\\|<\\/tr>\\|<th>\\|<\\/th>\\|<\\/td>\\|<caption>\\|<\\/caption>\\|<\\/TABLE>\\|<\\/TR>\\|<TH>\\|<\\/TH>\\|<\\/TD>\\|<CAPTION>\\|<\\/CAPTION>", NULL, &lblue, NULL,
													gtk_editor_pentry_new ("head", "<html>\\|<\\/html>\\|<\\/body>\\|<head>\\|<\\/head>\\|<title>\\|<\\/title>\\|<\\/meta>\\|<HTML>\\|<\\/HTML>\\|<\\/BODY>\\|<HEAD>\\|<\\/HEAD>\\|<TITLE>\\|<\\/TITLE>\\|<\\/META>", NULL, &green, NULL,
															       gtk_editor_pentry_new ("imganchor", "<\\/a>\\|<frameset>\\|<\\/frameset>\\|<noframes>\\|<\\/noframes>\\|<map>\\|<\\/map>\\|<\\/A>\\|<FRAMESET>\\|<\\/FRAMESET>\\|<NOFRAMES>\\|<\\/NOFRAMES>\\|<MAP>\\|<\\/MAP>", NULL, &blue, NULL,
																		      gtk_editor_pentry_new ("forms", "<form>\\|<\\/form>\\|<FORM>\\|<\\/FORM>", NULL, &dblue, NULL,
								NULL)))))));

  gtk_editor_install_patterns (GTK_EDITOR (document->textbox), entries);
  gtk_editor_free_pentries (entries);

  gtk_sctext_set_editable (GTK_SCTEXT (document->textbox), TRUE);
  gtk_sctext_set_word_wrap (GTK_SCTEXT (document->textbox), FALSE);
/*   gtk_sctext_insert(GTK_SCTEXT (document->textbox), gdk_font_load(cfg_editor_font), NULL, NULL, "\n", 1);
   gtk_sctext_backward_delete(GTK_SCTEXT (document->textbox), 1); */

#else
  document->textbox = gtk_text_new (NULL, NULL);
  gtk_text_set_editable (GTK_TEXT (document->textbox), TRUE);
  gtk_text_set_word_wrap (GTK_TEXT (document->textbox), FALSE);

#endif

	gtk_signal_connect_object (GTK_OBJECT (document->textbox), "event", GTK_SIGNAL_FUNC (rpopup_eventh),
        NULL);

  apply_font_style(GTK_WIDGET (document->textbox),  cfg_editor_font);
  GTK_TEXT (document->textbox)->default_tab_width = cfg_editor_tabwidth;
  GTK_TEXT (document->textbox)->tab_stops = g_list_remove (GTK_TEXT
					     (document->textbox)->tab_stops,
							   GTK_TEXT
				      (document->textbox)->tab_stops->data);
  GTK_TEXT (document->textbox)->tab_stops = g_list_remove (GTK_TEXT
					     (document->textbox)->tab_stops,
							   GTK_TEXT
				      (document->textbox)->tab_stops->data);
  GTK_TEXT (document->textbox)->tab_stops = NULL;
  GTK_TEXT (document->textbox)->tab_stops = g_list_prepend (GTK_TEXT
					     (document->textbox)->tab_stops,
					      (void *) cfg_editor_tabwidth);
  GTK_TEXT (document->textbox)->tab_stops = g_list_prepend (GTK_TEXT
					     (document->textbox)->tab_stops,
					      (void *) cfg_editor_tabwidth);
  gtk_widget_show (document->textbox);
  tmpscrollbar = gtk_vscrollbar_new (GTK_TEXT (document->textbox)->vadj);
  gtk_table_attach_defaults (GTK_TABLE (tmptable), document->textbox, 0, 99,
			     0, 1);
  gtk_table_attach (GTK_TABLE (tmptable), tmpscrollbar, 99, 100,
		    0, 1, GTK_FILL,
		    GTK_EXPAND | GTK_FILL | GTK_SHRINK, 0, 0);
  gtk_widget_show (tmpscrollbar);
  document->tab_label = gtk_label_new (_("Untitled"));
  GTK_WIDGET_UNSET_FLAGS (document->tab_label, GTK_CAN_FOCUS);

  apply_font_style(GTK_WIDGET (document->tab_label), cfg_tab_font);

  /* I did the table like this because it is more flexable than */
  /* a hard coded limit with gtk_widget_set_usize(), and I plan */
  /* on making the window size configurable someday */
  DEBUG_MSG ("new_document, before notebook_append_page\n");
  gtk_notebook_append_page (GTK_NOTEBOOK (main_v->notebook), tmptable, document->tab_label);
  gtk_widget_show (tmptable);
  gtk_widget_realize (document->textbox);
  GTK_WIDGET_UNSET_FLAGS (tmpscrollbar, GTK_CAN_FOCUS);
  document->modified = FALSE;
  document->filename = NULL;
  main_v->documentlist = g_list_append (main_v->documentlist, document);
  gtk_widget_grab_focus (document->textbox);

  /*
   * this used to be the signal, but I'll put this in doc_insert_text_cb
   * and doc_delete_text_cb 
   */
  /* gtk_signal_connect(GTK_OBJECT(document->textbox), "key_press_event",
     textbox_key_press, NULL);   */
  /* this part is copied from gnotepad code 
     Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com> */
  document->ins_txt_id = gtk_signal_connect (GTK_OBJECT (document->textbox),
					     "insert_text", GTK_SIGNAL_FUNC
					     (doc_insert_text_cb), document);
  document->del_txt_id = gtk_signal_connect (GTK_OBJECT (document->textbox),
					     "delete_text", GTK_SIGNAL_FUNC
					     (doc_delete_text_cb), document);
  /* set this new document as active notebook page */
  flush_queue ();
  DEBUG_MSG ("new_document, before notebook_set_page, after flush_queue\n");
  gtk_notebook_set_page (GTK_NOTEBOOK (main_v->notebook), g_list_length
			 (main_v->documentlist) - 2);
  notebook_changed ();
  DEBUG_MSG ("new_document, ended\n");

  return document;
}

void
make_main_window (void)
{
  GtkWidget *vbox, *menubar;
  /* main window */
  DEBUG_MSG ("make_main_window, started\n");
  main_v->main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  DEBUG_MSG ("make_main_window, main_v->main_window(%p)\n", main_v->main_window);
  gtk_signal_connect (GTK_OBJECT (main_v->main_window), "delete_event",
		      GTK_SIGNAL_FUNC (cya_later), NULL);
  gtk_signal_connect (GTK_OBJECT (main_v->main_window), "destroy", GTK_SIGNAL_FUNC
		      (cya_later), NULL);
  gtk_widget_set_usize (GTK_WIDGET (main_v->main_window), main_window_w, main_window_h);
  gtk_window_set_title (GTK_WINDOW (main_v->main_window), CURRENT_VERSION_NAME);

  gtk_window_position (GTK_WINDOW (main_v->main_window), GTK_WIN_POS_CENTER);
  gtk_window_set_wmclass (GTK_WINDOW (main_v->main_window), "Bluefish",
			  "bluefish");
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (main_v->main_window), vbox);
  gtk_widget_show (vbox);
  /* menu bar */
  get_main_menu (main_v->main_window, &menubar);
  gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show (menubar);

  /* the pixmaps can't be created without a realise on the window, the
     error Gdk-WARNING **: Creating pixmap from xpm with NULL window and 
     colormap is removed by adding this line */
  gtk_widget_realize (main_v->main_window);

  /* pack the main toolbar handle box on the right place */
  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
  if (v_main_tb)
    show_main_toolbar (NULL, NULL);

  /* pack the HTML toolbar handle box on the right place */
  html_handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (html_handle_box), FALSE,
		      FALSE, 0);
  if (v_html_tb)
    show_html_toolbar (NULL, NULL);

  /* pack the custom toolbar handle box on the right place */
  cust_handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), cust_handle_box, FALSE, FALSE, 0);
  if (v_custom_tb)
    show_cust_menubar (NULL, NULL);

  /* notebook with the text widget in there */
  main_v->notebook = gtk_notebook_new ();
  g_assert (cfg_tab_pos);
  if (strcmp (cfg_tab_pos, "left") == 0)
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_LEFT);
    }
  else if (strcmp (cfg_tab_pos, "right") == 0)
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_RIGHT);
    }
  else if (strcmp (cfg_tab_pos, "top") == 0)
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_TOP);
    }
  else
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_BOTTOM);
    }
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (main_v->notebook), TRUE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (main_v->notebook), TRUE);
  gtk_notebook_set_tab_border (GTK_NOTEBOOK (main_v->notebook), 1);

  /* We have to know when the notebook changes */
  gtk_signal_connect (GTK_OBJECT (main_v->notebook), "button_release_event",
		      notebook_changed, NULL);
  gtk_signal_connect_after (GTK_OBJECT (main_v->notebook), "key_press_event",
			    notebook_changed, NULL);
/*  gtk_signal_connect_after (GTK_OBJECT (main_v->notebook), "switch_page",
   notebook_changed, NULL); */
  gtk_notebook_set_page (GTK_NOTEBOOK (main_v->notebook), 0);
  gtk_box_pack_start (GTK_BOX (vbox), main_v->notebook, TRUE, TRUE, 0);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (main_v->notebook), TRUE);
  gtk_widget_show (main_v->notebook);

  /* status bar */
  main_v->statusbar = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (vbox), main_v->statusbar, FALSE, TRUE, 0);
  gtk_widget_show (main_v->statusbar);

  DEBUG_MSG ("make_main_window, end\n");
}

void
startup (void)
{
  GdkPixmap *icon = NULL;
#ifndef NOSPLASH
  GtkWidget *vbox, *splash_window;
  GtkWidget *wpixmap;
  GdkPixmap *pixm;
#endif

  /* splash screen */
#ifndef NOSPLASH
  splash_window = gtk_window_new (GTK_WINDOW_DIALOG);
/*    gtk_widget_set_usize(GTK_WIDGET(splash_window), 394, 162); */
  gtk_window_set_title (GTK_WINDOW (splash_window), CURRENT_VERSION_NAME);
  gtk_window_position (GTK_WINDOW (splash_window), GTK_WIN_POS_CENTER);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (splash_window), vbox);
  gtk_widget_show (vbox);
  gtk_widget_realize (splash_window);
  pixm = gdk_pixmap_create_from_xpm_d (splash_window->window, NULL,
				       NULL, bluefish_xpm);
  wpixmap = gtk_pixmap_new (pixm, NULL);
  gdk_pixmap_unref (pixm);
  gtk_box_pack_start (GTK_BOX (vbox), wpixmap, FALSE, FALSE, 0);
  gtk_widget_show (wpixmap);
  gtk_widget_realize (wpixmap);
  gtk_widget_show (splash_window);
  flush_queue ();
#endif
  check_directories ();
  parse_config_files ();
  main_v->documentlist = g_list_alloc ();
  snr_init ();
  make_main_window ();
  gtk_widget_realize (main_v->main_window);
  flush_queue ();
  context_id = gtk_statusbar_get_context_id (GTK_STATUSBAR (main_v->statusbar), "Bluefish");
  DEBUG_MSG ("startup, main_window is ready\n");
  /* add icon to the window when in minimized state */
  icon = gdk_pixmap_create_from_xpm_d (main_v->main_window->window, NULL,
				       NULL, (gchar **) bluefish_icon_xpm);
  gdk_window_set_icon (main_v->main_window->window, NULL, icon, NULL);
  gdk_window_set_icon_name (main_v->main_window->window, CURRENT_VERSION_NAME);
  DEBUG_MSG ("startup, icon is there\n");
#ifndef NOSPLASH
  /* kill the splash window when the main window is going up */
  flush_queue ();
  sleep (1);
  gtk_signal_handlers_destroy (GTK_OBJECT (splash_window));
  gtk_widget_destroy (GTK_WIDGET (splash_window));
#endif
  gtk_widget_show (main_v->main_window);
  if (g_list_length (main_v->documentlist) <= 1)
    {
      main_v->current_document = new_document ();
      gtk_label_set (GTK_LABEL (main_v->current_document->tab_label), _("Untitled"));
    }
  gtk_window_set_policy (GTK_WINDOW (main_v->main_window), TRUE, TRUE, FALSE);
}
