#   Descrip.mms for Analog
#
# Change history:
#
# Cast: RLD  Rick Dyson (rick-dyson@uiowa.edu)
#       MPJZ Martin Zinser
# Date      Who   What
# ========  ====  =============================================================
# 19990919  RLD   Streamlined and suitable for Alpha/OpenVMS
# 19991204  RLD   Updated for v4.x.  Checked on both VAX and Alpha
#                 using DEC C v5.x.  No info on VAX C (please upgrade!)   
# 19991210  MPJZ  Get flags/targets via build_analog; Make it at least in 
#                 principle compatible with VAX C/GNU C.
# 20000320  RLD   Added in new routines for v4.1
# 20000403  MPJZ  Added *.opt to clean and clobber targets.
# 20010411  RLD   Updated for Analog v4.91beta1 and support for the graphics
#                 libraries with JPEG support.  This assumes full versions of
#                 the libraries.
# 20010501  RLD   Updated for Analog v5.0
#

VERSION = 5.0
CFLAGS = $(COMPFLAGS) $(CFLAGS)
LINKFLAGS = $(LINKFLAGS) $(LFLAGS) 
LIBGD   = [.LibGD]LibGD.olb/Library
LIBJPEG = [.LibJPEG]LibJPEG.olb/Library
LIBPNG  = [.LibPNG]LibPNG.olb/Library
LIBZ    = [.ZLib]LibZ.olb/Library
PCRE    = [.pcre]pcre.obj
LIBS    = $(LIBGD), $(LIBPNG), $(LIBZ), $(LIBJPEG)

OBJS = 	alias.obj,analog.obj,cache.obj,dates.obj,globals.obj,hash.obj,init.obj,\
        init2.obj,input.obj,macinput.obj,macstuff.obj,output.obj,output2.obj,\
        process.obj,settings.obj,sort.obj,tree.obj,utils.obj,win32.obj

.ifdef CALLED
all :	analog.exe
	@ Write Sys$Output "Finished building Analog (v$(VERSION))!"
.else
info :
        @ Write Sys$Output "Please execute MMS/MMK via @ Build_Analog"
.endif

analog.exe :	$(OBJS) $(PCRE) $(LIBS)
	$(LINK) $(LINKFLAGS) $+

$(OBJS) :	anlghead.h,anlghea2.h,anlghea3.h,anlghea4.h

$(PCRE) :
	- Set Default [.PCRE]
	- $(MMS) $(MMSQUALIFIERS)
	- Set Default [-]

$(LIBGD) :
	- Set Default [.LibGD]
	- $(MMS) $(MMSQUALIFIERS) lib
	- Set Default [-]

$(LIBPNG) :
	- Set Default [.LibPNG]
	- $(MMS) $(MMSQUALIFIERS) lib
	- Set Default [-]

$(LIBZ) :
	- Set Default [.ZLib]
	- $(MMS) $(MMSQUALIFIERS) lib
	- Set Default [-]

$(LIBJPEG) :
	- Set Default [.LibJPEG]
	- $(MMS) $(MMSQUALIFIERS) lib
	- Set Default [-]

install :	analog.exe
	Copy analog.exe WWW_System:

clean :
	- Purge /NoConfirm *.obj,*.exe,*.opt
	- Set Default [.LibGD]
	- $(MMS) $(MMSQUALIFIERS) clean
	- Set Default [-.LibJPEG]
	- $(MMS) $(MMSQUALIFIERS) clean
	- Set Default [-.LibPNG]
	- $(MMS) $(MMSQUALIFIERS) clean
	- Set Default [-.PCRE]
	- $(MMS) $(MMSQUALIFIERS) clean
	- Set Default [-.ZLib]
	- $(MMS) $(MMSQUALIFIERS) clean
	- Set Default [-]

clobber :	clean
	- Purge /NoConfirm *.h, *.c, *.mms, *.com, *.log
	- Delete /NoConfirm *.obj;,*.exe;,*.opt;,*.log;
	- Set Default [.LibGD]
	- $(MMS) $(MMSQUALIFIERS) clobber
	- Set Default [-.LibJPEG]
	- $(MMS) $(MMSQUALIFIERS) clobber
	- Set Default [-.LibPNG]
	- $(MMS) $(MMSQUALIFIERS) clobber
	- Set Default [-.PCRE]
	- $(MMS) $(MMSQUALIFIERS) clobber
	- Set Default [-.ZLib]
	- $(MMS) $(MMSQUALIFIERS) clobber
	- Set Default [-]
