/* Error handling for gpasm
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "stdhdr.h"

#include "gpasm.h"
#include "gperror.h"
#include "lst.h"

void gperror(unsigned int code,
	     char *message)
{
  char full_message[BUFSIZ];

  if (state.pass == 2) {
    if (state.src)
      sprintf(full_message,
	      "Error %s %d : %03d %s",
	      state.src->name,
	      state.src->line_number,
	      code,
	      message);
    else
      sprintf(full_message,
	      "Error %03d %s",
	      code,
	      message);
    printf("%s\n", full_message);
    lst_line(full_message);

    state.num.errors++;
  }
}
