/* Common definitions for gpasm
   Copyright (C) 1998 James Bowman

This file is part of gpasm.

gpasm is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpasm is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpasm; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#if !defined(__GPASM_H)
#define __GPASM_H

#include <stdio.h>
#include "processor.h"

#define GPASM_VERSION_STRING "gpasm 0.0.7 alpha"

#define SPECIAL_PATH	DATADIR "/special.inc"

#define STRCMP(s1, s2)	(state.case_insensitive ? \
			 strcasecmp((s1), (s2)) : \
			 strcmp((s1), (s2)))
			 
typedef int gpasmVal; 		/* The type that internal arithmetic uses */

enum outfile { normal, suppress, named };

#define MAX_RAM		0x1000	/* Maximum RAM */
#define MAX_I_MEM	0x10000 /* Maximum instruction memory */

extern struct gpasm_state {
  int radix;
  enum { inhx8m, inhx8s, inhx32 } hex_format;
  int case_insensitive;
  int quiet;
  enum pic_processor processor;

  int pass;					/* 1 or 2 */
  int processor_chosen;		/* Nonzero after processor-specific init */
  struct symbol_table
  *stBuiltin,			/* Built-ins: instructions, pseudo-ops */
    *stGlobal,			/* Global symbols */
    *stTop,			/* Top of locals stack (stGlobal is base) */
    *stDefines,			/* Preprocessor #defines */
    *stMacros;			/* Macros */
  unsigned int
    i_memory[MAX_I_MEM];	/* Instruction memory */
  char
    badram[MAX_RAM];		/* nonzero indicates illegal memory */
  unsigned int maxram;		/* Highest legal memory location */
  unsigned int org;		/* Current code-generation point */
  enum outfile
    lstfile,			/* List output file control */
    hexfile;			/* Hex output file control */
  char *srcfilename,		/* Source (.asm) file name */
    hexfilename[BUFSIZ],	/* Hex (.hex) file name */
    lstfilename[BUFSIZ];	/* List (.lst) file name */
  struct {			/* List file state: */
    FILE *f;			/*   List file output */
    unsigned int
      lineofpage,		/*   What line are we at within the page */
      page,			/*   What page are we at */
      linesperpage,		/*   Lines per page */
      symboltable;		/*   Symbol table dump enabled */
    struct {
      unsigned int was_org;	/*   value of state.org at start of line */
		    		/*   What kind of line was it? */
      enum { none,		/*     Nothing - blank line */
	     org,		/*     ORG pseudo-op */
	     insn,		/*     Some other instruction or pseudo */
	     equ }		/*     An equate */
        linetype;
    } line;
    char startdate[80];		/*   When assembly started */
    int enabled;		/*   nonzero if listing is enabled */
    char title_name[80];	/*   given in TITLE directive */
    int tabstop;		/*   tab-stop distance */
  } lst;
  struct source_context *src;	/* Top of the stack of source files */
  struct {			/* Totals for errors, warnings, messages */
    int errors;
    int warnings;
    int messages;
  } num;
  struct amode *astack;		/* Stack of amodes (macros, etc) */
  gpasmVal cblock;		/* cblock constant */
  struct macro_head *mac_head;  /* Starting a macro... */
  struct macro_body **mac_prev; /* Stitching ptr */
  struct macro_body *mac_body;	/* While we're building a macro */
} state;

#define MEM_USED_MASK 0x80000000 /* Means occupied in state.i_memory above */

struct variable {
  int value;
};

/************************************************************************/

struct source_context {
  char *name;
  FILE *f, *f2;
  struct yy_buffer_state *yybuf;
  unsigned int line_number;
  struct source_context *prev;
  char line[BUFSIZ];
};

void yyerror(char *s);
int gpasm_number(char *);
void open_file(char *name);
void set_global(char *name, gpasmVal value);
void select_radix(char *name);

/************************************************************************/

/* Parse node: created by the parser, interpreted by the 'backend' */

struct pnode {
  enum pnode_tag { constant, symbol, string, list, binop, unop } tag;
  union {
    int constant;
    char *symbol;
    struct {
      struct pnode *head, *tail;
    } list;
    struct {
      int op;
      struct pnode *p0, *p1;
    } binop;
    struct {
      int op;
      struct pnode *p0;
    } unop;
    char *string;
  } value;
};

/************************************************************************/

struct macro_head {
  int pass;			/* Pass in which macro was defined: 1 or 2 */
  struct pnode *parms;
  struct macro_body *body;
  int line_number;
};

struct macro_body {
  char *label;			/* Label for the line */
  char *op;			/* Operation (or NULL) */
  struct pnode *parms;		/* Parameters for op (or NULL) */
  char *src_line;		/* Original source line - for listing */
  struct macro_body *next;	/* Next line in listing */
};

#endif
