/* Copyright (c) 1998 John E. Davis (davis@space.mit.edu)
 *
 * This file is part of slrn.
 *
 * Slrn is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * Slrn is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Slrn; see the file COPYING.  If not, write to the Free
 * Software Foundation, 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307, USA.
 */

#include "config.h"

#include <stdio.h>
#include <string.h>

#include "slrnfeat.h"
#ifdef KANJI
#include <slang.h>
#include "khenkan.h"
#endif
#include "ttymsg.h"

void slrn_tty_vmessage (FILE *fp, char *fmt, va_list ap)
{
   static FILE *last_fp;
   
   if ((fp == stdout) || (last_fp == stdout)) fputc ('\n', fp);
#ifdef KANJI
   if (Slang_Display_Code != EUC) {
     (void) vsprintf((char *)jtmp_str, fmt, ap);
     slrn_conv_string((char *)jtmp_str, Slang_Display_Code);
     fputs((char *)jtmp_str, fp);
   } else
#endif
   (void) vfprintf(fp, fmt, ap);
   if (fp == stderr) fputc ('\n', fp);
   fflush (fp);
   
   last_fp = fp;
}

#ifndef KANJI
void slrn_tty_message (char *fmt, ...)
{
   va_list ap;
   
   va_start (ap, fmt);
   slrn_tty_vmessage (stdout, fmt, ap);
   va_end (ap);
}

void slrn_tty_error (char *fmt, ...)
{
   va_list ap;
   
   va_start (ap, fmt);
   slrn_tty_vmessage (stderr, fmt, ap);
   va_end (ap);
}
#endif

