\function{get_variable_value}
\synopsis{-}
\usage{Value get_variable_value (String v)}
\description
   This function returns the value of an internal variable specified
   by \var{v}.  Here \var{v} must be one of the variable names that can be
   used in \var{.slrnrc} `set' commands.  The type of the object returned will
   depend upon the type of the object \var{v} represents.
\seealso{set_integer_variable, set_string_variable}
\done

\function{quit}
\synopsis{-}
\usage{Void quit (Integer exit_status)}
\description
   This function will cause the newsreader to exit with exit status
   specified by \var{exit_status}.
\seealso{call}
\done

\function{server_name}
\synopsis{-}
\usage{String server_name ()}
\description
   The \var{server_name} function returns the name of the current server.
\seealso{current_newsgroup}
\done

\function{set_color}
\synopsis{-}
\usage{Void set_color (String obj, String fg, String bg)}
\description
   This function may be used to set the foreground and background
   colors of an object.  The \var{obj} parameter specifies the object and
   the \var{fg} and \var{bg} parameters specify the foreground and background
   colors, respectively.
\done

\function{set_integer_variable}
\synopsis{-}
\usage{Void set_integer_variable (String name, Integer v)}
\description
   This function may be used to set the value of the internal integer
   variable specified by \var{name} to value \var{v}.  \var{name} must be an integer
   variable name allowed in .slrnrc \var{set} commands.
\seealso{set_string_variable, get_variable_value}
\done

\function{set_string_variable}
\synopsis{-}
\usage{Void set_string_variable (String name, String v)}
\description
   This function may be used to set the value of the internal string
   variable specified by \var{name} to value \var{v}.  \var{name} must be a string
   variable name allowed in .slrnrc \var{set} commands.
\seealso{set_integer_variable, get_variable_value}
\done

\function{tt_send}
\synopsis{Send a string to the terminal}
\usage{Void tt_send (String_Type s)}
\description
   This function may be used to send a string directly to the display
   without any involvement of the screen management layer.
\seealso{message, update}
\done

\function{update}
\synopsis{-}
\usage{update ()}
\description
   This function may be used to force the display to be updated.
\seealso{message}
\done

