/*****************************************************************************/
/* linleech - a program to selectively download usenet articles              */
/* Copyright (C) 1988  Curtiss Howard                                        */ 
/*                                                                           */
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2 of the License, or         */
/* (at your option) any later version.                                       */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; if not, write to the Free Software               */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
/*****************************************************************************/

#include <slang.h>

#include "linleech_vars.h"

void SLang_Init (void);

/* S-Lang function handlers. */

void Connect (char *Host, int *Port);
void DeleteMatchList (void);
void DisableMatchAll (void);
void DisableResume (void);
void Disconnect (void);
void EnableMatchAll (void);
void EnableResume (void);
void Filter (char *Program, int *Output);
void HideSubjects (void);
void JoinGroup (char *Group);
void MatchFunc (char *Str, int *Case);
void MatchRegexp (char *Str);
void NewMatchList (int *Size);
void RawConnect (char *Host, int *Port);
char *RawReceive (void);
void RawSend (char *Text);
void RemoveFilter (void);
void SaveTo (char *Dir);
void SaveToDef (void);
void SetTrigger (char *Trigger, char *Find);
void ShowSubjects (void);

/* Miscellaneous functions. */

void ArticleMatchInsensitive (char *Subject, MATCH MatchVar, int Article,
	char *Group);
void ArticleMatchRegexp (char *Subject, MATCH MatchVar, int Article,
	char *Group);
void ArticleMatchSensitive (char *Subject, MATCH MatchVar, int Article,
	char *Group);
void GetArticles (char *Group, int NumArticles, int Start, int Stop);
void SaveArticle (char *Group, int Article);

/* S-Lang function table. */

SLang_Intrin_Fun_Type Functions[] =
{
	MAKE_INTRINSIC_N ("connect", Connect, VOID_TYPE, 2, STRING_TYPE,
		INT_TYPE, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("delete_match_list", DeleteMatchList, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("disable_match_all", DisableMatchAll, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("disable_resume", DisableResume, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("disconnect", Disconnect, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("enable_match_all", EnableMatchAll, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("enable_resume", EnableResume, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("filter", Filter, VOID_TYPE, 2, STRING_TYPE,
		INT_TYPE, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("group", JoinGroup, VOID_TYPE, 1, STRING_TYPE,
		0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("hide_subjects", HideSubjects, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("match", MatchFunc, VOID_TYPE, 2, STRING_TYPE, INT_TYPE,
		0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("match_regexp", MatchRegexp, VOID_TYPE, 1, STRING_TYPE,
		0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("new_match_list", NewMatchList, VOID_TYPE, 1,
		INT_TYPE, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("raw_connect", RawConnect, VOID_TYPE, 2, STRING_TYPE,
		INT_TYPE, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("raw_receive", RawReceive, STRING_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("raw_send", RawSend, VOID_TYPE, 1, STRING_TYPE,
		0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("remove_filter", RemoveFilter, VOID_TYPE, 0, 
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("saveto", SaveTo, VOID_TYPE, 1, STRING_TYPE,
		0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("saveto_def", SaveToDef, VOID_TYPE, 0, 
		0, 0, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("set_trigger", SetTrigger, VOID_TYPE, 2,
		STRING_TYPE, STRING_TYPE, 0, 0, 0, 0, 0),
	MAKE_INTRINSIC_N ("show_subjects", ShowSubjects, VOID_TYPE, 0,
		0, 0, 0, 0, 0, 0, 0),
	SLANG_END_TABLE
};
