/*********************************************
**********************************************
This is a file of general utility functions useful
for programming in general and icq in specific

This software is provided AS IS to be used in
whatever way you see fit and is placed in under
the GPL.

Author : Matthew Smith April 23, 1998
Contributors :  airog (crabbkw@rose-hulman.edu) May 13, 1998

Used/Changed for zICQ by Omar Harriott, March 1999

Changes :
**********************************************
March 11, 1999
James Perkins: fixed the char *line_wrap function

March 20, 1999
Chris Moore: add Emacs style editing commands (I got sick of having to
hold down the 'left' key each time I forgot to type 'r' before typing
a long message): */

#define KEY_CTRL_A 1  /* beginning of line */
#define KEY_CTRL_B 2  /* backwards (left) */
#define KEY_CTRL_D 4  /* delete character under cursor */
#define KEY_CTRL_E 5  /* end of line */
#define KEY_CTRL_F 6  /* forwards (right) */
#define KEY_CTRL_H 8  /* backspace */
#define KEY_CTRL_J 10 /* linefeed / enter */
#define KEY_CTRL_K 11 /* delete to end of line */
#define KEY_CTRL_N 14 /* next line (up) */
#define KEY_CTRL_P 16 /* previous line (down) */

/* how many old lines to store in the command history */
#define NUM_HISTORY_SLOTS 50

/* how long each history slot is (not including null terminator) */
#define MAX_STR_LEN 2047

/* how long other strings are (?) */
#define LONG_STRING_LEN 2047

/*********************************************/

#include "zicq.h"
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef _WIN32
#include <io.h>
#define S_IRUSR		_S_IREAD
#define S_IWUSR		_S_IWRITE
#endif
#ifdef UNIX
#include <unistd.h>
#include <termios.h>
#endif

static char rcfile[256];

void check_timeout()
{
  time_out = time(NULL) + time_out_delay;
  Got_Ping = FALSE;
#ifdef DEBUG
  wprintw(mainw, "Sending Ping\n");
#endif
  icq_sendmsg(sok, UIN, "zICQ-PING.PING!PING");
}

char* zgetline(int size)
{
  char buffer[MAX_STR_LEN + 1];
  int ch;
  int pos = 0;
  int size2 = 0;
  bool again = TRUE;
  char addtext[MAX_STR_LEN + 1];
  char *addptr = &addtext;
  char temp[COLS-2];
  int x;
  int offset=0;
  int histdis;
  static int histpos = 0;
  static int histcur = 0;
  static int maxhist = 0;
  static char history[NUM_HISTORY_SLOTS][MAX_STR_LEN + 1];  /* 50 Lines in history */

  if (size > MAX_STR_LEN)
    {
      size = MAX_STR_LEN;
    }

  memset(buffer, 0, MAX_STR_LEN + 1);
  size2 = 0;

  while (again)		/* keep us alive while typing */
    {
      if (time(NULL) > next)
	{
	  next = time(NULL) + time_delay;
	  Keep_Alive(sok);
	}

      ch = wgetch(userin);
      /* wprintw(mainw, "wgetch() returned %d\n", ch); wrefresh(mainw); */
      buffer[size] = '\0';
#if 0
      if ((ch <127) && (ch > 30) && ((size - 1) > size2))
	{
	  if (pos == size2)
	    {
	      buffer[pos] = (char) ch;
	    }
	  else
	    {
	      strcpy(addptr, &buffer[pos]);
	      buffer[pos] = (char) ch;
	      strcpy(&buffer[pos + 1], addptr);
	    }
	  pos++;
	  size2++;
	  buffer[size + 1]=0;
	}
      else
	{
#endif
	  switch (ch)
	    {
	    case KEY_CTRL_A:
	      /* ^A moves to the beginning of the line */
	      pos = offset = 0;
	      break;

	    case KEY_CTRL_D:
	      if (pos < size2)
		{
		  strcpy(addptr, &buffer[pos+1]);
		  strcpy(&buffer[pos], addptr);
		  size2--;
		}
	      break;

	    case KEY_CTRL_E:
	      /* ^E moves to the end of the line */
	      pos = size2;
	      break;

	    case KEY_CTRL_K:
	      /* ^K kills text from cursor to end of line */
	      if (size2 > pos)
		{
		  memset(buffer + pos, 0, size2 - pos);
		  size2 = pos;
		}
#ifdef DEBUG
	      wprintw(mainw, "pos: %d, offset: %d; size2: %d; buffer: '%s'\n", pos, offset, size2, buffer); wrefresh(mainw);
#endif
	      break;

	    case KEY_CTRL_B:
	    case KEY_LEFT:
	      pos--;
	      if (pos < 0)
		{
		  pos = 0;
		}
	      break;

	    case KEY_CTRL_F:
	    case KEY_RIGHT:
	      pos++;
	      if (pos > size2)
		{
		  pos = size2;
		}
	      break;

	    case KEY_CTRL_P:
	    case KEY_UP:
	      if ((histpos > 0) || (maxhist == NUM_HISTORY_SLOTS))
		{
		  // wprintw(mainw, "writing '%s' to slot %d\n", buffer, histpos); wrefresh(mainw);
		  // strcpy(history[histpos], buffer);
		  if (histdis < NUM_HISTORY_SLOTS)
		    {
		      histdis++;
		      histpos--;
		      if (histpos < 0)
			{
			  histpos = NUM_HISTORY_SLOTS - 1;
			}
		      strcpy(buffer, history[histpos]);
#ifdef DEBUG
		      wprintw(mainw, "reading '%s' from slot %d\n", buffer, histpos); wrefresh(mainw);
#endif
		    }
		}
#ifdef DEBUG
	      wprintw(mainw, "histpos: %d; maxhist: %d; histcur: %d; histdis: %d\n", histpos, maxhist, histcur, histdis); wrefresh(mainw);
#endif
	      pos = strlen(buffer);
	      size2 = pos;
	      break;

	    case KEY_CTRL_N:
	    case KEY_DOWN:
	      if ((histpos < maxhist) || (maxhist == NUM_HISTORY_SLOTS))
		{
		  // wprintw(mainw, "writing '%s' to slot %d\n", buffer, histpos); wrefresh(mainw);
		  // strcpy(history[histpos], buffer);
		  if (histdis > 0)
		    {
		      histdis--;
		      histpos++;
		      if (histpos == NUM_HISTORY_SLOTS)
			{
			  histpos = 0;
			}
		      if (histdis == 0)
			{
			  strcpy(buffer, "");
			}
		      else
			{
			  strcpy(buffer, history[histpos]);
#ifdef DEBUG
			  wprintw(mainw, "reading '%s' from slot %d\n", buffer, histpos); wrefresh(mainw);
#endif
			}
		    }
		}
#ifdef DEBUG
	      wprintw(mainw, "histpos: %d; maxhist: %d; histcur: %d; histdis: %d\n", histpos, maxhist, histcur, histdis); wrefresh(mainw);
#endif
	      pos = strlen(buffer);
	      size2 = pos;
	      break;

	    case KEY_CTRL_H:
	    case KEY_BACKSPACE:
	    case 127:
	      if (pos > 0)
		{
		  strcpy(addptr, &buffer[pos]);
		  strcpy(&buffer[pos-1], addptr);
		  size2--;
		  pos--;
		}
	      break;

	    case KEY_CTRL_J:
	      again = FALSE;
	      if (strlen(buffer) > 0)
		{
#ifdef DEBUG
		  wprintw(mainw, "writing '%s' to slot %d\n", buffer, histcur); wrefresh(mainw);
#endif
		  strcpy(history[histcur], buffer);
		  if (++maxhist >= NUM_HISTORY_SLOTS) maxhist = NUM_HISTORY_SLOTS;
		  if (++histcur >= NUM_HISTORY_SLOTS) histcur = 0;
		  histpos = histcur;
		  histdis = 0;
		}
#ifdef DEBUG
	      wprintw(mainw, "histpos: %d; maxhist: %d; histcur: %d; histdis: %d\n", histpos, maxhist, histcur, histdis); wrefresh(mainw);
#endif
	      break;

	    default:
#ifdef DEBUG
	      wprintw(mainw, "buffer: '%s'; size2: %d; MAX: %d\n", buffer, size2, MAX_STR_LEN); wrefresh(mainw);
#endif
	      // only write into the buffer if it isn't full
	      if (size2 < MAX_STR_LEN)
		{
		  if (pos == size2)
		    {
		      // ch = wgetch(userin); wprintw(mainw, "1: wgetch() returned %d\n", ch); wrefresh(mainw);
		      buffer[pos] = (char) ch;
		      // ch = wgetch(userin); wprintw(mainw, "2: wgetch() returned %d\n", ch); wrefresh(mainw);
		      buffer[pos + 1] = '\0';
		    } else {
		      // ch = wgetch(userin); wprintw(mainw, "3: wgetch() returned %d\n", ch); wrefresh(mainw);
		      strcpy(addptr, &buffer[pos]);
		      // ch = wgetch(userin); wprintw(mainw, "4: wgetch() returned %d\n", ch); wrefresh(mainw);
		      buffer[pos] = (char) ch;
		      // ch = wgetch(userin); wprintw(mainw, "5: wgetch() returned %d\n", ch); wrefresh(mainw);
		      strcpy(&buffer[pos + 1], addptr);
		    }
		  // ch = wgetch(userin); wprintw(mainw, "6: wgetch() returned %d\n", ch); wrefresh(mainw);
		  pos++;
		  // ch = wgetch(userin); wprintw(mainw, "7: wgetch() returned %d\n", ch); wrefresh(mainw);
		  size2++;
		  // ch = wgetch(userin); wprintw(mainw, "8: wgetch() returned %d\n", ch); wrefresh(mainw);
		  buffer[size]=0;
		  // ch = wgetch(userin); wprintw(mainw, "9: wgetch() returned %d\n", ch); wrefresh(mainw);
		}
	      break;
	    }
#if 0
	}
#endif
      wcolor_set(userin, 2, NULL);
      mvwprintw(userin, 0, 0, "\n\n\n\nzICQ> ");
      wcolor_set(userin, 1, NULL);
      if (pos > (COLS-20 + offset))
	{
	  offset = pos - 20;
	}
      if ((pos - offset) < 20)
	{
	  offset = offset - 20;
	  if (offset < 0)
	    {
	      offset = 0;
	    }
	}

      strncpy(&temp, &buffer[offset], COLS-8);
      wprintw(userin, "%s", &temp);
      if (pos != size2)
	{
	  if (pos < 1)
	    {
	      /* wprintw(mainw, "pos is %d so moving to (0, 6)\n", pos); wrefresh(mainw); */
	      mvwinch(userin, 0, 6);
	    } else {
	      /* wprintw(mainw, "pos is %d so moving to (0, %d (%d - %d + 5)\n", pos, pos - offset + 5, pos, offset); wrefresh(mainw); */
	      mvwinch(userin, 0, pos - offset + 6);
	      wrefresh(userin);
	    }
	}
    }
  return (buffer) ;
}

void lw_wprintw(WINDOW *win, char *str, ...)
{
  va_list args;
  char buf[LONG_STRING_LEN + 1]; /* this should be big enough */

  assert(buf != NULL);
  assert(LONG_STRING_LEN + 1 >= strlen(str));

  va_start(args, str);
  vsprintf(buf, str, args);
  va_end(args);
  wprintw(win, line_wrap(win, buf, win->_curx));
}

/* print it line wrapped with spaces. */

void lws_wprintw(WINDOW *win, int offset, char *str, ...)
{
  va_list args;
  char buf[LONG_STRING_LEN + 1]; /* this should be big enough */

  assert(buf != NULL);
  assert(LONG_STRING_LEN + 1 >= strlen(str));

  va_start(args, str);
  vsprintf(buf, str, args);
  va_end(args);

  wprintw(win, line_wrap(win, buf, offset));
}

/***************************************************************
Line wrap.
****************************************************************/
char *line_wrap(WINDOW *win, char *string, int offset)
{
  char *s, *t;
  int remaining;

  remaining = win->_maxx - offset;

  s = string;
  while(1)
    {
      /* copy this word (incl. leading spaces) out to buf */
      while(*s && *s == ' ')
	{
	  s++;
	  remaining--;
	}
      while(*s && *s != ' ')
	{
	  s++;
	  remaining--;
	}
      /* if at EOS we are done */
      if(*s == '\0')
	{
	  break;
	}

      /* look-ahead part: find length of next word */
      t = s;
      while(*t && *t == ' ')
	{
	  t++;
	}
      while(*t && *t != ' ')
	{
	  t++;
	} /* t now one past end of word */

      /* if next word too long, split line */
      if(t - s > remaining)
	{
	  *s++ = '\n';
	  remaining = win->_maxx;
	}
      /* loop and process next word */
    }
  return string;
}

/***************************************************************
Turns keybord echo off for the password
****************************************************************/
S_DWORD Echo_Off(void)
{
#ifdef UNIX
  struct termios attr; /* used for getting and setting terminal
			  attributes */

  /* Now turn off echo */
  if (tcgetattr(STDIN_FILENO, &attr) != 0) return(-1);
  /* Start by getting current attributes.  This call copies
     all of the terminal paramters into attr */

  attr.c_lflag &= ~(ECHO);
  /* Turn off echo flag.  NOTE: We are careful not to modify any
     bits except ECHO */
  if (tcsetattr(STDIN_FILENO, TCSAFLUSH, &attr) != 0) return(-2);
  /* Wait for all of the data to be printed. */
  /* Set all of the terminal parameters from the (slightly)
     modified struct termios */
  /* Discard any characters that have been typed but not yet read */
#endif
  return 0;
}

/***************************************************************
Turns keybord echo back on after the password
****************************************************************/
S_DWORD Echo_On(void)
{
#ifdef UNIX
  struct termios attr; /* used for getting and setting terminal
			  attributes */

  if (tcgetattr(STDIN_FILENO, &attr) != 0) return(-1);

  attr.c_lflag |= ECHO;
  if(tcsetattr(STDIN_FILENO, TCSANOW, &attr) != 0) return(-1);
#endif
  return 0;
}

/**************************************************************
Same as fprintf but for FD_T's
***************************************************************/
void M_fdprint(FD_T fd, char *str, ...)
{
  va_list args;
  int k;
  char buf[LONG_STRING_LEN + 1]; /* this should be big enough */

  assert(buf != NULL);
  assert(LONG_STRING_LEN >= strlen(str));

  va_start(args, str);
  vsprintf(buf, str, args);
  k = write(fd, buf, strlen(buf));
  assert(k == strlen(buf));
  va_end(args);
}

/***********************************************************
Reads a line of input from the file descriptor fd into buf
an entire line is read but no more than len bytes are
actually stored
************************************************************/
int M_fdnreadln(FD_T fd, char *buf, size_t len)
{
      int i, j;
      char tmp;

      assert(buf != NULL);
      assert(len > 0);
      tmp = 0;
      for (i=-1; (tmp != '\n')  ;)
	{
	  if  ((i < len) || (i == -1))
	    {
	      i++;
	      j = read(fd, &buf[i], 1);
	      tmp = buf[i];
	    }
	  else
	    {
	      j = read(fd, &tmp, 1);
	    }
	  assert(j != -1);
	  if (j == 0)
	    {
	      buf[i] =  0;
	      return -1;
	    }
	}
      if (i < 1)
	{
	  buf[i] = 0;
	}
      else
	{
	  if (buf[i-1] == '\r')
	    {
	      buf[i-1] = 0;
	    }
	  else
	    {
	      buf[i] = 0;
	    }
	}
      return 0;
    }

/********************************************
returns a string describing the status or
a NULL if no such string exists
*********************************************/
char *Convert_Status_2_Str(WINDOW* win, int status)
{
  if (STATUS_OFFLINE == status) /* this because -1 & 0xFFFF is not -1 */
    {
      return "Offline";
    }

  switch (status & 0xffff)
    {
    case STATUS_ONLINE:
      wcolor_set(win, 5, NULL);
      return "On";
      break;
    case STATUS_DND:
      wcolor_set(win, 6, NULL);
      return "DND";
      break;
    case STATUS_AWAY:
      wcolor_set(win, 6, NULL);
      return "Away";
      break;
    case STATUS_OCCUPIED:
      wcolor_set(win, 6, NULL);
      return "Occ";
      break;
    case STATUS_NA:
      wcolor_set(win, 6, NULL);
      return "N/A";
      break;
    case STATUS_INVISIBLE:
      wcolor_set(win, 7, NULL);
      return "Inv";
      break;
    case STATUS_FREE_CHAT:
      wcolor_set(win, 8, NULL);
      return "FFC";
      break;
    default :
      return NULL;
      break;
    }
}

/********************************************
prints out the status of new_status as a string
if possible otherwise as a hex number
*********************************************/
void Print_Status(WINDOW* win, DWORD new_status)
{
  if (Convert_Status_2_Str(win, new_status) != NULL)
    {
      wprintw(win, "%s", Convert_Status_2_Str(win, new_status));
      if (Verbose)
	lw_wprintw(win, " %02X", (WORD) (new_status >> 16));
    }
  else
    {
      lw_wprintw(win, "%08lX", new_status);
    }
  wcolor_set(blist, 1, NULL);
}

/**********************************************
Prints the name of a user or there UIN if name
is not know.
***********************************************/
int Print_UIN_Name(DWORD uin)
{
  int i;

  for (i=0; i < Num_Contacts; i++)
    {
      if (Contacts[i].uin == uin)
	break;
    }

  if (i == Num_Contacts)
    {
      lw_wprintw(mainw, "%lu", uin);
      return -1 ;
    }
  else
    {
      lw_wprintw(mainw, "%s", Contacts[i].nick);
      return i;
    }
}

/*********************************************
Converts a nick name into a uin from the contact
list.
**********************************************/
DWORD nick2uin(char *nick)
{
  int i;
  BOOL non_numeric=FALSE;

  for (i=0; i< Num_Contacts; i++)
    {
      if (! strncasecmp(nick, Contacts[i].nick, 19))
	{
	  if ((S_DWORD) Contacts[i].uin > 0)
	    return Contacts[i].uin;
	  else
	    return -Contacts[i].uin; /* alias */
	}
    }
  for (i=0; i < strlen(nick); i++)
    {
      if (! isdigit((int) nick[i]))
	{
	  non_numeric=TRUE;
	  break;
	}
    }
  if (non_numeric)
    return -1; /* not found and not a number */
  else
    return atoi(nick);
}


static void Initalize_RC_File(void)
{
  FD_T rcf;
  time_t t;
  char nickstr[100];

  rcf = open(rcfile, O_RDWR | O_CREAT, S_IRUSR | S_IWUSR);
  if (rcf == -1)
    {
      perror("Error creating config file ");
      endwin();
      exit(1);
    }
  M_fdprint(rcf, "# This file was generated by Zicq of %s %s\n", __TIME__, __DATE__);
  t = time(NULL);
  M_fdprint(rcf, "# This file was generated on %s", ctime(&t));
  printf("Enter UIN : #");
  fflush(stdout);
  scanf("%s", nickstr);
  UIN = nick2uin(nickstr);
  M_fdprint(rcf, "UIN %d\n", UIN);
  printf("Enter password : ");
  fflush(stdout);
  Echo_Off();
  scanf("%s", passwd);
  Echo_On();
  M_fdprint(rcf, "Password %s\n", passwd);
  set_status = STATUS_ONLINE;
  M_fdprint(rcf, "Status %d\n", STATUS_ONLINE);
  M_fdprint(rcf, "Server %s\n", "icq1.mirabilis.com");
  strcpy(server, "icq1.mirabilis.com");
  remote_port = 4000;
  M_fdprint(rcf, "#No_Beep\n");
  M_fdprint(rcf, "#Sound_Player bwavplay\n");
  M_fdprint(rcf, "#Sound_File /ding.wav\n");
  M_fdprint(rcf, "Port %d\n", 4000);
  M_fdprint(rcf, "#No_Log\n");
  M_fdprint(rcf, "\n#Russian\n#if you want KOI8-R to CP1251 Russain translation uncomment the above line.\n");

  M_fdprint(rcf, "\n# Below are the commands which can be changed to most anything you want :)\n");
  M_fdprint(rcf, "message_cmd msg\n");
  M_fdprint(rcf, "info_cmd info\n");
  M_fdprint(rcf, "quit_cmd q\n");
  M_fdprint(rcf, "reply_cmd r\n");
  M_fdprint(rcf, "again_cmd a\n");
  M_fdprint(rcf, "list_cmd w\n");
  M_fdprint(rcf, "away_cmd away\n");
  M_fdprint(rcf, "na_cmd na\n");
  M_fdprint(rcf, "dnd_cmd dnd\n");
  M_fdprint(rcf, "online_cmd online\n");

  M_fdprint(rcf, "occ_cmd occ\n");
  M_fdprint(rcf, "ffc_cmd ffc\n");
  M_fdprint(rcf, "inv_cmd inv\n");
  M_fdprint(rcf, "search_cmd search\n");
  M_fdprint(rcf, "status_cmd status\n");
  M_fdprint(rcf, "auth_cmd auth\n");
  M_fdprint(rcf, "auto_cmd auto\n");
  M_fdprint(rcf, "add_cmd add\n");
  M_fdprint(rcf, "change_cmd change\n");


  M_fdprint(rcf, "\n# Ok now the contact list\n");
  M_fdprint(rcf, "Contacts\n");
  M_fdprint(rcf, "9026622 Omar\n");
  Num_Contacts = 1;
  Contacts[0].uin = 9026622;
  strcpy(Contacts[0].nick, "Omar");
  Contacts[0].status = STATUS_OFFLINE;
  Contacts[0].last_time = -1L;
  Contacts[0].current_ip = 0x7f000001;
  Contacts[0].port = 0;
  Contacts[0].sok = (SOK_T) -1L;
  close(rcf);

  strcpy(message_cmd, "msg");
  strcpy(info_cmd, "info");
  strcpy(add_cmd, "add");
  strcpy(quit_cmd, "q");
  strcpy(reply_cmd, "r");
  strcpy(again_cmd, "a");
  strcpy(list_cmd, "w");
  strcpy(away_cmd, "away");
  strcpy(na_cmd, "na");
  strcpy(dnd_cmd, "dnd");
  strcpy(online_cmd, "online");
  strcpy(occ_cmd, "occ");
  strcpy(ffc_cmd, "ffc");
  strcpy(inv_cmd, "inv");
  strcpy(status_cmd, "status");
  strcpy(auth_cmd, "auth");
  strcpy(auto_cmd, "auto");
  strcpy(search_cmd, "search");
}

static void Read_RC_File(FD_T rcf)
{
  char buf[500];
  char *tmp;
  DWORD tmp_uin;
      
  message_cmd[0]='\0'; /* for error checking later */
  quit_cmd[0]='\0'; /* for error checking later */
  info_cmd[0]='\0'; /* for error checking later */
  reply_cmd[0]='\0'; /* for error checking later */
  again_cmd[0]='\0'; /* for error checking later */
  add_cmd[0]='\0'; /* for error checking later */

  list_cmd[0]='\0'; /* for error checking later */
  away_cmd[0]='\0'; /* for error checking later */
  na_cmd[0]='\0'; /* for error checking later */
  dnd_cmd[0]='\0'; /* for error checking later */
  online_cmd[0]='\0'; /* for error checking later */
  occ_cmd[0]='\0'; /* for error checking later */
  ffc_cmd[0]='\0'; /* for error checking later */
  inv_cmd[0]='\0'; /* for error checking later */
  status_cmd[0]='\0'; /* for error checking later */
  auth_cmd[0]='\0'; /* for error checking later */
  auto_cmd[0]='\0'; /* for error checking later */
  change_cmd[0]='\0'; /* for error checking later */
  search_cmd[0]='\0'; /* for error checking later */
  Dobeep = TRUE;

  Contact_List = FALSE;
  for (; !Contact_List;)
    {
      M_fdnreadln(rcf, buf, sizeof(buf));
      if ((buf[0] != '#') && (buf[0] != 0))
	{
	  tmp = strtok(buf, " ");
	  if (! strcasecmp(tmp, "Server"))
	    {
	      strcpy(server, strtok(NULL, " \n\t"));
	    }
	  else if (! strcasecmp(tmp, "Password"))
	    {
	      strcpy(passwd, strtok(NULL, "\n\t"));
	    }
	  else if (! strcasecmp(tmp, "Russian"))
	    {
	      Russian = TRUE;
	    }
	  else if (! strcasecmp(tmp, "No_Beep"))
	    {
	      Dobeep = FALSE;
	    }
	  else if (! strcasecmp(tmp, "Sound_Player"))
	    {
	      Dosound = TRUE;
	      strcpy(&SPlayer, strtok(NULL, "\n\t"));
	    }
	  else if (! strcasecmp(tmp, "Sound_File"))
	    {
	      strcpy(&SFile, strtok(NULL, "\n\t"));
	    }
	  else if (! strcasecmp(tmp, "No_Log"))
	    {
	      Logging = FALSE;
	    }
	  else if (! strcasecmp(tmp, "UIN"))
	    {
	      UIN = atoi(strtok(NULL, " \n\t"));
	    }
	  else if (! strcasecmp(tmp, "port"))
	    {
	      remote_port = atoi(strtok(NULL, " \n\t"));
	    }
	  else if (! strcasecmp(tmp, "Status"))
	    {
	      set_status = atoi(strtok(NULL, " \n\t"));
	    }
	  else if (! strcasecmp(tmp, "message_cmd"))
	    {
	      strncpy(message_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "info_cmd"))
	    {
	      strncpy(info_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "quit_cmd"))
	    {
	      strncpy(quit_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "reply_cmd"))
	    {
	      strncpy(reply_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "again_cmd"))
	    {
	      strncpy(again_cmd, strtok(NULL, " \n\t"), 16);
	    }

	  else if (! strcasecmp(tmp, "list_cmd"))
	    {
	      strncpy(list_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "away_cmd"))
	    {
	      strncpy(away_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "na_cmd"))
	    {
	      strncpy(na_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "dnd_cmd"))
	    {
	      strncpy(dnd_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "online_cmd"))
	    {
	      strncpy(online_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "occ_cmd"))
	    {
	      strncpy(occ_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "ffc_cmd"))
	    {
	      strncpy(ffc_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "inv_cmd"))
	    {
	      strncpy(inv_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "status_cmd"))
	    {
	      strncpy(status_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "auth_cmd"))
	    {
	      strncpy(auth_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "auto_cmd"))
	    {
	      strncpy(auto_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "change_cmd"))
	    {
	      strncpy(change_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "add_cmd"))
	    {
	      strncpy(add_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "search_cmd"))
	    {
	      strncpy(search_cmd, strtok(NULL, " \n\t"), 16);
	    }
	  else if (! strcasecmp(tmp, "Contacts"))
	    {
	      Contact_List = TRUE;
	    }
	}
    }
  for (; ! M_fdnreadln(rcf, buf, sizeof(buf));)
    {
      if (Num_Contacts == 100)
	break;
      if ((buf[0] != '#') && (buf[0] != 0))
	{
	  if (isdigit((int) buf[0]))
	    {
	      Contacts[Num_Contacts].uin = atoi(strtok(buf, " "));
	      Contacts[Num_Contacts].status = STATUS_OFFLINE;
	      Contacts[Num_Contacts].last_time = -1L;
	      Contacts[Num_Contacts].current_ip = -1L;
	      tmp = strtok(NULL, "");
	      if (tmp != NULL)
		memcpy(Contacts[Num_Contacts].nick, tmp, sizeof(Contacts->nick));
	      else
		Contacts[Num_Contacts].nick[0] = 0;
	      if (Contacts[Num_Contacts].nick[19] != 0)
		Contacts[Num_Contacts].nick[19] = 0;
	      if (Verbose)
		lw_wprintw(mainw, "%ld = %s\n", Contacts[Num_Contacts].uin, Contacts[Num_Contacts].nick);
	      Num_Contacts++;
	    }
	  else
	    {
	      tmp_uin = Contacts[Num_Contacts - 1].uin;
	      tmp = strtok(buf, ", \t"); /* aliases may not have spaces */
	      for (; tmp!=NULL; Num_Contacts++)
		{
		  Contacts[Num_Contacts].uin = -tmp_uin;
		  Contacts[Num_Contacts].status = STATUS_OFFLINE;
		  Contacts[Num_Contacts].last_time = -1L;
		  Contacts[Num_Contacts].current_ip = -1L;
		  Contacts[Num_Contacts].port = 0;
		  Contacts[Num_Contacts].sok = (SOK_T) -1L;
		  memcpy(Contacts[Num_Contacts].nick, tmp, sizeof(Contacts->nick));
		  tmp = strtok(NULL, ", \t");
		}
	    }
	}
    }
  if(message_cmd[0]=='\0')
    strcpy(message_cmd, "msg");
  if(info_cmd[0]=='\0')
    strcpy(info_cmd, "info");
  if(quit_cmd[0]=='\0')
    strcpy(quit_cmd, "q");
  if(reply_cmd[0]=='\0')
    strcpy(reply_cmd, "r");
  if(again_cmd[0]=='\0')
    strcpy(again_cmd, "a");

  if(list_cmd[0]=='\0')
    strcpy(list_cmd, "w");
  if(away_cmd[0]=='\0')
    strcpy(away_cmd, "away");
  if(na_cmd[0]=='\0')
    strcpy(na_cmd, "na");
  if(dnd_cmd[0]=='\0')
    strcpy(dnd_cmd, "dnd");
  if(online_cmd[0]=='\0')
    strcpy(online_cmd, "online");
  if(occ_cmd[0]=='\0')
    strcpy(occ_cmd, "occ");
  if(ffc_cmd[0]=='\0')
    strcpy(ffc_cmd, "ffc");
  if(inv_cmd[0]=='\0')
    strcpy(inv_cmd, "inv");
  if(status_cmd[0]=='\0')
    strcpy(status_cmd, "status");
  if(add_cmd[0]=='\0')
    strcpy(add_cmd, "add");
  if(auth_cmd[0]=='\0')
    strcpy(auth_cmd, "auth");
  if(auto_cmd[0]=='\0')
    strcpy(auto_cmd, "auto");
  if(search_cmd[0]=='\0')
    strcpy(search_cmd, "search");


  if(change_cmd[0]=='\0')
    strcpy(change_cmd, "change");
  if (Verbose)
    {
      lw_wprintw(mainw, "UIN = %ld\n", UIN);
      lw_wprintw(mainw, "port = %ld\n", remote_port);
      lw_wprintw(mainw, "passwd = %s\n", passwd);
      lw_wprintw(mainw, "server = %s\n", server);
      lw_wprintw(mainw, "status = %ld\n", set_status);
      lw_wprintw(mainw, "# of contacts = %d\n", Num_Contacts);
      lw_wprintw(mainw, "UIN of contact[0] = %ld\n", Contacts[0].uin);
      lw_wprintw(mainw, "Message_cmd = %s\n", message_cmd);
    }
}

/*******************************************************
Gets config info from the rc file in the users home
directory.
********************************************************/
void Get_Unix_Config_Info(void)
{
  char pathact[1024];
  char *path = &pathact;
  char *temp;
  FD_T rcf;

#ifdef _WIN32
  path = ".\\";
#endif

#ifdef UNIX
  temp = getenv("HOME");
  strcpy(pathact, temp);
  strcat(path, "/");
#endif

#ifdef __amigaos__
  path = "PROGDIR:";
#endif

  strcpy(rcfile, path);
  strcat(rcfile, ".zicqrc");
  rcf = open(rcfile, O_RDONLY);
  if (rcf == -1)
    {
      if (errno == ENOENT) /* file not found */
	{
	  Initalize_RC_File();
	}
      else
	{
	  perror("Error reading config file exiting ");
	  endwin();
	  exit(1);
	}
    }
  else
    {
      Read_RC_File(rcf);
    }
}

void Print_IP(DWORD uin)
{
  int i;
  DWORD t;
      
  for (i=0; i< Num_Contacts; i++)
    {
      if (Contacts[i].uin == uin)
	{
	  if (Contacts[i].current_ip != -1L)
	    {
	      t = Contacts[i].current_ip;
	      if (Int_End)
		lw_wprintw(mainw, "%u.%u.%u.%u", (BYTE) (t>>24), (BYTE) (t>>16), (BYTE) (t>>8), (BYTE) (t));
	      else
		lw_wprintw(mainw, "%u.%u.%u.%u", (BYTE) (t), (BYTE) (t>>8), (BYTE) (t>>16), (BYTE) (t>>24));
	    }
	  else
	    {
	      lw_wprintw(mainw, "unknown");
	    }
	  return;
	}
    }
  lw_wprintw(mainw, "unknown");
}

/************************************************
Gets the TCP port of the specified UIN
************************************************/
char* Get_Nick (DWORD uin)
{
  int i;
  for (i=0; i < Num_Contacts; i++)
    {
      if (Contacts[i].uin == uin)
	return (char*) Contacts[i].nick;
    }
  return (char*) "Unknown";
}

DWORD Get_IP (DWORD uin)
{
  int i;

  for (i=0; i< Num_Contacts; i++)
    {
      if (Contacts[i].uin == uin)
	{
	  return Contacts[i].current_ip;
	}
    }
  return -1L;
}


DWORD Get_Port(DWORD uin)
{
  int i;
      
  for (i=0; i< Num_Contacts; i++)
    {
      if (Contacts[i].uin == uin)
	{
	  return Contacts[i].port;
	}
    }
  return -1L;
}

/********************************************
Converts an intel endian character sequence to
a DWORD
*********************************************/
DWORD Chars_2_DW(unsigned char *buf)
{
  DWORD i;

  i= buf[3];
  i <<= 8;
  i+= buf[2];
  i <<= 8;
  i+= buf[1];
  i <<= 8;
  i+= buf[0];

  return i;
}

/********************************************
Converts an intel endian character sequence to
a WORD
*********************************************/
WORD Chars_2_Word(unsigned char *buf)
{
  WORD i;

  i= buf[1];
  i <<= 8;
  i += buf[0];

  return i;
}

/********************************************
Converts a DWORD to
an intel endian character sequence
*********************************************/
void DW_2_Chars(unsigned char *buf, DWORD num)
{
  buf[3] = (unsigned char) ((num)>>24)& 0x000000FF;
  buf[2] = (unsigned char) ((num)>>16)& 0x000000FF;
  buf[1] = (unsigned char) ((num)>>8)& 0x000000FF;
  buf[0] = (unsigned char) (num) & 0x000000FF;
}

/********************************************
Converts a WORD to
an intel endian character sequence
*********************************************/
void Word_2_Chars(unsigned char *buf, WORD num)
{
  buf[1] = (unsigned char) (((unsigned)num)>>8) & 0x00FF;
  buf[0] = (unsigned char) ((unsigned)num) & 0x00FF;
}

void Prompt(void)
{
  /* printf(SERVCOL "Zicq> " NOCOL); */

  /* waddstr(userin, SERVCOL "\n\nZicq>" NOCOL); */
  Show_Quick_Status();
  zwinfix();
  fflush(stdout);
}

void Time_Stamp(void)
{
  struct tm *thetime;
  time_t p;
      
  p=time(NULL);
  thetime=localtime(&p);

  lw_wprintw(mainw, "%.02d:%.02d:%.02d", thetime->tm_hour, thetime->tm_min, thetime->tm_sec);
}

void Add_User(SOK_T sok, DWORD uin, char *name)
{
  FD_T rcf;

  rcf = open(rcfile, O_RDWR | O_APPEND);
  M_fdprint(rcf, "%d %s\n", uin, name);
  close(rcf);
  Contacts[Num_Contacts].uin = uin;
  Contacts[Num_Contacts].status = STATUS_OFFLINE;
  Contacts[Num_Contacts].last_time = -1L;
  Contacts[Num_Contacts].current_ip = -1L;
  Contacts[Num_Contacts].port = 0;
  Contacts[Num_Contacts].sok = (SOK_T) -1L;
  memcpy(Contacts[Num_Contacts].nick, name, sizeof(Contacts->nick));
  Num_Contacts++;
  snd_contact_list(sok);
}

/*************************************************************************
 *
 *      Function: log_event
 *
 *      Purpose: Log the event provided to the log with a time stamp.
 *      Andrew Frolov dron@ilm.net
 *************************************************************************/

int log_event(char *desc, char *msg, DWORD uin)
{
  FILE    *msgfd;
  FILE	   *msgfd2;
  char    buffer[1024];
  char	   buffer2[1024];
  time_t  timeval;
  char *path;
  char tmp[20];

  if (uin == UIN)
    return 0;

  if (! Logging)
    return 0;

#ifdef _WIN32
  path = ".\\";
#endif

#ifdef UNIX
  path = getenv("HOME");
#endif

#ifdef __amigaos__
  path = "PROGDIR:";
#endif

  strcpy(buffer, path);
  strcpy(buffer2, path);
  strcat(buffer, "/.zicq/zicq_log");
  sprintf(&tmp, "/.zicq/.zicq-%ld", uin);

  /* strcat(buffer2, "/system"); */
  strcat(buffer2, &tmp);

  if(((msgfd = fopen(buffer, "a")) == (FILE *) NULL) || ((msgfd2 = fopen(buffer2, "a")) == (FILE *) NULL))
    {
      fprintf(stderr, "Couldn't open %s for logging\n",
	      buffer);
      return(-1);
    }
  timeval = time(0);
  fprintf(msgfd2, "\n%-24.24s %s %ld (%s)\n%s\n", ctime(&timeval), desc, uin, Get_Nick(uin), msg);
  fprintf(msgfd, "\n%-24.24s %s %ld (%s)\n%s\n", ctime(&timeval), desc, uin, Get_Nick(uin), msg);
  fclose(msgfd);
  fclose(msgfd2);

#ifdef UNIX
  chmod(buffer, 0600);
  chmod(buffer2, 0600);
#endif

#if 0
  strcpy(buffer2, path);
  sprintf(tmp, "");
  sprintf(tmp, "/.zicq/.zicq-%ld", uin);
  strcat(buffer2, tmp);
  lw_wprintw(mainw, "\nBuffer2: %s\n", buffer2);

  if((msgfd = fopen(buffer2, "a")) == (FILE *) NULL)
    {
      fprintf(stderr, "Couldn't open %s for logging\n",
	      buffer2);
      return(-1);
    }
  timeval = time(0);
  fprintf(msgfd, "\n%-24.24s %s %ld (%s)\n%s\n", ctime(&timeval), desc, uin, Get_Nick(uin), msg);
  fclose(msgfd);
#endif

  return(0);
}

void clrscr(void)
{
  /* clears the screen */
  int x;
  char newline = '\n';
  for(x = 0; x<=LINES; x++)
    wprintw(mainw, "%c", newline);
}
