/* ===================================================================
 * 	xtelld.h
 *
 *
 * ================================================================ */

#ifndef XTELL_H_
#define XTELL_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
  
#include <pwd.h>
#include <syslog.h>
 
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/time.h>
 
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <utmp.h>

#include "config.h"

/* ==================================================================
 * GLOBALS
 * ==================================================================
 */
	/* SERVICE BEHAVIOR     */
unsigned char   resolve_addr;		/* reverse lookup addresses	*/
unsigned short	max_connections;	/* maximum number of open connections */
unsigned short	client_timeout;		/* number of seconds till disconnect */
unsigned int xtell_port;

/* ==================================================================
 * PROTOTYPES:
 * ==================================================================
 */

/* #### XTELLD.C #### */
void    killsock (int);
int     get_ports (char[], u_short *, u_short *);
void    client_reply (int, char *);


/* #### CHILD.C #### */
extern void xtell_killtic (int);
extern void inetd_child (int, int);
void inetd_service (int sd_in, int sd_out);

/* #### DAEMON.C #### */
void	daemon_service (void);


/* #### TTY.C #### */
int parse_and_write(char *s, char *identity, char *addr, unsigned int msgcount);

/* commonn.c */
FILE *logFILE(const char *fromluser);
short int	get_request (int d, char buffer[], unsigned short int len);


#ifdef BEOS
# define PF_INET AF_INET
#endif
	  
#endif /* WHOLE FILE */
