/*
 * Copyright (c) 1997 Loughborough University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the LUTCHI Research
 *      Centre at Loughborough University.
 * 4. Neither the name of the University nor of the Centre may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/*
 *  File: wb.h
 *
 *  Description: Whiteboard packet definitions.
 *
 *  J.C.Highfield, 3/97.
 *
 */

#ifndef WB_H
#define WB_H

typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned long  uint32;

typedef float real32;

/*
 * Based on data from:
 * <http://www.it.kth.se/~d90-lra/wb-proto.html>
 *
 */


/**********************/
/* The packet header. */
/**********************/
struct wb_packet
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	/*uint8  pk_data[1];*/
};


/********************/
/* Packet flavours. */
/********************/
enum
{
	PK_SESSION  = 0x00000100,
	PK_REQ_DRAW = 0x00000200,
	PK_REQ_DRAX = 0x00000202,
	PK_ASK_PAGE = 0x00000500,
	PK_PAGE_RPT = 0x00000700,
	PK_DRAW_MSG = 0x00000001,
	PK_RPY_DRAW = 0x00000300
};


struct writer_desc
{
	uint32 writer_ip;
	uint32 write_count;
};

struct pk_session
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	uint32 page_count;
	uint32 last_page_ip;
	uint32 last_page_num;
	uint32 page_num;
	uint32 current_page_ip;
	uint32 current_page_num;
/* Receive report. */
	uint16 active;
	uint16 dummy;
	/*struct writer_desc writer;*/
/* Followed by a string. */
};


struct pk_req_draw
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	uint32 drawer_ip;
	uint32 page_ip;
	uint32 page_num;
	uint32 first_cmd;
	uint32 last_cmd;
};


struct pk_ask_page
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	uint32 page_ip;
	uint32 page_num;
	uint32 page_index;
	uint32 d2;
};


struct page_desc
{
	uint32 page;   /* Same as page_num? */
	uint32 page_id;
	uint32 page_num;
	uint16 active;
	uint16 dummy;
	/*struct writer_desc writer[1];*/
};

struct pk_page_rpt
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	uint32 count;
};


struct pk_draw_msg
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	uint32 page_ip;
	uint32 page_num;
	uint32 draw_cmds_local;
	uint32 draw_cmd_num;
	uint32 draw_timestamp;
	uint16 draw_cmd_length;
	uint16 draw_cmd;
	/*uint8  draw_msg[1];*/
};


struct pk_rpy_draw
{
	uint32 sender;
	uint32 timestamp;
	uint32 pk_type;
	uint32 drawer_ip;
	uint32 page_ip;
	uint32 page_num;
	uint32 first_cmd;
	uint32 last_cmd;
	/*uint8  draw_pk[1];*/
};


/* Used when interpreting pk_draw_rpy. */
struct pk_draw_hdr
{
	uint32 draw_timestamp;
	uint16 draw_cmd_length;
	uint16 draw_cmd;
	/*uint8  draw_msg[1];*/
};



/******************/
/* Draw flavours. */
/******************/
enum
{
	DRW_RECT      = 0x0002,
	DRW_LINE      = 0x0003,
	DRW_GRP_LINES = 0x0004,
	DRW_DEL       = 0x0005,
	DRW_COPY      = 0x0006,
	DRW_OVAL      = 0x0007,
	DRW_CHR       = 0x0008,
	DRW_GRP_TEXT  = 0x0009,
	DRW_PS        = 0x000B,
	DRW_GRP_PS    = 0x000C,
	DRW_CLONE_GRP = 0x000D,
	DRW_NEW_PG    = 0x0010
};


/*****************************/
/* Draw message definitions. */
/*****************************/

/* DRW_RECT */
struct drw_rect
{
	real32 linestyle;
	uint32 colour;
	uint32 fill;
	real32 from_x;
	real32 from_y;
	real32 to_x;
	real32 to_y;
};

/* DRW_LINE */
struct drw_line
{
	real32 linestyle;
	uint32 colour;
	real32 from_x;
	real32 from_y;
	real32 to_x;
	real32 to_y;
};

/* DRW_GRP_LINES */
struct drw_grp_lines
{
	uint32 first_cmd;
	uint32 last_cmd;
};

/* DRW_DEL */
struct drw_del
{
	uint32 first_cmd;
	uint32 last_cmd;
};

/* DRW_COPY */
struct drw_copy
{
	uint32 cmd_id;
	real32 d1;
	real32 d2;
	real32 d3;
	real32 d4;
	real32 to_x;
	real32 to_y;
};

/* DRW_OVAL */
struct drw_oval
{
	uint32 colour;
	real32 linestyle;
	uint32 fill;
	real32 center_x;
	real32 center_y;
	real32 width;
	real32 height;
};

/* DRW_CHR */
struct drw_chr
{
	uint16 ascii;
	uint16 orientation;
	uint32 colour;
	real32 where_x;
	real32 where_y;
	uint32 font;
};

/* DRW_GRP_TEXT */
struct drw_grp_text
{
	uint32 first_cmd;
	uint32 last_cmd;
};

/* DRW_PS */
struct drw_ps
{
	uint8 bytes[1];
};

/* DRW_GRP_PS */
struct drw_grp_ps
{
	uint32 d1;
	uint32 first_cmd;
	uint32 last_cmd;
};

/* DRW_CLONE_GRP */
struct drw_clone_grp
{
	uint32 page_id;
	uint32 who;
	uint32 cmd_id;
};

/* DRW_NEW_PG */
struct drw_new_pg
{
	uint8 name[1];
};


enum
{
    NO_ERR         = 0,
    ERR_BAD_PACKET = -1
};


/* Font encoding. */
/*
struct fontnames[]
{
    "helvetica",
    "courier",
    "times",
    "symbol",
    "new century schoolbook",
    "lucida",
    "lucidabright",
    "lucidatypewriter",
    "palatino",
    "utopia",
    "itc zapf chancery",
    "itc zapf dingbats",
    "itc bookman",
    "itc avant garde gothic",
    NULL
};

struct fontstyles[]
{
    "medium",
    "ultralight",
    "extralight",
    "light",
    "book",
    "demibold",
    "bold",
    "extrabold",
    "ultrabold",
    "semibold",
    "demi",
    "regular",
    "normal",
    "ultracondensed",
    "extracondensed",
    "condensed",
    "semicondensed",
    "semiexpanded",
    "expanded",
    "wide",
    "extrawide",
    "narrow",
    "Helvetica-Bold",
    "Helvetica-BoldOblique",
    "Times-Roman",
    NULL
};
*/
#endif
/* Trigger value for limiting packet sizes. */
#define PK_TRIGGER_SIZE	900

/* Dimensions of the abstract page. */
#define PAGE_WIDTH	612
#define PAGE_HEIGHT	792

