/*
 * tnmUnixLog.c --
 *
 *	UNIX specific functions to write to the syslog facility.
 *
 * Copyright (c) 1993-1996 Technical University of Braunschweig.
 * Copyright (c) 1996-1997 University of Twente.
 * Copyright (c) 1997-1999 Technical University of Braunschweig.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tnmInt.h"
#include "tnmPort.h"

#include <syslog.h>


/*
 *----------------------------------------------------------------------
 *
 * TnmWriteLogMessage --
 *
 *	This procedure is invoked to write a message to the UNIX 
 *	syslog facility.
 *
 * Results:
 *	0 on success and -1 on failure.
 *
 * Side effects:
 *	A message is written to the syslog facility.
 *
 *----------------------------------------------------------------------
 */

int
TnmWriteLogMessage(ident, level, message)
    char *ident;
    int level;
    char *message;
{
    switch (level) {
      case TNM_LOG_EMERG:
	level = LOG_EMERG; 
	break;
      case TNM_LOG_ALERT:
	level = LOG_ALERT;
	break;
      case TNM_LOG_CRIT:
	level = LOG_CRIT;
	break;
      case TNM_LOG_ERR:
	level = LOG_ERR;
	break;
      case TNM_LOG_WARNING:
	level = LOG_WARNING;
	break;
      case TNM_LOG_NOTICE:
	level = LOG_NOTICE;
	break;
      case TNM_LOG_INFO:
	level = LOG_INFO;
	break;
      case TNM_LOG_DEBUG:
	level = LOG_DEBUG;
	break;
      default:
	return -1;
    }

    if (! ident) {
	ident = "scotty";
    }

    if (message != NULL) {
#ifdef ultrix
	openlog(ident, LOG_PID);
#else
	openlog(ident, LOG_PID, LOG_USER);
#endif
	syslog(level, message);
	closelog();
    }

    return 0;
}
