'\"
'\" Copyright (c) 1994-1996 Technical University of Braunschweig.
'\" Copyright (c) 1996-1997 University of Twente.
'\" Copyright (c) 1997-1998 Technical University of Braunschweig.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.so man.macros
.TH Tnm::netdb n "March 1998" Tnm "Tnm Tcl Extension"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Tnm::netdb \- Access local network databases.
.BE

.SH DESCRIPTION
The Tnm::netdb command provides access to network information that is
stored in configuration files, the Network Information Service (NIS)
or in the Domain Name System (DNS). The results of the Tnm::netdb
command usually depend on the local configuration of your operating
system.

.SH NETDB COMMAND
.TP 
\fBTnm::netdb hosts\fR
.ns
.TP 
\fBTnm::netdb hosts name \fIaddress\fR
.ns
.TP
\fBTnm::netdb hosts address \fIname\fR
.ns
.TP
\fBTnm::netdb hosts aliases \fIaddress\fR
The first version of the \fBTnm::netdb hosts\fR command returns a list
of all locally known hosts. Each element of this list contains a host
name and its IP address. The result is an empty list on many systems
that are configured to use the DNS for hostname lookups.  The second
version of the \fBTnm::netdb hosts\fR command converts an IP \fIaddress\fR
into a host name and the third version of the \fBTnm::netdb hosts\fR
command converts a host \fIname\fR into an IP address. The fourth
version of the \fBTnm::netdb hosts\fR command returns a list of all 
known aliases for an IP \fIaddress\fR.
.TP 
\fBTnm::netdb networks\fR
.ns
.TP 
\fBTnm::netdb networks name \fIaddress\fR
.ns
.TP
\fBTnm::netdb networks address \fIname\fR
.ns
.TP
\fBTnm::netdb networks aliases \fIaddress\fR
The first version of the \fBTnm::netdb networks\fR command returns a
list of all locally known networks. Each element of this list contains
a network name and the IP network address. The second version of the
\fBTnm::netdb networks\fR command returns the network name that
belongs to the IP network \fIaddress\fR and the third version of the
\fBTnm::netdb networks\fR command returns the network address that
belongs to a given network \fIname\fR. The fourth version of the
\fBTnm::netdb networks\fR command returns a list of all known aliases
for an IP \fIaddress\fR.
.TP 
\fBTnm::netdb protocols\fR
.ns
.TP 
\fBTnm::netdb protocols name \fInumber\fR
.ns
.TP
\fBTnm::netdb protocols number \fIname\fR
.ns
.TP
\fBTnm::netdb protocols aliases \fInumber\fR
The first version of the \fBTnm::netdb protocols\fR command returns a
list of all locally known Internet protocols. Each element of this
list contains a protocol name and its protocol number. The second
version of the \fBTnm::netdb protocols\fR command returns the protocol
name that belongs to \fInumber\fR and the third version of the
\fBTnm::netdb protocols\fR command returns the protocol number that
belongs to a protocol \fIname\fR. The fourth version of the
\fBTnm::netdb protocols\fR command returns a list of all known aliases
for a protocol \fInumber\fR.
.TP
\fBTnm::netdb services\fR
.ns
.TP
\fBTnm::netdb services name \fInumber\fR \fIprotocol\fR
.ns
.TP
\fBTnm::netdb services number \fIname\fR \fIprotocol\fR
.ns
.TP
\fBTnm::netdb services aliases \fInumber\fR \fIprotocol\fR 
The first version of the \fBTnm::netdb services\fR command returns the
list of all locally known services. Each element of this list contains
a service name, the service number and the transport protocol. The
second version of the \fBTnm::netdb services\fR command returns the
service name for the service described by \fInumber\fR and
\fIprotocol\fR. The third version of the \fBTnm::netdb services\fR
command returns the protocol number for the service described by
\fIname\fR and \fIprotocol\fR. The fourth version of the \fBTnm::netdb
services\fR command returns a list of all known aliases for a given
service \fInumber\fR and \fIprotocol\fR.
.TP 
\fBTnm::netdb sunrpcs\fR
.ns
.TP 
\fBTnm::netdb sunrpcs name \fInumber\fR
.ns
.TP
\fBTnm::netdb sunrpcs number \fIname\fR
.ns
.TP 
\fBTnm::netdb sunrpcs aliases \fInumber\fR
The first version of the \fBTnm::netdb sunrpcs\fR command lists all
locally known Sun RPCs. Each element of this list contains a RPC name
and its registration number. The second version of the \fBTnm::netdb
sunrpcs\fR command returns the RPC name for a given RPC \fInumber\fR
and the third version of the \fBTnm::netdb sunrpcs\fR command returns
the RPC number for a given RPC \fIname\fR. The fourth version of the
\fBTnm::netdb sunrpcs\fR command returns a list of all known aliases
for a given RPC \fInumber\fR.
.TP
\fBTnm::netdb ip apply \fIaddress\fR \fImask\fR
.ns
.TP
\fBTnm::netdb ip broadcast \fIaddress\fR \fImask\fR
.ns
.TP
\fBTnm::netdb ip class \fIaddress\fR
.ns
.TP
\fBTnm::netdb ip compare \fImask\fR \fImask\fR
.ns
.TP
\fBTnm::netdb ip range \fIaddress mask\fR
The first version of the \fBTnm::netdb ip\fR command applies the
\fImask\fR to the \fIaddress\fR and returns the resulting subnet.  The
\fBTnm::netdb ip broadcast\fR command applies the \fImask\fR to the
\fIaddress\fR and returns the resulting broadcast address. The
\fBnetdb ip class\fR command returns the IP class of the \fIaddress\fR
argument. The following classes are recognized: A, B, C, D and
loopback. The \fBTnm::netdb ip compare\fR command compares two masks
and returns -1, 0 or 1, depending on whether the first mask is
smaller, equal or greater than the second mask. The \fBTnm::netdb ip
range\fR command returns the list of IP addresses in the address range
given by \fIaddress\fR and \fImask\fR.

.SH SEE ALSO
scotty(1), Tnm(n), Tcl(n)

.SH AUTHORS
Juergen Schoenwaelder <schoenw@ibr.cs.tu-bs.de>
.br
