#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/stat.h>

#include <config.h>
#include <support.h>

#include <console.h>
#include <log.h>

/*
#define	DEBUG	1
*/

#define	UDP_DOMAIN	53
#define	TIMEOUT_ANSWER	15
#define	TIMEOUT_REQUEST	2

static char *resolvBackup;

static void
DoRelay(struct in_addr *dns)
{
    struct reslink_s {
	struct reslink_s *next;
	struct sockaddr_in sk;
	time_t wait_time;
	enum {DNS_REQUEST, DNS_ANSWER} wait_for;
	u_int16_t id;
    } *reshp=NULL, *lp, *lp0;
    int n, sd, rd;
    size_t len;
    fd_set rfds;
    struct sockaddr_in sk, rk;
    struct timeval tv;
    u_int16_t id;
    char buf[BUFSIZ];

    memset(&sk, 0, sizeof(sk));
    if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	LogError("DnsRelay service socket");
	exit(1);
    }
    sk.sin_family = AF_INET;
    sk.sin_port = htons(UDP_DOMAIN);
    sk.sin_addr.s_addr = INADDR_ANY;
    if (bind(sd, (struct sockaddr *)&sk, sizeof(sk)) < 0) {
	LogError("DnsRelay bind");
	exit(1);
    }
    if ((rd = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	LogError("DnsRelay relay socket");
	exit(1);
    }
    memset(&rk, 0, sizeof(rk));
    rk.sin_family = AF_INET;
    rk.sin_port = htons(UDP_DOMAIN);
    rk.sin_addr.s_addr = dns[0].s_addr;

    tv.tv_sec = 1; tv.tv_usec = 0;
    while (1) {
	FD_ZERO(&rfds);
	FD_SET(sd, &rfds);
	FD_SET(rd, &rfds);
	switch(select(rd + 1, &rfds, NULL, NULL, &tv)) {
	case 0:
	    tv.tv_sec = 1;
	    tv.tv_usec = 0;
	    lp = reshp;
	    lp0 = NULL;
	    while (lp) {
		lp->wait_time ++;
		if (lp->wait_time > (lp->wait_for == DNS_ANSWER
		    ? TIMEOUT_ANSWER: TIMEOUT_REQUEST)) {
		    struct reslink_s *tmp=lp->next;

#ifdef DEBUG
		    fprintf(stderr, "free(%04x) %s\n",
			    lp->id, inet_ntoa(lp->sk.sin_addr));
#endif
		    if (lp0) lp0->next = tmp;
		    else reshp = tmp;
		    free(lp);
		    lp = tmp;
		    continue;
		}
		lp0 = lp;
		lp = lp->next;
	    }
	    break;
	case -1:
	    continue;
	}
	if (FD_ISSET(sd, &rfds)) {
	    len = sizeof(sk);
	    n = recvfrom(sd, buf, sizeof(buf), 0,
			 (struct sockaddr *)&sk, &len);
	    memcpy(&id, buf, 2);
	    lp = reshp;
	    while (lp) {
		if (lp->id == id) break;
		lp = lp->next;
	    }
	    if (!lp) {
		lp = (struct reslink_s *)malloc(sizeof(*lp));
		memset(lp, 0, sizeof(*lp));
		lp->next = reshp;
		reshp = lp;
		memcpy(&lp->sk, &sk, sizeof(sk));
		lp->id = id;
	    }
	    lp->wait_for = DNS_ANSWER;
	    lp->wait_time = 0;
#ifdef DEBUG
	    fprintf(stderr, "service(%04x) %s %d\n", lp->id,
		    inet_ntoa(rk.sin_addr), n);
#endif
	    sendto(rd, buf, n, 0, (struct sockaddr *)&rk, sizeof(rk));
	}
	if (FD_ISSET(rd, &rfds)) {
	    len = sizeof(rk);
	    n = recvfrom(rd, buf, sizeof(buf), 0,
			 (struct sockaddr *)&rk, &len);
	    memcpy(&id, buf, 2);
	    lp = reshp;
	    while (lp) {
		if (lp->id == id) break;
		lp = lp->next;
	    }
	    if (lp) {
		lp->wait_for = DNS_REQUEST;
		lp->wait_time = 0;
#ifdef DEBUG
		fprintf(stderr, "relay(%04x) %s %d\n", lp->id,
			inet_ntoa(lp->sk.sin_addr), n);
#endif
		sendto(sd, buf, n, 0, (struct sockaddr *)&lp->sk,
		       sizeof(lp->sk));
	    }
	}
	tv.tv_usec = 0;
    }
}

void
DnsRelay(struct in_addr *dns)
{
    static pid_t relayPid;

    if (relayPid > 0) {
	kill(relayPid, SIGQUIT);
	relayPid = 0;
    }
    if (!dns) return;
    if ((relayPid = fork()) == 0) {
	static void SigQuit(int sig) {
	    exit(0);
	}

	SuperPrivilege(TRUE);
	SetProcTitle("(dns relay)");
	signal(SIGQUIT, SigQuit);
	DoRelay(dns);
	exit(0);
    } else if (relayPid == -1) {
	LogError("DnsRelay fork");
    }
}

void
DnsRestoreConf()
{
    if (!resolvBackup) return;
    SuperPrivilege(TRUE);
    unlink(_PATH_RESCONF);
    if (*resolvBackup) {
      rename(resolvBackup, _PATH_RESCONF);
      Free(resolvBackup);
    }
    SuperPrivilege(FALSE);
    resolvBackup = NULL;
}

int
DnsSetupConf(char *domain, struct in_addr dns[], int max)
{
    FILE *fp;
    int n;
    char backup[sizeof(_PATH_RESCONF)+10];

    sprintf(backup, _PATH_RESCONF".ppxp%04x", getpid());
    SuperPrivilege(TRUE);
    if (!resolvBackup || !*resolvBackup) {
	unlink(backup);
	if (rename(_PATH_RESCONF, backup) < 0) {
	  if (access(_PATH_RESCONF, R_OK)) resolvBackup = "";
	  else resolvBackup = NULL;
	} else resolvBackup = Strdup(backup);
    }
    unlink(_PATH_RESCONF);
    if ((fp = fopen(_PATH_RESCONF, "w")) != NULL) {
	chown(_PATH_RESCONF, 0, 0);
	chmod(_PATH_RESCONF, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
    }
    SuperPrivilege(FALSE);
    if (fp == NULL) {
	LogError(_PATH_RESCONF);
	DnsRestoreConf();
	return(-1);
    }
    if (domain && *domain) fprintf(fp, "search %s\n", domain);
    for (n = 0; n < max; n ++) if (dns[n].s_addr)
	fprintf(fp, "nameserver %s\n", inet_ntoa(dns[n]));
    fclose(fp);
    return(0);
}
