#
#
#
#

set lframe_proc(label)		lframe:label
set lframe_proc(button)		lframe:button
set lframe_proc(checkbutton)	lframe:checkbutton
set lframe_proc(radiobutton)	lframe:radiobutton
set lframe_proc(subwidget)	lframe:subwidget

Widget:DefineClass LabelFrame {} lframe:create lframe:config lframe_proc

option add *LabelFrame.frame.background		\#d9d9d9
option add *LabelFrame.frame.foreground		black
option add *LabelFrame.border.background	\#d9d9d9
option add *LabelFrame.border.foreground	black
option add *LabelFrame.border.borderWidth	2
option add *LabelFrame.border.relief		groove

proc lframe:create {w a} {
    frame $w.frame
    frame $w.border -relief groove -borderwidth 2

    grid $w.frame  -row 3 -rowspan 1 -column 1 -columnspan 3 -sticky ewns
    grid $w.border -row 1 -rowspan 4 -column 0 -columnspan 5 -sticky ewns

    grid columnconfigure $w 0 -weight 0 -minsize 10
    grid columnconfigure $w 1 -weight 0
    grid columnconfigure $w 2 -weight 0
    grid columnconfigure $w 3 -weight 1
    grid columnconfigure $w 4 -weight 0 -minsize 10
    grid rowconfigure $w 0 -weight 0
    grid rowconfigure $w 1 -weight 0
    grid rowconfigure $w 2 -weight 0 -minsize 4
    grid rowconfigure $w 3 -weight 1
    grid rowconfigure $w 4 -weight 0 -minsize 10

    raise $w.frame $w.border

    return $w
}

proc lframe:place_label {w label} {
    global lframe_conf

    set lframe_conf($w,label) $label
    grid $label -in $w -row 0 -rowspan 2 -column 2 -columnspan 1 -sticky n
}

proc lframe:config {w o v} {
    global lframe_conf

    switch -- $o {
	-label {
	    lframe:place_label $w $v
	}
	-background {
	    $w.label configure -background $v
	    $w.frame configure -background $v
	    $w.border configure -background $v
	}
	-foreground {
	    $w.label configure -foreground $v
	}
	-borderwidth {
	    $w.border configure -borderwidth $v
	}
	-relief {
	    $w.border configure -relief $v
	}
	-padx {
	    grid columnconfigure $w 0 -minsize $v
	    grid columnconfigure $w 4 -minsize $v
	}
	-pady {
	    grid rowconfigure $w 4 -minsize $v
	    catch {
		set label $lframe_conf($w,label)
		set h [expr [winfo reqheight $w.label]/2]
		if {$h < $v} {
		    grid rowconfigure $w 2 -minsize $v
		}
	    }
	}
	default {
	    return 1
	}
    }
    return 0
}

proc lframe:set_label {w a cmd} {
    set label [eval $cmd $a]
    lframe:place_label $w $label
}

proc lframe:label {w a} {
    lframe:set_label $w $a label
}

proc lframe:button {w a} {
    lframe:set_label $w $a button
}

proc lframe:checkbutton {w a} {
    lframe:set_label $w $a checkbutton
}

proc lframe:radiobutton {w a} {
    lframe:set_label $w $a radiobutton
}

proc lframe:subwidget {w a} {
    switch $a {
	frame   {return $w.frame}
	label   {return $w.label}
	border  {return $w.border}
	default {return {}}
    }
}

proc lframe:test {} {
    LabelFrame .f1
    .f1 label .f1.label -text "aho"
    set f [.f1 subwidget frame]
    button $f.b -text "baka" -command {puts baka}
    label $f.l -text "doryaaaa"
    pack $f.b $f.l

    LabelFrame .f2
    .f2 checkbutton .f2.checkbutton -text "CheckButton"
    set f [.f2 subwidget frame]
    $f configure -background blue
    button $f.b -text "aaaaaaaaaaaaaa"
    label $f.l -text "bbbbbbbbb"
    pack $f.b $f.l

    pack .f1 .f2 -side left -fill both -expand yes
}
