foreach i $argv {
    set l [split $i "="]
    set var [lindex $l 0]
    if {[llength $l] > 1} {
	set val [lindex $l 1]
    } else {
	set val {}
    }
    set $var $val
}

proc msg_checking {s} {
    puts -nonewline stderr "checking $s... "
    flush stderr
}

proc msg_result {v} {
    upvar $v var
    if [catch {puts stderr $var}] {
	puts stderr ""
    }
}

msg_checking "for tcl version"
set TclVersion $tcl_version
msg_result TclVersion


if {[info commands kanji] == "kanji"} {
    set TclL10N "jp"
} else {
    set TclL10N ""
}
set TclLibrary	$tcl_library
set TclName	[file tail $tcl_library]
set TclLibDir	[file dirname $tcl_library]
set TclPrefix	[file dirname $TclLibDir]

msg_checking "whether tclsh supports dynamic loading"
catch {load dummy} msg
if [regexp {not currently available} $msg] {
    set TclLoadSupport "no"
} else {
    set TclLoadSupport "yes"
}
msg_result TclLoadSupport

proc checkheader { dir ver } {
    global CC CPPFLAGS

    set pid [pid]
    set tmpdir "tmp-config.tcl-$pid"
    catch {exec mkdir $tmpdir}

    set src [file join . $tmpdir test.c]
    set exe [file join . $tmpdir test]

    set f [open $src w]
    puts $f "
#include <string.h>
#include <tcl.h>
void main(){exit(strcmp(TCL_VERSION,\"$ver\"));}
"
    close $f

    catch {eval "exec $CC -I$dir $CPPFLAGS $src -o $exe"}
    if [catch {exec $exe}] {
	set result 0
    } else {
	set result 1
    }
    catch {exec rm -rf $tmpdir}
    return $result
}

set dirs [split $tcl_includes ":"]

set TclIncFlags {}
if {[llength $dirs] > 0} {
    foreach i $dirs {
	set TclIncFlags "$TclIncFlags -I$i"
    }
} else {
    set dirs [list \
		  "$TclPrefix/include/$TclName" \
		  "$TclPrefix/include/tcl" \
		  "$TclPrefix/include"]
    msg_checking "for tcl header include path"
    foreach i $dirs {
	if [file exists [file join $i tcl.h]] {
	    if [checkheader $i $tcl_version] {
		set TclIncFlags "$TclIncFlags -I$i"
	    }
	}
    }
    msg_result TclIncFlags
}

msg_checking "for tcl auto loading path"
set TclAutoDir [lindex $auto_path 0]
msg_result TclAutoDir

msg_checking "for shared library extension"
set TclShlibSuffix [info sharedlibextension]
msg_result TclShlibSuffix

set dirs [list $TclLibrary $TclLibDir]
if {$tcl_config != ""} {
    set TclConfig $tcl_config
} else {
    set TclConfig {}
    msg_checking "for tclConfig.sh"
    foreach i $dirs {
	if [file exists [file join $i tclConfig.sh]] {
	    set TclConfig [file join $i tclConfig.sh]
	    break
	}
    }
    msg_result TclConfig
}

if {$tcl_shared == "yes" && $TclLoadSupport == "yes"} {
    puts "TCL_BUILD=dynamic;"
    puts "TCL_SHLIB_SUFFIX=$TclShlibSuffix;"
    puts "TCL_AUTO_DIR=$TclAutoDir;"
} elseif {$TclConfig != ""} {
    puts "TCL_BUILD=static;"
    puts ". $TclConfig;"
}
puts "TCL_INC_FLAGS=\"$TclIncFlags\";"

if {![info exists tk_version]} {
    exit
}

######################################################################

msg_checking "for tk version"
set TkVersion	$tk_version
msg_result TkVersion

set TkLibrary	$tk_library
set TkName	[file tail $tk_library]
set TkLibDir	[file dirname $tk_library]

set dirs [list \
	      "$TclPrefix/include/$TkName" \
	      "$TclPrefix/include/tcl" \
	      "$TclPrefix/include/tk" \
	      "$TclPrefix/include"]
if {$tcl_includes == ""} {
    foreach i $dirs {
	if [file exists [file join $i tk.h]] {
	    if [checkheader $i $tk_version] {
		set TclIncFlags "$TclIncFlags -I$i"
	    }
	}
    }
}

set dirs [list $TkLibrary $TkLibDir]
if {$tk_config != ""} {
    set TkConfig $tk_config
} else {
    msg_checking "for tkConfig.sh"
    set TkConfig {}
    foreach i $dirs {
	if [file exists [file join $i tkConfig.sh]] {
	    set TkConfig [file join $i tkConfig.sh]
	    break
	}
    }
    msg_result TkConfig
}

if {($tcl_shared != "yes" || $TclLoadSupport != "yes") && $TkConfig != ""} {
    puts ". $TkConfig;"
}
puts "TCL_INC_FLAGS=\"$TclIncFlags\";"

exit
