#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "lk.h"

#if defined (HAVE_F_SETLKW)
# undef HAVE_FLOCK
#endif

#ifdef HAVE_FLOCK
# include <sys/file.h>
#endif

#ifdef HAVE_F_SETLKW
# include <unistd.h>
# include <fcntl.h>
#endif

#ifdef HAVE_FLOCK

int lk_lock (int fd, int excl)
{
  return flock (fd, excl ? LOCK_EX : LOCK_SH);
}

int lk_unlock (int fd)
{
  return flock (fd, LOCK_UN);
}

#endif

#ifdef HAVE_F_SETLKW

int lk_lock (int fd, int excl)
{
  struct flock fl;
  
  fl.l_type = excl ? F_WRLCK : F_RDLCK;
  fl.l_whence = SEEK_SET;
  fl.l_start = fl.l_len = 0;

  return fcntl (fd, F_SETLKW, &fl);
}

int lk_unlock (int fd)
{
  struct flock fl;
  
  fl.l_type = F_UNLCK;
  fl.l_whence = SEEK_SET;
  fl.l_start = fl.l_len = 0;
  
  return fcntl (fd, F_SETLK, &fl);
}

#endif

