/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/types.h>
#include <sys/errno.h>
#endif
#include "main.h"

#ifndef RAND_MAX
#define RAND_MAX 2147483647
#endif

extern void check_bandwidth(size_t);

void test_the_net_write(int fd, double *bytes)
{
   double count=0, max=(*statstr)->testbsize;
   size_t rand_count=0;
   size_t bufsize=(unsigned long)(*statstr)->_STDIN_BUFSIZ_ < max ? (*statstr)->_STDIN_BUFSIZ_: max;
   register ssize_t nn=0;
   char *tmp=NULL, *buf=NULL;
   
   /*
    * Select either a random string or a
    * string which bytes are set to zero.
    */
   MEM_CHECK((buf = (char *)calloc(bufsize, sizeof(char))));
   if ((*statstr)->rename) (*statstr)->_RECURS_ = 1;
   if ((*statstr)->_RECURS_) {
      srand(bufsize);
      for (tmp=buf, rand_count=0; rand_count < bufsize; rand_count++, tmp++) {
         *tmp = 1 + (int) (255.0 * rand() / (RAND_MAX + 1.0));
      }
   }

   for (count=max; count > 0; count-=(double)nn, check_bandwidth(nn)) {
      if (count < (double)bufsize) bufsize = (size_t)count;
      if ((nn = write(fd, buf, bufsize)) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_WRITETONET_ERR);
      }
      if ((*statstr)->rename) {
         for (tmp=buf, rand_count=0; rand_count < bufsize; rand_count++, tmp++) {
            *tmp = 1 + (int) (255.0 * rand() / (RAND_MAX + 1.0));
         }
      }
   }
   *bytes = max - count;
   free(buf);
}


void test_the_net_read(int fd, double *ci)
{
   size_t cc=0, bufsize = (*statstr)->_STDIN_BUFSIZ_;
   char *buf=NULL;

   MEM_CHECK((buf = (char *)calloc(bufsize, sizeof(char))));
   for (*ci=cc=0; (cc = read(fd, buf, bufsize)) > 0; *ci+=(double)cc);
   free(buf);
}
