/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-1999 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef Linux
#include <sys/poll.h>
#endif
#if defined HP_UX
#include <poll.h>
#endif
#include <sys/errno.h>
#include <sys/ioctl.h>
#ifdef SunOS_SOLARIS
#include <fcntl.h>
#endif
#include <setjmp.h>
#include "main.h"

extern int reply_from_server(int);
extern void set_tty(int);
extern void free_memory(void);
extern char *time_string(void);
static int set_io_vars(char);
void signal_handling(int);
#if defined HAVE_FASYNC && !defined USE_POSIX_THREAD
void user_handler(int);
#endif
jmp_buf lenv;

void jhandler(int sig)
{
   alarm(0);
   longjmp(lenv, 1);
}

/*
 * handler--handler signals.
 */
void client_handler(int sig)
{
   FILE *fe=stderr;
   char ch='\0';

#if defined HAVE_FASYNC
   (*statstr)->key_pressed = 1;
   if (sig == SIGIO) {
      struct pollfd pfd[1];
      pfd->fd = 0;
      pfd->events = POLLIN;
      pfd->revents = 0;
      while (poll(pfd, 1, 0) > 0) {
         ch = fgetc(stdin);
         pfd->fd = 0;
         pfd->events = POLLIN;
         pfd->revents = 0;
      }
   }
#endif
   if (sig == SIGPIPE || sig == SIGURG) {
      if (slfp) {
         if (sig == SIGURG) reply_from_server(0);
         fprintf(slfp, "\n** Connection closed by foreign host.\n");
         if (pftplog) {
            if ((fe = fopen(pftplog, "a")) != NULL) {
               fprintf(fe, "\n** Connection closed by foreign host.\n");
               fclose(fe);
            }
         }
         fclose(slfp);
      }
      free_memory();
      exit(PFTP_REMOTE_ERR);
   }
   else if (sig == SIGINT || sig == SIGIO) {
#if defined HAVE_FASYNC
      if (sig == SIGIO && (*statstr)->ttys) if (set_io_vars(ch)) return;
#endif
      if (slfp) {
         fprintf(slfp, "\n** Connection was aborded.\n");
         fclose(slfp);
      }
      free_memory();
      exit(PFTP_REMOTE_ERR);
   }
   else if (slfp) fprintf(slfp, "\nUnknown signal %d caught.\n", sig);
}


void server_handler(int sig)
{
   char ch='\0';

#if defined HAVE_FASYNC
   (*statstr)->key_pressed = 1;
   if (sig == SIGIO && (*statstr)->ttys) {
      struct pollfd pfd[1];
      pfd->fd = 0;
      pfd->events = POLLIN;
      pfd->revents = 0;
      while (poll(pfd, 1, 0) > 0) {
         ch = fgetc(stdin);
         pfd->fd = 0;
         pfd->events = POLLIN;
         pfd->revents = 0;
      }
   }
#endif
   if (sig == SIGPIPE) {
      if (slfp) {
         if (!((*statstr)->_PFTP_DAEMON_)) fprintf(slfp, "\n** Connection closed by foreign host.\n");
         else fprintf(slfp, "%s Connection was aborded by foreign host.\n", time_string());
      }
      return;
   }
   else if (sig == SIGINT || sig == SIGIO ) {
#if defined HAVE_FASYNC
      if (sig == SIGIO && (*statstr)->ttys) {
         if ((*statstr)->use_udp && ch == 's') {
            fprintf(slfp, "\r                    \r");
            (*statstr)->show_bytes = !(*statstr)->show_bytes;
            return;
         }
         if (ch != 'q' && ch != '') return;
      }
#endif
#if defined USE_POSIX_THREAD
      if (CHILDNUM > 0) shutdown(s, 2);
#else
      if ((*statstr)->no_clients) shutdown(s, 2);
#endif
      if (slfp) {
#if defined USE_POSIX_THREAD
         if (CHILDNUM > 0)
#else
         if ((*statstr)->no_clients)
#endif
         {
            fprintf(slfp, "\n** Connection was aborded.");
            fprintf(slfp, " There %s %d pending connection%s\n",
#if defined USE_POSIX_THREAD
            CHILDNUM==1? "was": "were", CHILDNUM, CHILDNUM==1? ".":"s.");
#else
            (*statstr)->no_clients==1? "was": "were", \
            (*statstr)->no_clients, (*statstr)->no_clients==1? ".":"s.");
#endif
         }
         else {
            if ((*statstr)->ttys) fprintf(slfp, "\r  \r");
            fprintf(slfp, "\n*** Socket closed. No further connection request detected.\n");
         }
         fclose(slfp);
      }
      free_memory();
#if !defined USE_POSIX_THREAD
      kill(0, SIGINT);
#endif
      exit(PFTP_NO_ERR);
   }
   else if (slfp) fprintf(slfp, "\nUnknown signal %d caught.\n", sig);
}

#if defined HAVE_FASYNC
#if !defined USE_POSIX_THREAD
void user_handler(int sig)
{
   static int set_user_signal=1;
   if (sig == SIGUSR1) {
      if (set_user_signal) {
         signal_handling((SET_SIG_SIGIO | IGN_SIGNAL));
         set_user_signal = 0;
      }
      else {
         signal_handling((SET_SIG_SIGIO | SET_SERVER_HANDLER));
         set_user_signal = 1;
      }
   }
}
#endif

static int set_io_vars(char ch)
{
   if ((*statstr)->new_line) {
      fprintf(slfp, "\n");
      (*statstr)->new_line = 0;
   }
   if ((*statstr)->use_udp && (ch == '=' || ch == '-' || ch == '.' || ch == ',' || ch == ' ')) {
      if (ch == '=') (*statstr)->_BANDWIDTH_ += DEFAULT_BANDWIDTH_INC;
      else if (ch == '-') (*statstr)->_BANDWIDTH_ -= DEFAULT_BANDWIDTH_DEC;
      else if (ch == ',') (*statstr)->_BANDWIDTH_ -= 1;
      else if (ch == '.') (*statstr)->_BANDWIDTH_ += 1;
      else if (ch == ' ') {
         fprintf(slfp, "\r                               \r");
         fprintf(slfp, "\r* Stopped.");
         fgetc(stdin);
         fprintf(slfp, "\r* Running.");
         return 1;
      }
      fprintf(slfp, "\r                               \r");
      fprintf(slfp, "\r* Bandwidth set to %lu.", (*statstr)->_BANDWIDTH_);
      return 1;
   }
   else if ((*statstr)->use_udp && (ch == 'b' || ch == 'h' || ch == '0')) {
      if (!(*statstr)->throw_away) {
         (*statstr)->throw_away = DEFAULT_THROW_AWAY;
      }
      if (ch == 'h') (*statstr)->throw_away += 1;
      else if (ch == 'b') (*statstr)->throw_away -= 1;
      else if (ch == '0') (*statstr)->throw_away = 0;
      fprintf(slfp, "\r                               \r");
      if (ch == '0') {
         fprintf(slfp, "\r* Drop no datagram.");
      }
      else {
         fprintf(slfp, "\r* Drop every %ldth datagram.", (*statstr)->throw_away);
      }
      return 1;
   }
   else if ((*statstr)->use_udp && ch == 'n') {
      (*statstr)->file_skipped = 1;
      return 1;
   }
   else if (ch != 'q' && ch != '') {
      return 1;
   }
   return 0;
}
#endif

void signal_handling(int type)
{
   struct sigaction action;
   sigset_t sigmask;
   int ret=0;

   /*
    * Create signal mask.
    */
   if (sigemptyset(&sigmask) < 0) {
      fprintf(stderr, "** sigemptyset: %s\n", _PFTP_ERROR_ARRAY_);
      exit(PFTP_SIGNALMASK_ERR);
   }
   if (sigfillset(&sigmask) < 0) {
      fprintf(stderr, "** sigfillset: %s\n", _PFTP_ERROR_ARRAY_);
      exit(PFTP_SIGNALMASK_ERR);
   }
   action.sa_mask = sigmask;
#ifdef SA_RESTART
   action.sa_flags = SA_RESTART;
#else
   action.sa_flags = 0;
#endif

   /*
    * Set signal handler.
    */
   if ((type & SET_CLIENT_HANDLER)) {
      action.sa_handler = client_handler;
   }
   else if ((type & SET_SERVER_HANDLER)) {
      action.sa_handler = server_handler;
   }
   else if ((type & DFL_SIGNAL)) {
      action.sa_handler = SIG_DFL;
   }
   else if ((type & IGN_SIGNAL)) {
      action.sa_handler = SIG_IGN;
   }
   else if ((type & SET_SIG_ALARM)) {
      action.sa_handler = jhandler;
   }

   /*
    * Set signal action.
    */
   if ((type & SET_SIGNALS)) {
      if (sigaction(SIGPIPE, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
      if (sigaction(SIGINT, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
      if (sigaction(SIGQUIT, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
   }

   /*
    * Client signal handling.
    */
   if ((type & SET_SIG_CLIENT)) {
#if defined HAVE_FASYNC
      /*
       * Special terminal handle for Linux
       * since Linux supports the FASYNC
       * for a normal tty! Great! :^)
       */
      if (!(*statstr)->_STANDARD_INPUT_ && !(*statstr)->READFROMSTDIN \
         && (*statstr)->ttys) {
         type |= SET_SIG_SIGIO;
         set_tty(2);
         fcntl(0, F_SETOWN, getpid());
         ret = fcntl(0, F_GETFL);
         fcntl(0, F_SETFL, ret | FASYNC);
         setvbuf(stdin, NULL, _IONBF, 0);
      }
#endif
      if (sigaction(SIGURG, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
   }
#if defined HAVE_FASYNC
   /*
    * Server signal handling.
    */
   else if ((type & SET_SIG_SERVER)) {
      if (!(*statstr)->_PFTP_DAEMON_ && (*statstr)->ttys) {
         type |= SET_SIG_SIGIO;
         if ((type & SET_SERVER_HANDLER)) {
            set_tty(2);
            fcntl(0, F_SETOWN, getpid());
            ret = fcntl(0, F_GETFL);
            fcntl(0, F_SETFL, ret | FASYNC);
         }
      }
   }
   if ((type & SET_SIG_SIGIO) && (*statstr)->ttys) {
      if (sigaction(SIGIO, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
   }
#endif
   if ((type & SET_SIG_ALARM)) {
      if (sigaction(SIGALRM, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
   }
#if defined HAVE_FASYNC && !defined USE_POSIX_THREAD
   if ((type & SET_SIG_SERVER) && (*statstr)->ttys) {
      if ((type & SET_SERVER_HANDLER)) action.sa_handler = user_handler;
      else action.sa_handler = SIG_DFL;
      if (sigaction(SIGUSR1, &action, NULL) < 0) {
         fprintf(stderr, "** sigaction: %s\n", _PFTP_ERROR_ARRAY_);
         exit(PFTP_SIGACTION_ERR);
      }
   }
#endif
}
